/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.abandonedrealm.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.abandonedrealm.client.model.ModelZombieVillager;
import net.mcreator.abandonedrealm.client.model.animations.DrownedMutantZombieAnimation;
import net.mcreator.abandonedrealm.client.model.animations.SkeletonAnimation;
import net.mcreator.abandonedrealm.client.model.animations.ZombieVillager2SourceAnimation;
import net.mcreator.abandonedrealm.entity.UndeadVillagerEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class UndeadVillagerRenderer
extends MobRenderer<UndeadVillagerEntity, ModelZombieVillager<UndeadVillagerEntity>> {
    public UndeadVillagerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelZombieVillager.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(UndeadVillagerEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(0.1f, 0.1f, 0.1f);
    }

    public ResourceLocation getTextureLocation(UndeadVillagerEntity entity) {
        return ResourceLocation.parse((String)"eclipsed_dread:textures/entities/zombietextura123.png");
    }

    private static final class AnimatedModel
    extends ModelZombieVillager<UndeadVillagerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<UndeadVillagerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(UndeadVillagerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, ZombieVillager2SourceAnimation.IdleZomb, ageInTicks, 0.5f);
                this.animateWalk(ZombieVillager2SourceAnimation.RunZombie, limbSwing, limbSwingAmount, 8.0f, 2.8f);
                this.animate(entity.animationState2, DrownedMutantZombieAnimation.Heavy_Attack, ageInTicks, 1.0f);
                this.animate(entity.animationState3, SkeletonAnimation.FloatingInTheAir, ageInTicks, 1.0f);
                this.animate(entity.animationState4, ZombieVillager2SourceAnimation.BiteHold, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(UndeadVillagerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

