/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.abandonedrealm.client.renderer;

import net.mcreator.abandonedrealm.client.model.ModelmutatedCannibal;
import net.mcreator.abandonedrealm.client.model.animations.SkeletonAnimation;
import net.mcreator.abandonedrealm.client.model.animations.VampireAnimation;
import net.mcreator.abandonedrealm.client.model.animations.mutatedCannibalAnimation;
import net.mcreator.abandonedrealm.entity.CannibalEntity;
import net.mcreator.abandonedrealm.procedures.RunPlaybackConditionProcedure;
import net.mcreator.abandonedrealm.procedures.WalkPlaybackConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CannibalRenderer
extends MobRenderer<CannibalEntity, LivingEntityRenderState, ModelmutatedCannibal> {
    private CannibalEntity entity = null;

    public CannibalRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelmutatedCannibal.LAYER_LOCATION)), 0.6f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(CannibalEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"eclipsed_dread:textures/entities/cannsatur.png");
    }

    private static final class AnimatedModel
    extends ModelmutatedCannibal {
        private CannibalEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(CannibalEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (WalkPlaybackConditionProcedure.execute((Entity)this.entity)) {
                this.animateWalk(mutatedCannibalAnimation.Walking, state.walkAnimationPos, state.walkAnimationSpeed, 2.9f, 2.6f);
            }
            this.animate(this.entity.animationState1, mutatedCannibalAnimation.Attack, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState2, SkeletonAnimation.FloatingInTheAir, state.ageInTicks, 1.0f);
            if (RunPlaybackConditionProcedure.execute((Entity)this.entity)) {
                this.animateWalk(VampireAnimation.RunLegsOnly, state.walkAnimationPos, state.walkAnimationSpeed, 6.5f, 1.0f);
            }
            this.animate(this.entity.animationState4, mutatedCannibalAnimation.Heavy_Attack, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

