/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.bronze.item;

import com.khazoda.bronze.Constants;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class Sickle
extends DiggerItem {
    public static final TagKey<Block> SICKLE_EFFECTIVE_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Constants.ID("mineable/sickle"));
    public static final TagKey<Block> SICKLE_AOE_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Constants.ID("sickle_aoe"));

    public Sickle(Tier tier, Item.Properties properties) {
        super(tier, SICKLE_EFFECTIVE_BLOCKS, properties);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !(state.getBlock() instanceof CropBlock) && !(state.getBlock() instanceof NetherWartBlock);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Tool tool;
        if (state.is(SICKLE_AOE_BLOCKS)) {
            Sickle.aoeMow(level, miningEntity, state, state, pos, 0);
        }
        if ((tool = (Tool)stack.get(DataComponents.TOOL)) == null) {
            return false;
        }
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && tool.damagePerBlock() > 0) {
            stack.hurtAndBreak(tool.damagePerBlock(), miningEntity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level.isClientSide() || player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if ((state.getBlock() instanceof CropBlock || state.getBlock() instanceof NetherWartBlock) && Sickle.isMature(state)) {
            level.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            player.swing(context.getHand());
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            Sickle.aoeHarvest(level, (LivingEntity)player, state, state, pos, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    private static void aoeMow(Level level, LivingEntity entity, BlockState initialBlockState, BlockState currentBlockState, BlockPos pos, int iteration) {
        if (level.isClientSide()) {
            return;
        }
        if (initialBlockState.is(SICKLE_AOE_BLOCKS)) {
            Block currentBlock = currentBlockState.getBlock();
            if (currentBlockState.is(SICKLE_AOE_BLOCKS)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (level.getBlockState(pos).getBlock() == currentBlock) {
                        currentBlock.playerDestroy(level, player, pos, currentBlockState, null, player.getMainHandItem());
                        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                        ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, currentBlockState), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.2, 0.2, 0.2, 0.1);
                    }
                } else {
                    Block.dropResources((BlockState)currentBlockState, (Level)level, (BlockPos)pos, null, (Entity)entity, (ItemStack)ItemStack.EMPTY);
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
            if (iteration < 4) {
                Sickle.aoeMow(level, entity, initialBlockState, level.getBlockState(pos.east()), pos.east(), iteration + 1);
                Sickle.aoeMow(level, entity, initialBlockState, level.getBlockState(pos.north()), pos.north(), iteration + 1);
                Sickle.aoeMow(level, entity, initialBlockState, level.getBlockState(pos.west()), pos.west(), iteration + 1);
                Sickle.aoeMow(level, entity, initialBlockState, level.getBlockState(pos.south()), pos.south(), iteration + 1);
            }
        }
    }

    private static void aoeHarvest(Level level, LivingEntity entity, BlockState initialBlockState, BlockState currentBlockState, BlockPos pos, int iteration) {
        if (level.isClientSide()) {
            return;
        }
        if (initialBlockState.getBlock() instanceof CropBlock || initialBlockState.getBlock() instanceof NetherWartBlock) {
            boolean isMature;
            IntegerProperty ageProperty = null;
            Block block = initialBlockState.getBlock();
            Objects.requireNonNull(block);
            Block block2 = block;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CropBlock.class, NetherWartBlock.class}, (Object)block2, n)) {
                case 0: {
                    boolean bl;
                    CropBlock cropBlock = (CropBlock)block2;
                    ageProperty = initialBlockState.getProperties().stream().filter(p -> p instanceof IntegerProperty).filter(p -> p.getName().equals("age")).map(p -> (IntegerProperty)p).findFirst().orElse(null);
                    if (ageProperty == null) {
                        bl = false;
                        break;
                    }
                    int currentAge = (Integer)initialBlockState.getValue((Property)ageProperty);
                    if (currentAge >= cropBlock.getMaxAge()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    boolean bl;
                    NetherWartBlock netherWart = (NetherWartBlock)block2;
                    int currentAge = (Integer)initialBlockState.getValue((Property)NetherWartBlock.AGE);
                    ageProperty = NetherWartBlock.AGE;
                    if (currentAge >= 3) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = isMature = false;
                }
            }
            if (!isMature) {
                return;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (level.getBlockState(pos).getBlock() == currentBlockState.getBlock()) {
                    currentBlockState.getBlock().playerDestroy(level, player, pos, currentBlockState, null, player.getMainHandItem());
                    ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, currentBlockState), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.2, 0.2, 0.2, 0.1);
                    Sickle.tryExtraHappyLootChance(level, pos);
                }
            } else {
                Block.dropResources((BlockState)currentBlockState, (Level)level, (BlockPos)pos, null, (Entity)entity, (ItemStack)ItemStack.EMPTY);
            }
            Sickle.replantCrop(level, initialBlockState, pos, ageProperty);
            if (iteration < 2) {
                Sickle.aoeHarvest(level, entity, level.getBlockState(pos.east()), level.getBlockState(pos.east()), pos.east(), iteration + 1);
                Sickle.aoeHarvest(level, entity, level.getBlockState(pos.north()), level.getBlockState(pos.north()), pos.north(), iteration + 1);
                Sickle.aoeHarvest(level, entity, level.getBlockState(pos.west()), level.getBlockState(pos.west()), pos.west(), iteration + 1);
                Sickle.aoeHarvest(level, entity, level.getBlockState(pos.south()), level.getBlockState(pos.south()), pos.south(), iteration + 1);
            }
        }
    }

    private static void tryExtraHappyLootChance(Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            if (level.random.nextInt(50) == 0) {
                int count = level.random.nextInt(4) + 2;
                ItemStack bonemeal = new ItemStack((ItemLike)Items.BONE_MEAL, count);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)bonemeal);
                float randomPitch = 1.0f + level.random.nextFloat() * 0.5f;
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (Holder)SoundEvents.NOTE_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, randomPitch);
            }
            if (level.random.nextInt(150) == 0) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)(switch (level.random.nextInt(4)) {
                    case 0 -> new ItemStack((ItemLike)Items.SPIDER_EYE);
                    case 1 -> new ItemStack((ItemLike)Items.ROTTEN_FLESH);
                    case 2 -> new ItemStack((ItemLike)Items.BONE);
                    default -> new ItemStack((ItemLike)Items.GUNPOWDER);
                }));
                float spookyPitch = 0.8f + level.random.nextFloat() * 0.3f;
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (Holder)SoundEvents.NOTE_BLOCK_BELL, SoundSource.BLOCKS, 1.0f, spookyPitch);
            }
        }
    }

    private static boolean isMature(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(state);
        }
        if (state.getBlock() instanceof NetherWartBlock) {
            return (Integer)state.getValue((Property)NetherWartBlock.AGE) >= 3;
        }
        return false;
    }

    private static void replantCrop(Level level, BlockState state, BlockPos pos, IntegerProperty ageProperty) {
        level.setBlock(pos, (BlockState)state.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0)), 3);
    }
}

