/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.bronze;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.khazoda.bronze.ConfigCommon;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigFabric {
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("bronze.json");
    private static JsonObject root;

    public static <T> T get(ConfigCommon.Config config) {
        if (!root.has(config.key())) {
            return (T)config.def();
        }
        JsonElement e = root.get(config.key());
        return (T)(switch (config.type()) {
            default -> throw new MatchException(null, null);
            case ConfigCommon.Type.BOOL -> e.getAsBoolean();
            case ConfigCommon.Type.NUM -> e.getAsInt();
            case ConfigCommon.Type.STR -> e.getAsString();
        });
    }

    private static void load() {
        try {
            if (Files.notExists(FILE, new LinkOption[0])) {
                root = new JsonObject();
                for (ConfigCommon.Config k : ConfigCommon.ALL_CONFIGS) {
                    String string = k.key();
                    root.add(string, (JsonElement)(switch (k.type()) {
                        default -> throw new MatchException(null, null);
                        case ConfigCommon.Type.BOOL -> new JsonPrimitive((Boolean)k.def());
                        case ConfigCommon.Type.NUM -> new JsonPrimitive((Number)k.def());
                        case ConfigCommon.Type.STR -> new JsonPrimitive((String)k.def());
                    }));
                }
                Files.writeString(FILE, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root), new OpenOption[0]);
            } else {
                root = JsonParser.parseString((String)Files.readString(FILE)).getAsJsonObject();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        ConfigFabric.load();
    }
}

