/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.bronze.registry;

import com.khazoda.bronze.registry.MainRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_109;
import net.minecraft.class_117;
import net.minecraft.class_149;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class LootTableModifier {
    private static final Map<class_5321<class_52>, LootConfig> LOOT_TABLE_CONFIGS = new HashMap<class_5321<class_52>, LootConfig>();

    public static void modifyLootTable(class_2960 id, class_52.class_53 tableBuilder) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)id);
        LootConfig config = LOOT_TABLE_CONFIGS.get(key);
        if (config != null) {
            LootTableModifier.addLootToTable(config, tableBuilder);
        }
    }

    private static void addLootToTable(LootConfig config, class_52.class_53 tableBuilder) {
        ArrayList<class_1792> enchantableItems = new ArrayList<class_1792>();
        ArrayList<class_1792> nonEnchantableItems = new ArrayList<class_1792>();
        for (class_1792 item : config.items()) {
            if (LootTableModifier.isEnchantable(item)) {
                enchantableItems.add(item);
                continue;
            }
            nonEnchantableItems.add(item);
        }
        if (config.enchanted() && !enchantableItems.isEmpty()) {
            class_55.class_56 enchantedPool = LootTableModifier.createBasePoolBuilder(enchantableItems, 1.0f).method_353((class_117.class_118)class_109.method_35520());
            if (config.applyDamage()) {
                LootTableModifier.applyDamage(enchantedPool);
            }
            tableBuilder.method_336(enchantedPool);
            class_55.class_56 normalEnchantablePool = LootTableModifier.createBasePoolBuilder(enchantableItems, 1.0f);
            if (config.applyDamage()) {
                LootTableModifier.applyDamage(normalEnchantablePool);
            }
            tableBuilder.method_336(normalEnchantablePool);
        } else {
            class_55.class_56 pool = LootTableModifier.createBasePoolBuilder(config.items(), 2.0f);
            if (config.applyDamage()) {
                LootTableModifier.applyDamageToEnchantableItems(pool, config.items());
            }
            tableBuilder.method_336(pool);
        }
        if (config.enchanted() && !nonEnchantableItems.isEmpty()) {
            class_55.class_56 nonEnchantablePool = LootTableModifier.createBasePoolBuilder(nonEnchantableItems, 2.0f);
            tableBuilder.method_336(nonEnchantablePool);
        }
    }

    private static class_55.class_56 createBasePoolBuilder(List<class_1792> items, float maxRolls) {
        class_55.class_56 builder = class_55.method_347().method_352((class_5658)class_5662.method_32462((float)0.0f, (float)maxRolls));
        for (class_1792 item : items) {
            builder.method_351((class_79.class_80)class_77.method_411((class_1935)item).method_437(2));
        }
        return builder;
    }

    private static void applyDamage(class_55.class_56 builder) {
        builder.method_353((class_117.class_118)class_149.method_633((class_5658)class_5662.method_32462((float)0.5f, (float)0.8f))).method_35509((class_5658)class_44.method_32448((float)0.5f));
    }

    private static void applyDamageToEnchantableItems(class_55.class_56 builder, List<class_1792> items) {
        boolean hasEnchantableItems = items.stream().anyMatch(LootTableModifier::isEnchantable);
        if (hasEnchantableItems) {
            LootTableModifier.applyDamage(builder);
        }
    }

    private static boolean isEnchantable(class_1792 item) {
        return item.method_57347().method_57832(class_9334.field_50077) || item.method_57347().method_57832(class_9334.field_55878) || item.method_57347().method_57832(class_9334.field_54196);
    }

    static {
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_472, new LootConfig(List.of(MainRegistry.TIN_PICKAXE.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_38438, new LootConfig(List.of(MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_HOE.get()), true, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_24048, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_24047, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_NUGGET.get(), (class_1792)MainRegistry.BRONZE_BLOCK_ITEM.get()), true, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_24046, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get(), (class_1792)MainRegistry.BRONZE_BLOCK_ITEM.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_251, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_INGOT.get()), false, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_47417, new LootConfig(List.of(MainRegistry.BRONZE_AXE.get(), MainRegistry.TIN_AXE.get()), true, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_885, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_274, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_SHOVEL.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_CHESTPLATE.get(), MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_BOOTS.get(), MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get()), false, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_47418, new LootConfig(List.of((class_1792)MainRegistry.BRONZE_BLOCK_ITEM.get(), (class_1792)MainRegistry.TIN_BLOCK_ITEM.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_803, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_615, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_16593, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_50196, new LootConfig(List.of((class_1792)MainRegistry.BRONZE_BLOCK_ITEM.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_49845, new LootConfig(List.of(MainRegistry.BRONZE_AXE.get(), MainRegistry.BRONZE_CHESTPLATE.get()), false, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_24050, new LootConfig(List.of(MainRegistry.BRONZE_NUGGET.get(), MainRegistry.TIN_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_665, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_NUGGET.get(), MainRegistry.TIN_INGOT.get(), MainRegistry.TIN_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_356, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_842, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_CHESTPLATE.get(), MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_BOOTS.get(), MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get()), false, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_800, new LootConfig(List.of(MainRegistry.TIN_PICKAXE.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_17009, new LootConfig(List.of(MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_INGOT.get()), false, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_16749, new LootConfig(List.of(MainRegistry.BRONZE_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_17107, new LootConfig(List.of(MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_SHOVEL.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_434, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_AXE.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_CHESTPLATE.get(), MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_BOOTS.get(), MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get()), false, true));
        LOOT_TABLE_CONFIGS.put((class_5321<class_52>)class_39.field_484, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get()), false, false));
    }

    private record LootConfig(List<class_1792> items, boolean applyDamage, boolean enchanted) {
    }
}

