/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.bronze.registry;

import com.khazoda.bronze.registry.MainRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableModifier {
    private static final Map<ResourceKey<LootTable>, LootConfig> LOOT_TABLE_CONFIGS = new HashMap<ResourceKey<LootTable>, LootConfig>();

    public static void modifyLootTable(ResourceLocation id, LootTable.Builder tableBuilder) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id);
        LootConfig config = LOOT_TABLE_CONFIGS.get(key);
        if (config != null) {
            LootTableModifier.addLootToTable(config, tableBuilder);
        }
    }

    private static void addLootToTable(LootConfig config, LootTable.Builder tableBuilder) {
        ArrayList<Item> enchantableItems = new ArrayList<Item>();
        ArrayList<Item> nonEnchantableItems = new ArrayList<Item>();
        for (Item item : config.items()) {
            if (LootTableModifier.isEnchantable(item)) {
                enchantableItems.add(item);
                continue;
            }
            nonEnchantableItems.add(item);
        }
        if (config.enchanted() && !enchantableItems.isEmpty()) {
            LootPool.Builder enchantedPool = LootTableModifier.createBasePoolBuilder(enchantableItems, 1.0f).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomEnchantment());
            if (config.applyDamage()) {
                LootTableModifier.applyDamage(enchantedPool);
            }
            tableBuilder.withPool(enchantedPool);
            LootPool.Builder normalEnchantablePool = LootTableModifier.createBasePoolBuilder(enchantableItems, 1.0f);
            if (config.applyDamage()) {
                LootTableModifier.applyDamage(normalEnchantablePool);
            }
            tableBuilder.withPool(normalEnchantablePool);
        } else {
            LootPool.Builder pool = LootTableModifier.createBasePoolBuilder(config.items(), 2.0f);
            if (config.applyDamage()) {
                LootTableModifier.applyDamageToEnchantableItems(pool, config.items());
            }
            tableBuilder.withPool(pool);
        }
        if (config.enchanted() && !nonEnchantableItems.isEmpty()) {
            LootPool.Builder nonEnchantablePool = LootTableModifier.createBasePoolBuilder(nonEnchantableItems, 2.0f);
            tableBuilder.withPool(nonEnchantablePool);
        }
    }

    private static LootPool.Builder createBasePoolBuilder(List<Item> items, float maxRolls) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)maxRolls));
        for (Item item : items) {
            builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).setWeight(2));
        }
        return builder;
    }

    private static void applyDamage(LootPool.Builder builder) {
        builder.apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.5f, (float)0.8f))).setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.5f));
    }

    private static void applyDamageToEnchantableItems(LootPool.Builder builder, List<Item> items) {
        boolean hasEnchantableItems = items.stream().anyMatch(LootTableModifier::isEnchantable);
        if (hasEnchantableItems) {
            LootTableModifier.applyDamage(builder);
        }
    }

    private static boolean isEnchantable(Item item) {
        return item.components().has(DataComponents.TOOL) || item.components().has(DataComponents.WEAPON) || item.components().has(DataComponents.EQUIPPABLE);
    }

    static {
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT, new LootConfig(List.of(MainRegistry.TIN_PICKAXE.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.ANCIENT_CITY, new LootConfig(List.of(MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_HOE.get()), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_BRIDGE, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_OTHER, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_NUGGET.get(), (Item)MainRegistry.BRONZE_BLOCK_ITEM.get()), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get(), (Item)MainRegistry.BRONZE_BLOCK_ITEM.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.BURIED_TREASURE, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_INGOT.get()), false, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.TRIAL_CHAMBERS_CORRIDOR, new LootConfig(List.of(MainRegistry.BRONZE_AXE.get(), MainRegistry.TIN_AXE.get()), true, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_SHOVEL.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_CHESTPLATE.get(), MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_BOOTS.get(), MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get()), false, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.TRIAL_CHAMBERS_INTERSECTION, new LootConfig(List.of((Item)MainRegistry.BRONZE_BLOCK_ITEM.get(), (Item)MainRegistry.TIN_BLOCK_ITEM.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.JUNGLE_TEMPLE, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.PILLAGER_OUTPOST, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE, new LootConfig(List.of((Item)MainRegistry.BRONZE_BLOCK_ITEM.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.TRIAL_CHAMBERS_REWARD_RARE, new LootConfig(List.of(MainRegistry.BRONZE_AXE.get(), MainRegistry.BRONZE_CHESTPLATE.get()), false, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL, new LootConfig(List.of(MainRegistry.BRONZE_NUGGET.get(), MainRegistry.TIN_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_TREASURE, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_NUGGET.get(), MainRegistry.TIN_INGOT.get(), MainRegistry.TIN_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON, new LootConfig(List.of(MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CORRIDOR, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_CHESTPLATE.get(), MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_BOOTS.get(), MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get()), false, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.STRONGHOLD_CROSSING, new LootConfig(List.of(MainRegistry.TIN_PICKAXE.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_ARMORER, new LootConfig(List.of(MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_INGOT.get()), false, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TAIGA_HOUSE, new LootConfig(List.of(MainRegistry.BRONZE_NUGGET.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TOOLSMITH, new LootConfig(List.of(MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_SHOVEL.get(), MainRegistry.BRONZE_INGOT.get()), false, false));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_WEAPONSMITH, new LootConfig(List.of(MainRegistry.BRONZE_SWORD.get(), MainRegistry.BRONZE_PICKAXE.get(), MainRegistry.BRONZE_AXE.get(), MainRegistry.BRONZE_INGOT.get(), MainRegistry.BRONZE_HELMET.get(), MainRegistry.BRONZE_CHESTPLATE.get(), MainRegistry.BRONZE_LEGGINGS.get(), MainRegistry.BRONZE_BOOTS.get(), MainRegistry.BRONZE_HORSE_ARMOR.get(), MainRegistry.TIN_HORSE_ARMOR.get()), false, true));
        LOOT_TABLE_CONFIGS.put((ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION, new LootConfig(List.of(MainRegistry.BRONZE_INGOT.get()), false, false));
    }

    private record LootConfig(List<Item> items, boolean applyDamage, boolean enchanted) {
    }
}

