/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.bronze.registry;

import com.khazoda.bronze.BronzeCommon;
import com.khazoda.bronze.Constants;
import com.khazoda.bronze.block.BronzeDoor;
import com.khazoda.bronze.block.BronzeTrapdoor;
import com.khazoda.bronze.block.CutTinSlab;
import com.khazoda.bronze.block.CutTinStairs;
import com.khazoda.bronze.block.TinFramedGlass;
import com.khazoda.bronze.item.FarmersDelightKnife;
import com.khazoda.bronze.item.Sickle;
import com.khazoda.bronze.material.BronzeMaterial;
import com.khazoda.bronze.material.TinMaterial;
import com.khazoda.bronze.registry.helper.Reggie;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.MapColor;

public class MainRegistry {
    private static final Reggie<Block> BLOCK_REGISTRAR = BronzeCommon.REGISTRARS.get(Registries.BLOCK);
    private static final Reggie<Item> ITEM_REGISTRAR = BronzeCommon.REGISTRARS.get(Registries.ITEM);
    private static final TagKey<Block> SICKLE_MINEABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Constants.ID("mineable/sickle"));
    public static final Supplier<Item> RAW_TIN = MainRegistry.registerItem("raw_tin");
    public static final Supplier<Item> TIN_NUGGET = MainRegistry.registerItem("tin_nugget");
    public static final Supplier<Item> TIN_INGOT = MainRegistry.registerItem("tin_ingot");
    public static final Supplier<Item> TIN_HORSE_ARMOR = MainRegistry.registerItem("tin_horse_armor", id -> new Item(new Item.Properties().horseArmor(TinMaterial.ARMOR).setId(id)));
    public static final Supplier<Item> TIN_SWORD = MainRegistry.registerItem("tin_sword", id -> new Item(new Item.Properties().sword(TinMaterial.TOOL, 3.0f, -2.4f).setId(id)));
    public static final Supplier<Item> TIN_AXE = MainRegistry.registerItem("tin_axe", id -> new AxeItem(TinMaterial.TOOL, 7.0f, -3.1f, new Item.Properties().setId(id)));
    public static final Supplier<Item> TIN_PICKAXE = MainRegistry.registerItem("tin_pickaxe", id -> new Item(new Item.Properties().pickaxe(TinMaterial.TOOL, 1.0f, -2.8f).setId(id)));
    public static final Supplier<Item> TIN_SHOVEL = MainRegistry.registerItem("tin_shovel", id -> new ShovelItem(TinMaterial.TOOL, 1.5f, -3.0f, new Item.Properties().setId(id)));
    public static final Supplier<Item> TIN_HOE = MainRegistry.registerItem("tin_hoe", id -> new HoeItem(TinMaterial.TOOL, -2.0f, 0.0f, new Item.Properties().setId(id)));
    public static final Supplier<Item> TIN_HELMET = MainRegistry.registerItem("tin_helmet", id -> new Item(new Item.Properties().humanoidArmor(TinMaterial.ARMOR, ArmorType.HELMET).setId(id)));
    public static final Supplier<Item> TIN_CHESTPLATE = MainRegistry.registerItem("tin_chestplate", id -> new Item(new Item.Properties().humanoidArmor(TinMaterial.ARMOR, ArmorType.CHESTPLATE).setId(id)));
    public static final Supplier<Item> TIN_LEGGINGS = MainRegistry.registerItem("tin_leggings", id -> new Item(new Item.Properties().humanoidArmor(TinMaterial.ARMOR, ArmorType.LEGGINGS).setId(id)));
    public static final Supplier<Item> TIN_BOOTS = MainRegistry.registerItem("tin_boots", id -> new Item(new Item.Properties().humanoidArmor(TinMaterial.ARMOR, ArmorType.BOOTS).setId(id)));
    public static final Supplier<Item> BRONZE_BLEND = MainRegistry.registerItem("bronze_blend");
    public static final Supplier<Item> BRONZE_NUGGET = MainRegistry.registerItem("bronze_nugget");
    public static final Supplier<Item> BRONZE_INGOT = MainRegistry.registerItem("bronze_ingot");
    public static final Supplier<Item> BRONZE_HORSE_ARMOR = MainRegistry.registerItem("bronze_horse_armor", id -> new Item(new Item.Properties().horseArmor(BronzeMaterial.BRONZE).setId(id)));
    public static final Supplier<Item> BRONZE_SWORD = MainRegistry.registerItem("bronze_sword", id -> new Item(new Item.Properties().sword(BronzeMaterial.TOOL, 3.0f, -2.4f).setId(id)));
    public static final Supplier<Item> BRONZE_AXE = MainRegistry.registerItem("bronze_axe", id -> new AxeItem(BronzeMaterial.TOOL, 6.0f, -3.1f, new Item.Properties().setId(id)));
    public static final Supplier<Item> BRONZE_PICKAXE = MainRegistry.registerItem("bronze_pickaxe", id -> new Item(new Item.Properties().pickaxe(BronzeMaterial.TOOL, 1.0f, -2.8f).setId(id)));
    public static final Supplier<Item> BRONZE_SHOVEL = MainRegistry.registerItem("bronze_shovel", id -> new ShovelItem(BronzeMaterial.TOOL, 1.5f, -3.0f, new Item.Properties().setId(id)));
    public static final Supplier<Item> BRONZE_HOE = MainRegistry.registerItem("bronze_hoe", id -> new HoeItem(BronzeMaterial.TOOL, -2.0f, 0.0f, new Item.Properties().setId(id)));
    public static final Supplier<Item> SICKLE = MainRegistry.registerItem("bronze_sickle", id -> new Sickle(new Item.Properties().durability(238).component(DataComponents.TOOL, (Object)Sickle.createToolProperties()).setId(id)));
    public static final Supplier<Item> BRONZE_HELMET = MainRegistry.registerItem("bronze_helmet", id -> new Item(new Item.Properties().humanoidArmor(BronzeMaterial.BRONZE, ArmorType.HELMET).setId(id)));
    public static final Supplier<Item> BRONZE_CHESTPLATE = MainRegistry.registerItem("bronze_chestplate", id -> new Item(new Item.Properties().humanoidArmor(BronzeMaterial.BRONZE, ArmorType.CHESTPLATE).setId(id)));
    public static final Supplier<Item> BRONZE_LEGGINGS = MainRegistry.registerItem("bronze_leggings", id -> new Item(new Item.Properties().humanoidArmor(BronzeMaterial.BRONZE, ArmorType.LEGGINGS).setId(id)));
    public static final Supplier<Item> BRONZE_BOOTS = MainRegistry.registerItem("bronze_boots", id -> new Item(new Item.Properties().humanoidArmor(BronzeMaterial.BRONZE, ArmorType.BOOTS).setId(id)));
    public static Supplier<Item> BRONZE_KNIFE = MainRegistry.registerItem("bronze_knife", id -> new FarmersDelightKnife(FarmersDelightKnife.createProperties((ResourceKey<Item>)id, BronzeMaterial.TOOL)));
    public static Supplier<Item> TIN_KNIFE = MainRegistry.registerItem("tin_knife", id -> new FarmersDelightKnife(FarmersDelightKnife.createProperties((ResourceKey<Item>)id, TinMaterial.TOOL)));
    public static final Supplier<Block> TIN_ORE = MainRegistry.registerBlock("tin_ore_block", 2.5f, 0.0f, MapColor.STONE, NoteBlockInstrument.BASEDRUM, SoundType.STONE);
    public static final Supplier<Block> DEEPSLATE_TIN_ORE = MainRegistry.registerBlock("deepslate_tin_ore_block", 3.5f, 0.0f, MapColor.DEEPSLATE, NoteBlockInstrument.BASEDRUM, SoundType.DEEPSLATE);
    public static final Supplier<Block> RAW_TIN_BLOCK = MainRegistry.registerBlock("raw_tin_block", 2.5f, 6.0f, MapColor.TERRACOTTA_WHITE, NoteBlockInstrument.BASEDRUM, SoundType.COPPER);
    public static final Supplier<Block> TIN_BLOCK = MainRegistry.registerBlock("tin_block", 2.5f, 6.0f, MapColor.TERRACOTTA_WHITE, NoteBlockInstrument.IRON_XYLOPHONE, SoundType.COPPER);
    public static final Supplier<Block> CHISELED_TIN = MainRegistry.registerBlock("chiseled_tin", 2.5f, 6.0f, MapColor.TERRACOTTA_WHITE, NoteBlockInstrument.IRON_XYLOPHONE, SoundType.COPPER);
    public static final Supplier<Block> CUT_TIN = MainRegistry.registerBlock("cut_tin", 2.5f, 6.0f, MapColor.TERRACOTTA_WHITE, NoteBlockInstrument.IRON_XYLOPHONE, SoundType.COPPER);
    public static final Supplier<Block> TIN_TILES = MainRegistry.registerBlock("tin_tiles", 2.5f, 6.0f, MapColor.TERRACOTTA_WHITE, NoteBlockInstrument.IRON_XYLOPHONE, SoundType.COPPER);
    public static final Supplier<Block> BRONZE_BLEND_BLOCK = MainRegistry.registerBlock("bronze_blend_block", 2.5f, 0.0f, MapColor.DIRT, NoteBlockInstrument.BASEDRUM, SoundType.STONE);
    public static final Supplier<Block> BRONZE_BLOCK = MainRegistry.registerBlock("bronze_block", 3.5f, 0.0f, MapColor.GOLD, NoteBlockInstrument.IRON_XYLOPHONE, SoundType.METAL);
    public static final Supplier<Block> TIN_FRAMED_GLASS = MainRegistry.registerBlock("tin_framed_glass", () -> new TinFramedGlass(Constants.blockKey("tin_framed_glass")));
    public static final Supplier<Block> CUT_TIN_SLAB = MainRegistry.registerBlock("cut_tin_slab", () -> new CutTinSlab(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_TIN.get())).setId(Constants.blockKey("cut_tin_slab"))));
    public static final Supplier<Block> CUT_TIN_STAIRS = MainRegistry.registerBlock("cut_tin_stairs", () -> new CutTinStairs(CUT_TIN.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_TIN.get())).setId(Constants.blockKey("cut_tin_stairs"))));
    public static final Supplier<Block> BRONZE_TRAPDOOR = MainRegistry.registerBlock("bronze_trapdoor_block", () -> new BronzeTrapdoor(Constants.blockKey("bronze_trapdoor_block")));
    public static final Supplier<Block> BRONZE_DOOR = MainRegistry.registerBlock("bronze_door_block", () -> new BronzeDoor(Constants.blockKey("bronze_door_block")));
    public static final Supplier<BlockItem> TIN_BLOCK_ITEM = MainRegistry.registerBlockItem("tin_block", TIN_BLOCK);
    public static final Supplier<BlockItem> BRONZE_BLOCK_ITEM = MainRegistry.registerBlockItem("bronze_block", BRONZE_BLOCK);
    public static final Supplier<BlockItem> TIN_ORE_ITEM = MainRegistry.registerBlockItem("tin_ore_block", TIN_ORE);
    public static final Supplier<BlockItem> DEEPSLATE_TIN_ORE_ITEM = MainRegistry.registerBlockItem("deepslate_tin_ore_block", DEEPSLATE_TIN_ORE);
    public static final Supplier<BlockItem> TIN_FRAMED_GLASS_ITEM = MainRegistry.registerBlockItem("tin_framed_glass", TIN_FRAMED_GLASS);
    public static final Supplier<BlockItem> BRONZE_TRAPDOOR_ITEM = MainRegistry.registerBlockItem("bronze_trapdoor_block", BRONZE_TRAPDOOR);
    public static final Supplier<BlockItem> BRONZE_DOOR_ITEM = MainRegistry.registerBlockItem("bronze_door_block", BRONZE_DOOR);
    public static final Supplier<BlockItem> TIN_TILES_ITEM = MainRegistry.registerBlockItem("tin_tiles", TIN_TILES);
    public static final Supplier<BlockItem> BRONZE_BLEND_BLOCK_ITEM = MainRegistry.registerBlockItem("bronze_blend_block", BRONZE_BLEND_BLOCK);
    public static final Supplier<BlockItem> CHISELED_TIN_ITEM = MainRegistry.registerBlockItem("chiseled_tin", CHISELED_TIN);
    public static final Supplier<BlockItem> CUT_TIN_ITEM = MainRegistry.registerBlockItem("cut_tin", CUT_TIN);
    public static final Supplier<BlockItem> RAW_TIN_BLOCK_ITEM = MainRegistry.registerBlockItem("raw_tin_block", RAW_TIN_BLOCK);
    public static final Supplier<BlockItem> CUT_TIN_STAIRS_ITEM = MainRegistry.registerBlockItem("cut_tin_stairs", CUT_TIN_STAIRS);
    public static final Supplier<BlockItem> CUT_TIN_SLAB_ITEM = MainRegistry.registerBlockItem("cut_tin_slab", CUT_TIN_SLAB);
    public static final ResourceKey<PlacedFeature> TIN_ORE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Constants.ID("ore_tin"));
    public static final ResourceKey<PlacedFeature> TIN_ORE_SMALL_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Constants.ID("ore_tin_small"));

    public static void init() {
    }

    private static Supplier<BlockItem> registerBlockItem(String name, Supplier<Block> block) {
        return ITEM_REGISTRAR.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(Constants.itemKey(name))));
    }

    private static Supplier<Item> registerItem(String name) {
        return ITEM_REGISTRAR.register(name, () -> new Item(new Item.Properties().setId(Constants.itemKey(name))));
    }

    private static <T extends Item> Supplier<Item> registerItem(String name, Function<ResourceKey<Item>, T> factory) {
        return ITEM_REGISTRAR.register(name, () -> (Item)factory.apply(Constants.itemKey(name)));
    }

    private static Supplier<Block> registerBlock(String name, Function<ResourceKey<Block>, BlockBehaviour.Properties> props) {
        return BLOCK_REGISTRAR.register(name, () -> new Block((BlockBehaviour.Properties)props.apply(Constants.blockKey(name))));
    }

    private static Supplier<Block> registerBlock(String name, Supplier<Block> supplier) {
        return BLOCK_REGISTRAR.register(name, supplier);
    }

    private static Supplier<Block> registerBlock(String name, float destroyTime, float explosionResistance, MapColor mapColor, NoteBlockInstrument instrument, SoundType soundType) {
        return MainRegistry.registerBlock(name, (ResourceKey<Block> id) -> BlockBehaviour.Properties.of().strength(destroyTime, explosionResistance).mapColor(mapColor).instrument(instrument).sound(soundType).requiresCorrectToolForDrops().setId(id));
    }
}

