/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.hooks.economy;

import cn.superiormc.mythictotem.hooks.economy.AbstractEconomyHook;
import cn.superiormc.mythictotem.managers.ErrorManager;
import com.willfp.ecobits.currencies.Currencies;
import com.willfp.ecobits.currencies.Currency;
import com.willfp.ecobits.currencies.CurrencyUtils;
import java.math.BigDecimal;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyEcoBitsHook
extends AbstractEconomyHook {
    public EconomyEcoBitsHook() {
        super("EcoBits");
    }

    @Override
    public double getEconomy(Player player, String currencyID) {
        Currency currencies = Currencies.getByID((String)currencyID);
        if (currencies == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in EcoBits plugin!");
            return 0.0;
        }
        return CurrencyUtils.getBalance((OfflinePlayer)player, (Currency)currencies).doubleValue();
    }

    @Override
    public void takeEconomy(Player player, double value, String currencyID) {
        Currency currencies = Currencies.getByID((String)currencyID);
        if (currencies == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in EcoBits plugin!");
            return;
        }
        CurrencyUtils.adjustBalance((OfflinePlayer)player, (Currency)currencies, (BigDecimal)BigDecimal.valueOf(-value));
    }

    @Override
    public void giveEconomy(Player player, double value, String currencyID) {
        Currency currencies = Currencies.getByID((String)currencyID);
        if (currencies == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in EcoBits plugin!");
            return;
        }
        CurrencyUtils.adjustBalance((OfflinePlayer)player, (Currency)currencies, (BigDecimal)BigDecimal.valueOf(value));
    }
}

