/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.managers;

import cn.superiormc.mythictotem.objects.actions.AbstractRunAction;
import cn.superiormc.mythictotem.objects.actions.ActionAnnouncement;
import cn.superiormc.mythictotem.objects.actions.ActionAny;
import cn.superiormc.mythictotem.objects.actions.ActionChance;
import cn.superiormc.mythictotem.objects.actions.ActionConditional;
import cn.superiormc.mythictotem.objects.actions.ActionConsoleCommand;
import cn.superiormc.mythictotem.objects.actions.ActionDelay;
import cn.superiormc.mythictotem.objects.actions.ActionEffect;
import cn.superiormc.mythictotem.objects.actions.ActionEntitySpawn;
import cn.superiormc.mythictotem.objects.actions.ActionMessage;
import cn.superiormc.mythictotem.objects.actions.ActionMythicMobsSpawn;
import cn.superiormc.mythictotem.objects.actions.ActionOPCommand;
import cn.superiormc.mythictotem.objects.actions.ActionParticle;
import cn.superiormc.mythictotem.objects.actions.ActionPlayerCommand;
import cn.superiormc.mythictotem.objects.actions.ActionSound;
import cn.superiormc.mythictotem.objects.actions.ActionTeleport;
import cn.superiormc.mythictotem.objects.actions.ActionTitle;
import cn.superiormc.mythictotem.objects.actions.ObjectSingleAction;
import cn.superiormc.mythictotem.objects.checks.ObjectCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ActionManager {
    public static ActionManager actionManager;
    private Map<String, AbstractRunAction> actions;

    public ActionManager() {
        actionManager = this;
        this.initActions();
    }

    private void initActions() {
        this.actions = new HashMap<String, AbstractRunAction>();
        this.registerNewAction("message", new ActionMessage());
        this.registerNewAction("title", new ActionTitle());
        this.registerNewAction("particle", new ActionParticle());
        this.registerNewAction("sound", new ActionSound());
        this.registerNewAction("announcement", new ActionAnnouncement());
        this.registerNewAction("effect", new ActionEffect());
        this.registerNewAction("console_command", new ActionConsoleCommand());
        this.registerNewAction("op_command", new ActionOPCommand());
        this.registerNewAction("player_command", new ActionPlayerCommand());
        this.registerNewAction("teleport", new ActionTeleport());
        this.registerNewAction("entity_spawn", new ActionEntitySpawn());
        this.registerNewAction("chance", new ActionChance());
        this.registerNewAction("delay", new ActionDelay());
        this.registerNewAction("any", new ActionAny());
        this.registerNewAction("mythicmobs_spawn", new ActionMythicMobsSpawn());
        this.registerNewAction("conditional", new ActionConditional());
    }

    public void registerNewAction(String actionID, AbstractRunAction action) {
        if (!this.actions.containsKey(actionID)) {
            this.actions.put(actionID, action);
        }
    }

    public void doAction(ObjectSingleAction action, Player player, Location startLocation, ObjectCheck check, ObjectPlaceCheck totem) {
        for (AbstractRunAction runAction : this.actions.values()) {
            String type = action.getString("type");
            if (!runAction.getType().equals(type)) continue;
            runAction.runAction(action, player, startLocation, check, totem);
        }
    }
}

