/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.managers;

import cn.superiormc.mythictotem.commands.AbstractCommand;
import cn.superiormc.mythictotem.commands.MainCommand;
import cn.superiormc.mythictotem.commands.MainCommandTab;
import cn.superiormc.mythictotem.commands.SubGenerateItemFormat;
import cn.superiormc.mythictotem.commands.SubGiveSaveItem;
import cn.superiormc.mythictotem.commands.SubHelp;
import cn.superiormc.mythictotem.commands.SubList;
import cn.superiormc.mythictotem.commands.SubReload;
import cn.superiormc.mythictotem.commands.SubSave;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;

public class CommandManager {
    public static CommandManager commandManager;
    private final Map<String, AbstractCommand> registeredCommands = new HashMap<String, AbstractCommand>();

    public CommandManager() {
        commandManager = this;
        this.registerBukkitCommands();
        this.registerObjectCommand();
    }

    private void registerBukkitCommands() {
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"mythictotem")).setExecutor((CommandExecutor)new MainCommand());
        Objects.requireNonNull(Bukkit.getPluginCommand((String)"mythictotem")).setTabCompleter((TabCompleter)new MainCommandTab());
    }

    private void registerObjectCommand() {
        this.registerNewSubCommand(new SubGenerateItemFormat());
        this.registerNewSubCommand(new SubHelp());
        this.registerNewSubCommand(new SubList());
        this.registerNewSubCommand(new SubSave());
        this.registerNewSubCommand(new SubReload());
        this.registerNewSubCommand(new SubGiveSaveItem());
    }

    public Map<String, AbstractCommand> getSubCommandsMap() {
        return this.registeredCommands;
    }

    public void registerNewSubCommand(AbstractCommand command) {
        this.registeredCommands.put(command.getId(), command);
    }
}

