/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.managers;

import cn.superiormc.mythictotem.objects.checks.ObjectCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import cn.superiormc.mythictotem.objects.conditions.AbstractCheckCondition;
import cn.superiormc.mythictotem.objects.conditions.ConditionAny;
import cn.superiormc.mythictotem.objects.conditions.ConditionBiome;
import cn.superiormc.mythictotem.objects.conditions.ConditionMobsNear;
import cn.superiormc.mythictotem.objects.conditions.ConditionPermission;
import cn.superiormc.mythictotem.objects.conditions.ConditionPlaceholder;
import cn.superiormc.mythictotem.objects.conditions.ConditionTrigger;
import cn.superiormc.mythictotem.objects.conditions.ConditionTriggerItem;
import cn.superiormc.mythictotem.objects.conditions.ConditionWorld;
import cn.superiormc.mythictotem.objects.conditions.ObjectSingleCondition;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ConditionManager {
    public static ConditionManager conditionManager;
    private Map<String, AbstractCheckCondition> conditions;

    public ConditionManager() {
        conditionManager = this;
        this.initConditions();
    }

    private void initConditions() {
        this.conditions = new HashMap<String, AbstractCheckCondition>();
        this.registerNewCondition("biome", new ConditionBiome());
        this.registerNewCondition("permission", new ConditionPermission());
        this.registerNewCondition("placeholder", new ConditionPlaceholder());
        this.registerNewCondition("world", new ConditionWorld());
        this.registerNewCondition("any", new ConditionAny());
        this.registerNewCondition("mobs_near", new ConditionMobsNear());
        this.registerNewCondition("trigger", new ConditionTrigger());
        this.registerNewCondition("trigger_item", new ConditionTriggerItem());
    }

    public void registerNewCondition(String actionID, AbstractCheckCondition condition) {
        if (!this.conditions.containsKey(actionID)) {
            this.conditions.put(actionID, condition);
        }
    }

    public boolean checkBoolean(ObjectSingleCondition condition, Player player, Location startLocation, ObjectCheck check, ObjectPlaceCheck totem) {
        for (AbstractCheckCondition checkCondition : this.conditions.values()) {
            String type = condition.getString("type");
            if (!checkCondition.getType().equals(type) || checkCondition.checkCondition(condition, player, startLocation, check, totem)) continue;
            return false;
        }
        return true;
    }
}

