/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.managers;

import cn.superiormc.mythictotem.MythicTotem;
import cn.superiormc.mythictotem.managers.ErrorManager;
import cn.superiormc.mythictotem.objects.ObjectTotem;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;

public class ConfigManager {
    public List<Block> getCheckingBlock = Collections.synchronizedList(new ArrayList());
    public List<Player> getCheckingPlayer = new ArrayList<Player>();
    public Map<String, List<ObjectPlaceCheck>> getTotemMaterial = new ConcurrentHashMap<String, List<ObjectPlaceCheck>>();
    public List<Item> getDroppedItems = new ArrayList<Item>();
    public static ConfigManager configManager;
    public FileConfiguration config;
    public Map<String, ObjectTotem> totems = new HashMap<String, ObjectTotem>();
    private int threeDtotemAmount = 0;

    public ConfigManager() {
        configManager = this;
        MythicTotem.instance.saveDefaultConfig();
        this.config = MythicTotem.instance.getConfig();
        this.initTotemConfigs();
    }

    private void initTotemConfigs() {
        File dir = new File(MythicTotem.instance.getDataFolder(), "totems");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.loadTotems(dir);
    }

    private void loadTotems(File folder) {
        File[] files = folder.listFiles();
        if (!Objects.nonNull(files)) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadTotems(file);
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            if (this.totems.containsKey(substring)) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Already loaded a totem config called: " + fileName + "!");
                continue;
            }
            this.totems.put(substring, new ObjectTotem(substring, YamlConfiguration.loadConfiguration((File)file)));
        }
    }

    public Map<String, ObjectTotem> getTotems() {
        return this.totems;
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public long getLong(String path, long defaultValue) {
        return this.config.getLong(path, defaultValue);
    }

    public String getString(String path, String ... args) {
        String s = this.config.getString(path);
        if (s == null) {
            if (args.length == 0) {
                return null;
            }
            s = args[0];
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
        }
        return s.replace("{plugin_folder}", String.valueOf(MythicTotem.instance.getDataFolder()));
    }

    public String getStringOrDefault(String originalPath, String newPath, String defaultValue) {
        return this.config.getString(originalPath, this.config.getString(newPath, defaultValue));
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public void plus3DTotem() {
        ++this.threeDtotemAmount;
    }

    public int getThreeDtotemAmount() {
        return this.threeDtotemAmount;
    }
}

