/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects;

import cn.superiormc.mythictotem.objects.checks.ObjectCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import cn.superiormc.mythictotem.objects.conditions.ObjectSingleCondition;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;

public class ObjectCondition {
    private ConfigurationSection section;
    private final List<ObjectSingleCondition> conditions = new ArrayList<ObjectSingleCondition>();

    public ObjectCondition() {
        this.section = new MemoryConfiguration();
    }

    public ObjectCondition(ConfigurationSection section) {
        this.section = section;
        this.initCondition();
    }

    private void initCondition() {
        if (this.section == null) {
            this.section = new MemoryConfiguration();
            return;
        }
        for (String key : this.section.getKeys(false)) {
            ConfigurationSection singleActionSection = this.section.getConfigurationSection(key);
            if (singleActionSection == null) continue;
            ObjectSingleCondition singleAction = new ObjectSingleCondition(this, singleActionSection);
            this.conditions.add(singleAction);
        }
    }

    public boolean getAllBoolean(Player player, Location startLocation, ObjectCheck check, ObjectPlaceCheck totem) {
        for (ObjectSingleCondition singleCondition : this.conditions) {
            if (singleCondition.checkBoolean(player, startLocation, check, totem)) continue;
            return false;
        }
        return true;
    }

    public boolean getAnyBoolean(Player player, Location startLocation, ObjectCheck check, ObjectPlaceCheck totem) {
        if (player == null) {
            return false;
        }
        for (ObjectSingleCondition singleCondition : this.conditions) {
            if (!singleCondition.checkBoolean(player, startLocation, check, totem)) continue;
            return true;
        }
        return false;
    }
}

