/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects;

import cn.superiormc.mythictotem.managers.ConfigManager;
import cn.superiormc.mythictotem.managers.ErrorManager;
import cn.superiormc.mythictotem.objects.ObjectAction;
import cn.superiormc.mythictotem.objects.ObjectCondition;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import cn.superiormc.mythictotem.utils.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ObjectTotem {
    private int totemRow;
    private int totemColumn;
    private int totemLayer;
    private final Map<String, String> totemLocationMaterial = new HashMap<String, String>();
    private final ObjectAction totemAction;
    private final ObjectCondition totemCondition;
    private final List<String> totemCoreBlocks;
    private final boolean totemDisappear;
    private final String totemCheckMode;
    private final ConfigurationSection totemSection;
    private final String totemID;

    public ObjectTotem(String id, YamlConfiguration section) {
        this.totemID = id;
        this.totemDisappear = section.getBoolean("disappear", true);
        this.totemAction = new ObjectAction(section.getConfigurationSection("actions"));
        this.totemCondition = new ObjectCondition(section.getConfigurationSection("conditions"));
        this.totemCheckMode = section.getString("mode", "VERTICAL").toUpperCase();
        this.totemCoreBlocks = section.getStringList("core-blocks");
        this.totemSection = section;
        ConfigurationSection totemLayoutsExplainConfig = section.getConfigurationSection("explains");
        if (totemLayoutsExplainConfig == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not found any explains option in totem: " + id + ".");
            return;
        }
        Set totemLayoutsExplainList = totemLayoutsExplainConfig.getKeys(false);
        HashMap<String, String> totemLayoutsExplain = new HashMap<String, String>();
        for (String totemLayoutsChar : totemLayoutsExplainList) {
            if (totemLayoutsChar.length() > 1) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Totem " + id + "'s layout explain config keys must be a char, like A.");
                return;
            }
            String totemLayoutsMaterial = totemLayoutsExplainConfig.getString(totemLayoutsChar);
            totemLayoutsMaterial = totemLayoutsMaterial == null ? "none" : totemLayoutsMaterial.toLowerCase();
            totemLayoutsExplain.put(totemLayoutsChar, totemLayoutsMaterial);
        }
        ConfigurationSection layoutsSection = section.getConfigurationSection("layouts");
        if (layoutsSection != null) {
            ConfigManager.configManager.plus3DTotem();
            if (ConfigManager.configManager.getThreeDtotemAmount() > 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Free version can only create up to 3 3D totems, but your totem configs have more then 3 3D totems, please remove, otherwise plugin won't check 3D totems!");
                return;
            }
            HashMap<Integer, List> totemLayouts = new HashMap<Integer, List>();
            int i = 1;
            while (i <= layoutsSection.getKeys(false).size() && !section.getStringList("layouts." + i).isEmpty()) {
                totemLayouts.put(i, section.getStringList("layouts." + i));
                this.totemLayer = i++;
            }
            for (i = 1; i <= totemLayouts.keySet().size(); ++i) {
                this.totemRow = 0;
                for (String s : (List)totemLayouts.get(i)) {
                    this.totemColumn = 0;
                    while (this.totemColumn < s.length()) {
                        char realChar = s.charAt(this.totemColumn);
                        String realString = (String)totemLayoutsExplain.get(String.valueOf(realChar));
                        if (this.totemCoreBlocks.isEmpty() || this.totemCoreBlocks.contains(String.valueOf(realChar))) {
                            if (ConfigManager.configManager.getTotemMaterial.containsKey(realString)) {
                                ConfigManager.configManager.getTotemMaterial.get(realString).add(new ObjectPlaceCheck(this, this.totemRow, this.totemColumn, i));
                            } else {
                                ArrayList<ObjectPlaceCheck> placedBlockCheckManagers = new ArrayList<ObjectPlaceCheck>();
                                placedBlockCheckManagers.add(new ObjectPlaceCheck(this, this.totemRow, this.totemColumn, i));
                                ConfigManager.configManager.getTotemMaterial.put(realString, placedBlockCheckManagers);
                            }
                        }
                        this.totemLocationMaterial.put(this.generateID(i, this.totemRow, this.totemColumn), realString);
                        ++this.totemColumn;
                    }
                    ++this.totemRow;
                }
            }
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded 3D Totem: \u00a7e" + this.totemID + " \u00a7fwith size: " + this.totemRow + "x" + this.totemColumn);
        } else {
            List totemLayout = section.getStringList("layout");
            this.totemRow = 0;
            for (String s : totemLayout) {
                this.totemColumn = 0;
                while (this.totemColumn < s.length()) {
                    char realChar = s.charAt(this.totemColumn);
                    String realString = (String)totemLayoutsExplain.get(String.valueOf(realChar));
                    if (ConfigManager.configManager.getTotemMaterial.containsKey(realString)) {
                        ConfigManager.configManager.getTotemMaterial.get(realString).add(new ObjectPlaceCheck(this, this.totemRow, this.totemColumn));
                    } else {
                        ArrayList<ObjectPlaceCheck> placedBlockCheckManagers = new ArrayList<ObjectPlaceCheck>();
                        placedBlockCheckManagers.add(new ObjectPlaceCheck(this, this.totemRow, this.totemColumn));
                        ConfigManager.configManager.getTotemMaterial.put(realString, placedBlockCheckManagers);
                    }
                    this.totemLocationMaterial.put(this.generateID(1, this.totemRow, this.totemColumn), realString);
                    ++this.totemColumn;
                }
                ++this.totemRow;
            }
            this.totemLayer = 1;
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded 2D Totem: \u00a7e" + this.totemID + " \u00a7fwith size: " + this.totemRow + "x" + this.totemColumn);
        }
    }

    private String generateID(int layer, int row, int column) {
        return layer + ";;" + row + ";;" + column;
    }

    public int getRealRow() {
        return this.totemRow;
    }

    public int getRealColumn() {
        return this.totemColumn;
    }

    public String getRealMaterial(int layer, int row, int column) {
        return this.totemLocationMaterial.get(layer + ";;" + row + ";;" + column);
    }

    public ObjectAction getTotemAction() {
        return this.totemAction;
    }

    public ObjectCondition getTotemCondition() {
        return this.totemCondition;
    }

    public boolean getTotemDisappear() {
        return this.totemDisappear;
    }

    public String getCheckMode() {
        return this.totemCheckMode;
    }

    public int getTotemLayer() {
        return this.totemLayer;
    }

    public ConfigurationSection getSection() {
        return this.totemSection;
    }

    public boolean getKeyMode() {
        return this.totemSection.getBoolean("prices-as-key", false);
    }

    public String getTotemID() {
        return this.totemID;
    }
}

