/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects.actions;

import cn.superiormc.mythictotem.managers.ErrorManager;
import cn.superiormc.mythictotem.objects.actions.ObjectSingleAction;
import cn.superiormc.mythictotem.objects.checks.ObjectCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class AbstractRunAction {
    private final String type;
    private String[] requiredArgs;
    private boolean requirePlayer = true;

    public AbstractRunAction(String type) {
        this.type = type;
    }

    protected void setRequiredArgs(String ... requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    protected void setRequirePlayer(boolean b) {
        this.requirePlayer = b;
    }

    public void runAction(ObjectSingleAction singleAction, Player player, Location startLocation, ObjectCheck check, ObjectPlaceCheck totem) {
        if (player == null && this.requirePlayer) {
            return;
        }
        if (this.requiredArgs != null) {
            for (String arg : this.requiredArgs) {
                if (singleAction.getSection().contains(arg)) continue;
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your action missing required arg: " + arg + ".");
                return;
            }
        }
        this.onDoAction(singleAction, player, startLocation, check, totem);
    }

    protected abstract void onDoAction(ObjectSingleAction var1, Player var2, Location var3, ObjectCheck var4, ObjectPlaceCheck var5);

    public String getType() {
        return this.type;
    }
}

