/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects.checks;

import cn.superiormc.mythictotem.api.TotemActivedEvent;
import cn.superiormc.mythictotem.managers.ConfigManager;
import cn.superiormc.mythictotem.managers.HookManager;
import cn.superiormc.mythictotem.objects.ObjectCondition;
import cn.superiormc.mythictotem.objects.checks.ObjectMaterialCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPriceCheck;
import cn.superiormc.mythictotem.utils.CommonUtil;
import cn.superiormc.mythictotem.utils.SchedulerUtil;
import cn.superiormc.mythictotem.utils.TextUtil;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ObjectCheck {
    private Block block;
    private String parsedID;
    private Player player;
    private Event event;
    private ItemStack item;

    public ObjectCheck(EntityPlaceEvent event) {
        this.event = event;
        this.block = event.getBlock();
        this.player = event.getPlayer();
        if (this.player == null) {
            return;
        }
        this.item = this.player.getInventory().getItemInMainHand();
        this.checkTotem();
    }

    public ObjectCheck(BlockPlaceEvent event) {
        this.event = event;
        this.block = event.getBlockPlaced();
        this.player = event.getPlayer();
        this.item = event.getItemInHand();
        this.checkTotem();
    }

    public ObjectCheck(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        this.event = event;
        this.block = event.getClickedBlock();
        this.player = event.getPlayer();
        this.item = event.getItem();
        this.checkTotem();
    }

    public ObjectCheck(BlockRedstoneEvent event) {
        this.event = event;
        this.block = event.getBlock();
        this.player = null;
        this.item = null;
        this.checkTotem();
    }

    public ObjectCheck(BlockPistonExtendEvent event) {
        this.event = event;
        if (event.getBlocks().isEmpty()) {
            return;
        }
        this.block = ((Block)event.getBlocks().getLast()).getRelative(event.getDirection()).getLocation().getBlock();
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eLocation: " + String.valueOf(this.block.getLocation()));
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eLength: " + event.getBlocks().size());
        }
        this.player = null;
        this.item = null;
        this.checkTotem();
    }

    public ObjectCheck(PlayerDropItemEvent event) {
        this.event = event;
        this.block = event.getItemDrop().getLocation().subtract(new Vector(0, 1, 0)).getBlock();
        if (this.block.isEmpty() || this.block.getBoundingBox().getHeight() >= 1.0) {
            this.block = event.getItemDrop().getLocation().subtract(new Vector(0, 2, 0)).getBlock();
        }
        if (this.block.isEmpty()) {
            if (ConfigManager.configManager.getBoolean("debug", false)) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cSkipped because block is air!");
            }
            return;
        }
        this.player = event.getPlayer();
        this.item = event.getItemDrop().getItemStack();
        ConfigManager.configManager.getDroppedItems.add(event.getItemDrop());
        this.checkTotem();
        ConfigManager.configManager.getDroppedItems.remove(event.getItemDrop());
    }

    public void checkTotem() {
        if (ConfigManager.configManager.getCheckingBlock.contains(this.block)) {
            if (ConfigManager.configManager.getBoolean("debug", false)) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eSkipped checking block!");
            }
            return;
        }
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eBlock Type: " + this.block.getType().name());
        }
        this.initParsedID();
        if (this.parsedID == null) {
            return;
        }
        List<ObjectPlaceCheck> placedBlockCheckManagers = ConfigManager.configManager.getTotemMaterial.get(this.parsedID);
        ConfigManager.configManager.getCheckingBlock.add(this.block);
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eParsed Block ID: " + this.parsedID);
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7c-------------Checking Info-------------");
        }
        block0: for (ObjectPlaceCheck singleTotem : placedBlockCheckManagers) {
            ObjectCondition condition = singleTotem.getTotem().getTotemCondition();
            if (!condition.getAllBoolean(this.player, this.block.getLocation(), this, singleTotem)) {
                if (!ConfigManager.configManager.getBoolean("debug", false)) continue;
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eSkipped " + singleTotem.getTotem().getTotemID() + " because conditions not meet!");
                continue;
            }
            boolean usePrice = false;
            if (usePrice && this.player != null) {
                if (ConfigManager.configManager.getBoolean("debug", false)) {
                    Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eChecking " + singleTotem.getTotem().getTotemID() + " prices...");
                }
                for (String singleSection : singleTotem.getTotem().getSection().getConfigurationSection("prices").getKeys(false)) {
                    ObjectPriceCheck priceManager = new ObjectPriceCheck(singleTotem.getTotem().getSection().getConfigurationSection("prices." + singleSection), this.player, this.block);
                    if (!singleTotem.getTotem().getKeyMode()) {
                        this.item = null;
                        if (ConfigManager.configManager.getBoolean("debug", false)) {
                            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eSet item to null!");
                        }
                    }
                    if (ConfigManager.configManager.getBoolean("debug", false)) {
                        Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eItem: " + String.valueOf(this.item) + "!");
                    }
                    if (priceManager.CheckPrice(false, this.item)) continue;
                    if (!ConfigManager.configManager.getBoolean("debug", false)) continue block0;
                    Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eSkipped " + singleTotem.getTotem().getTotemID() + " because prices not meet!");
                    continue block0;
                }
            }
            if (singleTotem.getTotem().getCheckMode().equals("VERTICAL")) {
                if (ConfigManager.configManager.getBoolean("debug", false)) {
                    Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eStarted " + singleTotem.getTotem().getTotemID() + " VERTICAL totem check!");
                }
                if (!this.verticalTotem(singleTotem)) continue;
                if (!(this.event instanceof PlayerDropItemEvent) || !usePrice) break;
                SchedulerUtil.runSync(() -> ((PlayerDropItemEvent)this.event).getItemDrop().remove());
                break;
            }
            if (ConfigManager.configManager.getBoolean("debug", false)) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7eStarted " + singleTotem.getTotem().getTotemID() + " HORIZONTAL totem check!");
            }
            if (!this.horizontalTotem(singleTotem)) continue;
            if (!(this.event instanceof PlayerDropItemEvent) || !usePrice) break;
            SchedulerUtil.runSync(() -> ((PlayerDropItemEvent)this.event).getItemDrop().remove());
            break;
        }
        ConfigManager.configManager.getCheckingBlock.remove(this.block);
    }

    private boolean verticalTotem(ObjectPlaceCheck singleTotem) {
        int offset_y = singleTotem.getRow();
        int offset_x_or_z = singleTotem.getColumn();
        Location startLocation_1 = new Location(this.block.getWorld(), this.block.getLocation().getX(), this.block.getLocation().getY() + (double)offset_y, this.block.getLocation().getZ() - (double)offset_x_or_z);
        Location startLocation_2 = new Location(this.block.getWorld(), this.block.getLocation().getX(), this.block.getLocation().getY() + (double)offset_y, this.block.getLocation().getZ() + (double)offset_x_or_z);
        Location startLocation_3 = new Location(this.block.getWorld(), this.block.getLocation().getX() - (double)offset_x_or_z, this.block.getLocation().getY() + (double)offset_y, this.block.getLocation().getZ());
        Location startLocation_4 = new Location(this.block.getWorld(), this.block.getLocation().getX() + (double)offset_x_or_z, this.block.getLocation().getY() + (double)offset_y, this.block.getLocation().getZ());
        int base_row = singleTotem.getTotem().getRealRow();
        int base_column = singleTotem.getTotem().getRealColumn();
        int validXNoneBlockAmount1 = 0;
        int validXNoneBlockAmount2 = 0;
        int validZNoneBlockAmount1 = 0;
        int validZNoneBlockAmount2 = 0;
        List<Location> validXTotemBlockLocation1 = Collections.synchronizedList(new ArrayList());
        List<Location> validXTotemBlockLocation2 = Collections.synchronizedList(new ArrayList());
        List<Location> validZTotemBlockLocation1 = Collections.synchronizedList(new ArrayList());
        List<Location> validZTotemBlockLocation2 = Collections.synchronizedList(new ArrayList());
        List<Entity> validXTotemEntity1 = Collections.synchronizedList(new ArrayList());
        List<Entity> validXTotemEntity2 = Collections.synchronizedList(new ArrayList());
        List<Entity> validZTotemEntity1 = Collections.synchronizedList(new ArrayList());
        List<Entity> validZTotemEntity2 = Collections.synchronizedList(new ArrayList());
        boolean checkXTrueOrFalse1 = true;
        boolean checkXTrueOrFalse2 = true;
        boolean checkZTrueOrFalse1 = true;
        boolean checkZTrueOrFalse2 = true;
        for (int i = 0; i < base_row; ++i) {
            for (int b = 0; b < base_column; ++b) {
                Location nowLocation_4;
                Location nowLocation_3;
                Location nowLocation_2;
                Location nowLocation_1 = startLocation_1.clone().add(0.0, (double)(-i), (double)b);
                if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_1)) {
                    checkXTrueOrFalse1 = false;
                }
                if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_2 = startLocation_2.clone().add(0.0, (double)(-i), (double)(-b)))) {
                    checkXTrueOrFalse2 = false;
                }
                if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_3 = startLocation_3.clone().add((double)b, (double)(-i), 0.0))) {
                    checkZTrueOrFalse1 = false;
                }
                if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_4 = startLocation_4.clone().add((double)(-b), (double)(-i), 0.0))) {
                    checkZTrueOrFalse2 = false;
                }
                String material = singleTotem.getTotem().getRealMaterial(1, i, b);
                ObjectMaterialCheck materialManager_1 = new ObjectMaterialCheck(material, nowLocation_1, 1);
                ObjectMaterialCheck materialManager_2 = new ObjectMaterialCheck(material, nowLocation_2, 2);
                ObjectMaterialCheck materialManager_3 = new ObjectMaterialCheck(material, nowLocation_3, 3);
                ObjectMaterialCheck materialManager_4 = new ObjectMaterialCheck(material, nowLocation_4, 4);
                if (!(checkXTrueOrFalse1 || checkXTrueOrFalse2 || checkZTrueOrFalse1 || checkZTrueOrFalse2)) {
                    return false;
                }
                if (checkXTrueOrFalse1 && materialManager_1.checkMaterial()) {
                    if (material.equals("none")) {
                        ++validXNoneBlockAmount1;
                    } else {
                        validXTotemBlockLocation1.add(nowLocation_1);
                        if (materialManager_1.getEntityNeedRemove() != null) {
                            validXTotemEntity1.add(materialManager_1.getEntityNeedRemove());
                        }
                    }
                } else if (checkXTrueOrFalse1 && !materialManager_1.checkMaterial()) {
                    checkXTrueOrFalse1 = false;
                }
                if (checkXTrueOrFalse2 && materialManager_2.checkMaterial()) {
                    if (material.equals("none")) {
                        ++validXNoneBlockAmount2;
                    } else {
                        validXTotemBlockLocation2.add(nowLocation_2);
                        if (materialManager_2.getEntityNeedRemove() != null) {
                            validXTotemEntity2.add(materialManager_2.getEntityNeedRemove());
                        }
                    }
                } else if (checkXTrueOrFalse2 && !materialManager_2.checkMaterial()) {
                    checkXTrueOrFalse2 = false;
                }
                if (checkZTrueOrFalse1 && materialManager_3.checkMaterial()) {
                    if (material.equals("none")) {
                        ++validZNoneBlockAmount1;
                    } else {
                        validZTotemBlockLocation1.add(nowLocation_3);
                        if (materialManager_3.getEntityNeedRemove() != null) {
                            validZTotemEntity1.add(materialManager_3.getEntityNeedRemove());
                        }
                    }
                } else if (checkZTrueOrFalse1 && !materialManager_3.checkMaterial()) {
                    checkZTrueOrFalse1 = false;
                }
                if (checkZTrueOrFalse2 && materialManager_4.checkMaterial()) {
                    if (material.equals("none")) {
                        ++validZNoneBlockAmount2;
                    } else {
                        validZTotemBlockLocation2.add(nowLocation_4);
                        if (materialManager_4.getEntityNeedRemove() != null) {
                            validZTotemEntity2.add(materialManager_4.getEntityNeedRemove());
                        }
                    }
                } else if (checkZTrueOrFalse2 && !materialManager_4.checkMaterial()) {
                    checkZTrueOrFalse2 = false;
                }
                if (validXTotemBlockLocation1.size() == base_row * base_column - validXNoneBlockAmount1) {
                    this.afterCheck(singleTotem, startLocation_1, validXTotemBlockLocation1, validXTotemEntity1);
                    return true;
                }
                if (validXTotemBlockLocation2.size() == base_row * base_column - validXNoneBlockAmount2) {
                    this.afterCheck(singleTotem, startLocation_2, validXTotemBlockLocation2, validXTotemEntity2);
                    return true;
                }
                if (validZTotemBlockLocation1.size() == base_row * base_column - validZNoneBlockAmount1) {
                    this.afterCheck(singleTotem, startLocation_3, validZTotemBlockLocation1, validZTotemEntity1);
                    return true;
                }
                if (validZTotemBlockLocation2.size() != base_row * base_column - validZNoneBlockAmount2) continue;
                this.afterCheck(singleTotem, startLocation_4, validZTotemBlockLocation2, validZTotemEntity2);
                return true;
            }
        }
        return false;
    }

    private boolean horizontalTotem(ObjectPlaceCheck singleTotem) {
        int offset_row = singleTotem.getRow();
        int offset_column = singleTotem.getColumn();
        int offset_layer = singleTotem.getLayer();
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cChecking: " + offset_row + " - " + offset_column + " - " + offset_layer + "!");
        }
        Location startLocation_1 = new Location(this.block.getWorld(), this.block.getLocation().getX() + (double)offset_column, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() + (double)offset_row);
        Location startLocation_2 = new Location(this.block.getWorld(), this.block.getLocation().getX() + (double)offset_column, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() - (double)offset_row);
        Location startLocation_3 = new Location(this.block.getWorld(), this.block.getLocation().getX() - (double)offset_column, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() + (double)offset_row);
        Location startLocation_4 = new Location(this.block.getWorld(), this.block.getLocation().getX() - (double)offset_column, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() - (double)offset_row);
        Location startLocation_5 = new Location(this.block.getWorld(), this.block.getLocation().getX() + (double)offset_row, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() + (double)offset_column);
        Location startLocation_6 = new Location(this.block.getWorld(), this.block.getLocation().getX() + (double)offset_row, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() - (double)offset_column);
        Location startLocation_7 = new Location(this.block.getWorld(), this.block.getLocation().getX() - (double)offset_row, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() + (double)offset_column);
        Location startLocation_8 = new Location(this.block.getWorld(), this.block.getLocation().getX() - (double)offset_row, this.block.getLocation().getY() + (double)offset_layer - 1.0, this.block.getLocation().getZ() - (double)offset_column);
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cStart Location: " + String.valueOf(startLocation_1));
        }
        int base_row = singleTotem.getTotem().getRealRow();
        int base_column = singleTotem.getTotem().getRealColumn();
        int base_layer = singleTotem.getTotem().getTotemLayer();
        int validNoneBlockAmount1 = 0;
        int validNoneBlockAmount2 = 0;
        int validNoneBlockAmount3 = 0;
        int validNoneBlockAmount4 = 0;
        int validNoneBlockAmount5 = 0;
        int validNoneBlockAmount6 = 0;
        int validNoneBlockAmount7 = 0;
        int validNoneBlockAmount8 = 0;
        List<Location> validTotemBlockLocation1 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation2 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation3 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation4 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation5 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation6 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation7 = Collections.synchronizedList(new ArrayList());
        List<Location> validTotemBlockLocation8 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity1 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity2 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity3 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity4 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity5 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity6 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity7 = Collections.synchronizedList(new ArrayList());
        List<Entity> validTotemEntity8 = Collections.synchronizedList(new ArrayList());
        boolean checkTrueOrFalse1 = true;
        boolean checkTrueOrFalse2 = true;
        boolean checkTrueOrFalse3 = true;
        boolean checkTrueOrFalse4 = true;
        boolean checkTrueOrFalse5 = true;
        boolean checkTrueOrFalse6 = true;
        boolean checkTrueOrFalse7 = true;
        boolean checkTrueOrFalse8 = true;
        for (int a = 1; a <= base_layer; ++a) {
            for (int i = 0; i < base_row; ++i) {
                for (int b = 0; b < base_column; ++b) {
                    Location nowLocation_8;
                    Location nowLocation_7;
                    Location nowLocation_6;
                    Location nowLocation_5;
                    Location nowLocation_4;
                    Location nowLocation_3;
                    Location nowLocation_2;
                    Location nowLocation_1 = startLocation_1.clone().add((double)(-b), (double)(1 - a), (double)(-i));
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_1)) {
                        checkTrueOrFalse1 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_2 = startLocation_2.clone().add((double)(-b), (double)(1 - a), (double)i))) {
                        checkTrueOrFalse2 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_3 = startLocation_3.clone().add((double)b, (double)(1 - a), (double)(-i)))) {
                        checkTrueOrFalse3 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_4 = startLocation_4.clone().add((double)b, (double)(1 - a), (double)i))) {
                        checkTrueOrFalse4 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_5 = startLocation_5.clone().add((double)(-i), (double)(1 - a), (double)(-b)))) {
                        checkTrueOrFalse5 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_6 = startLocation_6.clone().add((double)(-i), (double)(1 - a), (double)b))) {
                        checkTrueOrFalse6 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_7 = startLocation_7.clone().add((double)i, (double)(1 - a), (double)(-b)))) {
                        checkTrueOrFalse7 = false;
                    }
                    if (!HookManager.hookManager.getProtectionCanUse(this.player, nowLocation_8 = startLocation_8.clone().add((double)i, (double)(1 - a), (double)b))) {
                        checkTrueOrFalse8 = false;
                    }
                    String material = singleTotem.getTotem().getRealMaterial(a, i, b);
                    if (ConfigManager.configManager.getBoolean("debug", false)) {
                        Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cMaterial should be: " + material);
                    }
                    ObjectMaterialCheck materialManager_1 = new ObjectMaterialCheck(material, nowLocation_1, 1);
                    ObjectMaterialCheck materialManager_2 = new ObjectMaterialCheck(material, nowLocation_2, 2);
                    ObjectMaterialCheck materialManager_3 = new ObjectMaterialCheck(material, nowLocation_3, 3);
                    ObjectMaterialCheck materialManager_4 = new ObjectMaterialCheck(material, nowLocation_4, 4);
                    ObjectMaterialCheck materialManager_5 = new ObjectMaterialCheck(material, nowLocation_5, 5);
                    ObjectMaterialCheck materialManager_6 = new ObjectMaterialCheck(material, nowLocation_6, 6);
                    ObjectMaterialCheck materialManager_7 = new ObjectMaterialCheck(material, nowLocation_7, 7);
                    ObjectMaterialCheck materialManager_8 = new ObjectMaterialCheck(material, nowLocation_8, 8);
                    if (!(checkTrueOrFalse1 || checkTrueOrFalse2 || checkTrueOrFalse3 || checkTrueOrFalse4 || checkTrueOrFalse5 || checkTrueOrFalse6 || checkTrueOrFalse7 || checkTrueOrFalse8)) {
                        return false;
                    }
                    if (checkTrueOrFalse1 && materialManager_1.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount1;
                        } else {
                            validTotemBlockLocation1.add(nowLocation_1);
                            if (materialManager_1.getEntityNeedRemove() != null) {
                                validTotemEntity1.add(materialManager_1.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse1 && !materialManager_1.checkMaterial()) {
                        checkTrueOrFalse1 = false;
                    }
                    if (checkTrueOrFalse2 && materialManager_2.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount2;
                        } else {
                            validTotemBlockLocation2.add(nowLocation_2);
                            if (materialManager_2.getEntityNeedRemove() != null) {
                                validTotemEntity2.add(materialManager_2.getEntityNeedRemove());
                            }
                        }
                        if (ConfigManager.configManager.getBoolean("debug", false)) {
                            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cRule 2 Size: " + validTotemBlockLocation2.size());
                        }
                    } else if (checkTrueOrFalse2 && !materialManager_2.checkMaterial()) {
                        checkTrueOrFalse2 = false;
                    }
                    if (checkTrueOrFalse3 && materialManager_3.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount3;
                        } else {
                            validTotemBlockLocation3.add(nowLocation_3);
                            if (materialManager_3.getEntityNeedRemove() != null) {
                                validTotemEntity3.add(materialManager_3.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse3 && !materialManager_3.checkMaterial()) {
                        checkTrueOrFalse3 = false;
                    }
                    if (checkTrueOrFalse4 && materialManager_4.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount4;
                        } else {
                            validTotemBlockLocation4.add(nowLocation_4);
                            if (materialManager_4.getEntityNeedRemove() != null) {
                                validTotemEntity4.add(materialManager_4.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse4 && !materialManager_4.checkMaterial()) {
                        checkTrueOrFalse4 = false;
                    }
                    if (checkTrueOrFalse5 && materialManager_5.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount5;
                        } else {
                            validTotemBlockLocation5.add(nowLocation_5);
                            if (materialManager_5.getEntityNeedRemove() != null) {
                                validTotemEntity5.add(materialManager_5.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse5 && !materialManager_5.checkMaterial()) {
                        checkTrueOrFalse5 = false;
                    }
                    if (checkTrueOrFalse6 && materialManager_6.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount6;
                        } else {
                            validTotemBlockLocation6.add(nowLocation_6);
                            if (materialManager_6.getEntityNeedRemove() != null) {
                                validTotemEntity6.add(materialManager_6.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse6 && !materialManager_6.checkMaterial()) {
                        checkTrueOrFalse6 = false;
                    }
                    if (checkTrueOrFalse7 && materialManager_7.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount7;
                        } else {
                            validTotemBlockLocation7.add(nowLocation_7);
                            if (materialManager_7.getEntityNeedRemove() != null) {
                                validTotemEntity7.add(materialManager_7.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse7 && !materialManager_7.checkMaterial()) {
                        checkTrueOrFalse7 = false;
                    }
                    if (checkTrueOrFalse8 && materialManager_8.checkMaterial()) {
                        if (material.equals("none")) {
                            ++validNoneBlockAmount8;
                        } else {
                            validTotemBlockLocation8.add(nowLocation_8);
                            if (materialManager_8.getEntityNeedRemove() != null) {
                                validTotemEntity8.add(materialManager_8.getEntityNeedRemove());
                            }
                        }
                    } else if (checkTrueOrFalse8 && !materialManager_8.checkMaterial()) {
                        checkTrueOrFalse8 = false;
                    }
                    if (validTotemBlockLocation1.size() == base_row * base_column * base_layer - validNoneBlockAmount1) {
                        this.afterCheck(singleTotem, startLocation_1, validTotemBlockLocation1, validTotemEntity1);
                        return true;
                    }
                    if (validTotemBlockLocation2.size() == base_row * base_column * base_layer - validNoneBlockAmount2) {
                        this.afterCheck(singleTotem, startLocation_2, validTotemBlockLocation2, validTotemEntity2);
                        return true;
                    }
                    if (validTotemBlockLocation3.size() == base_row * base_column * base_layer - validNoneBlockAmount3) {
                        this.afterCheck(singleTotem, startLocation_3, validTotemBlockLocation3, validTotemEntity3);
                        return true;
                    }
                    if (validTotemBlockLocation4.size() == base_row * base_column * base_layer - validNoneBlockAmount4) {
                        this.afterCheck(singleTotem, startLocation_4, validTotemBlockLocation4, validTotemEntity4);
                        return true;
                    }
                    if (validTotemBlockLocation5.size() == base_row * base_column * base_layer - validNoneBlockAmount5) {
                        this.afterCheck(singleTotem, startLocation_5, validTotemBlockLocation5, validTotemEntity5);
                        return true;
                    }
                    if (validTotemBlockLocation6.size() == base_row * base_column * base_layer - validNoneBlockAmount6) {
                        this.afterCheck(singleTotem, startLocation_6, validTotemBlockLocation6, validTotemEntity6);
                        return true;
                    }
                    if (validTotemBlockLocation7.size() == base_row * base_column * base_layer - validNoneBlockAmount7) {
                        this.afterCheck(singleTotem, startLocation_7, validTotemBlockLocation7, validTotemEntity7);
                        return true;
                    }
                    if (validTotemBlockLocation8.size() != base_row * base_column * base_layer - validNoneBlockAmount8) continue;
                    this.afterCheck(singleTotem, startLocation_8, validTotemBlockLocation8, validTotemEntity8);
                    return true;
                }
            }
        }
        return false;
    }

    private void afterCheck(ObjectPlaceCheck singleTotem, Location startLocation, List<Location> validTotemBlockLocation, Collection<Entity> needRemoveEntities) {
        ConfigManager.configManager.getCheckingBlock.remove(this.block);
        ConfigurationSection priceSection = singleTotem.getTotem().getSection().getConfigurationSection("prices");
        SchedulerUtil.runSync(() -> {
            if (singleTotem.getTotem().getTotemDisappear()) {
                for (Location loc : validTotemBlockLocation) {
                    CommonUtil.removeBlock(loc.getBlock());
                }
            }
            if (this.event instanceof EntityPlaceEvent) {
                ((EntityPlaceEvent)this.event).getEntity().remove();
            }
            for (Entity singleEntity : needRemoveEntities) {
                singleEntity.remove();
            }
            singleTotem.getTotem().getTotemAction().runAllActions(this.player, startLocation, this, singleTotem);
            TotemActivedEvent totemActivedEvent = new TotemActivedEvent(singleTotem.getTotem().getTotemID(), this.player, this.block.getLocation());
            Bukkit.getPluginManager().callEvent((Event)totemActivedEvent);
        });
    }

    private void initParsedID() {
        if (CommonUtil.checkPluginLoad("ItemsAdder") && dev.lone.itemsadder.api.CustomBlock.byAlreadyPlaced((Block)this.block) != null && ConfigManager.configManager.getTotemMaterial.containsKey("itemsadder:" + dev.lone.itemsadder.api.CustomBlock.byAlreadyPlaced((Block)this.block).getNamespacedID())) {
            this.parsedID = "itemsadder:" + dev.lone.itemsadder.api.CustomBlock.byAlreadyPlaced((Block)this.block).getNamespacedID();
        }
        if (this.parsedID == null && CommonUtil.checkPluginLoad("Oraxen") && OraxenBlocks.isOraxenBlock((Block)this.block)) {
            NoteBlockMechanic noteBlockMechanic = OraxenBlocks.getNoteBlockMechanic((Block)this.block);
            StringBlockMechanic stringBlockMechanic = OraxenBlocks.getStringMechanic((Block)this.block);
            if (noteBlockMechanic != null && noteBlockMechanic.getItemID() != null && ConfigManager.configManager.getTotemMaterial.containsKey("oraxen:" + OraxenBlocks.getNoteBlockMechanic((Block)this.block).getItemID())) {
                this.parsedID = "oraxen:" + OraxenBlocks.getNoteBlockMechanic((Block)this.block).getItemID();
            } else if (stringBlockMechanic != null && stringBlockMechanic.getItemID() != null && ConfigManager.configManager.getTotemMaterial.containsKey("oraxen:" + OraxenBlocks.getStringMechanic((Block)this.block).getItemID())) {
                this.parsedID = "oraxen:" + OraxenBlocks.getStringMechanic((Block)this.block).getItemID();
            }
        }
        if (this.parsedID == null && CommonUtil.checkPluginLoad("MMOItems") && MMOItems.plugin.getCustomBlocks().getFromBlock(this.block.getBlockData()).isPresent() && ConfigManager.configManager.getTotemMaterial.containsKey("mmoitems:" + ((CustomBlock)MMOItems.plugin.getCustomBlocks().getFromBlock(this.block.getBlockData()).get()).getId())) {
            this.parsedID = "mmoitems:" + ((CustomBlock)MMOItems.plugin.getCustomBlocks().getFromBlock(this.block.getBlockData()).get()).getId();
        }
        if (this.parsedID == null && ConfigManager.configManager.getTotemMaterial.containsKey("minecraft:" + this.block.getType().toString().toLowerCase())) {
            this.parsedID = "minecraft:" + this.block.getType().toString().toLowerCase();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getEvent() {
        return this.event.getEventName();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Block getBlock() {
        return this.block;
    }
}

