/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects.checks;

import cn.superiormc.mythictotem.managers.ConfigManager;
import cn.superiormc.mythictotem.utils.TextUtil;
import com.google.common.base.Enums;
import dev.lone.itemsadder.api.CustomBlock;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class ObjectMaterialCheck {
    private final String materialString;
    private final Location location;
    private Entity entity;
    private final int id;

    public ObjectMaterialCheck(@NotNull String materialString, @NotNull Location location, int id) {
        this.materialString = materialString;
        this.location = location;
        this.id = id;
    }

    public boolean checkMaterial() {
        String[] tempVal1 = this.materialString.split(":");
        if (this.materialString.equals("none")) {
            if (ConfigManager.configManager.getBoolean("debug", false)) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fSkipped none block.");
            }
            return true;
        }
        if (this.materialString.startsWith("minecraft:")) {
            try {
                Material material = Material.getMaterial((String)tempVal1[1].toUpperCase());
                EntityType entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)"ZOMBIE").orNull();
                if (material != null) {
                    Block block = this.location.getBlock();
                    if (ConfigManager.configManager.getBoolean("debug", false)) {
                        Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fShould be: " + this.materialString + ", real block: " + block.getType().name() + ", location: " + String.valueOf(this.location) + ", ID: " + this.id + ".");
                    }
                    return material == block.getType();
                }
                return false;
            }
            catch (IllegalArgumentException | NullPointerException material) {}
        } else if (this.materialString.startsWith("itemsadder:")) {
            try {
                Block block = this.location.getBlock();
                if (this.materialString.split(":").length != 3) {
                    Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7cError: Your itemsadder material does not meet the format claimed in plugin Wiki!");
                    return false;
                }
                CustomBlock iaBlock = CustomBlock.byAlreadyPlaced((Block)block);
                if (iaBlock == null) {
                    return false;
                }
                return (tempVal1[1] + ":" + tempVal1[2]).equals(iaBlock.getNamespacedID());
            }
            catch (NullPointerException iaBlock) {}
        } else {
            if (this.materialString.startsWith("itemsadder_furniture:")) {
                // empty if block
            }
            if (this.materialString.startsWith("itemsadder_mob:")) {
                // empty if block
            }
            if (this.materialString.startsWith("oraxen:")) {
                try {
                    Block block = this.location.getBlock();
                    NoteBlockMechanic tempVal4 = OraxenBlocks.getNoteBlockMechanic((Block)block);
                    StringBlockMechanic tempVal2 = OraxenBlocks.getStringMechanic((Block)block);
                    BlockMechanic tempVal3 = OraxenBlocks.getBlockMechanic((Block)block);
                    if (tempVal3 != null && tempVal1[1].equals(tempVal3.getItemID())) {
                        return true;
                    }
                    if (tempVal2 != null && tempVal1[1].equals(tempVal2.getItemID())) {
                        return true;
                    }
                    if (tempVal4 != null && tempVal1[1].equals(tempVal4.getItemID())) {
                        return true;
                    }
                }
                catch (NullPointerException tempVal4) {}
            } else {
                if (this.materialString.startsWith("oraxen_furniture:")) {
                    // empty if block
                }
                if (this.materialString.startsWith("mmoitems:")) {
                    Block block = this.location.getBlock();
                    Optional opt = MMOItems.plugin.getCustomBlocks().getFromBlock(block.getBlockData());
                    return opt.filter(customBlock -> customBlock.getId() == Integer.parseInt(this.materialString.split(":")[1])).isPresent();
                }
                Block block = this.location.getBlock();
                try {
                    return Material.getMaterial((String)tempVal1[1].toUpperCase()) == block.getType();
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public Entity getEntityNeedRemove() {
        return this.entity;
    }
}

