/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects.checks;

import cn.superiormc.mythictotem.hooks.ItemPriceUtil;
import cn.superiormc.mythictotem.managers.ConfigManager;
import cn.superiormc.mythictotem.managers.ErrorManager;
import cn.superiormc.mythictotem.managers.HookManager;
import cn.superiormc.mythictotem.methods.BuildItem;
import cn.superiormc.mythictotem.utils.CommonUtil;
import cn.superiormc.mythictotem.utils.SchedulerUtil;
import cn.superiormc.mythictotem.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ObjectPriceCheck {
    private final ConfigurationSection section;
    private final Player player;
    private final Block block;
    private final String type;

    public ObjectPriceCheck(ConfigurationSection section, Player player, Block block) {
        this.section = section;
        this.player = player;
        this.block = block;
        this.type = section == null ? "unknown" : (section.contains("hook-plugin") && section.contains("hook-item") ? "hook" : (section.contains("match-item") && CommonUtil.checkPluginLoad("MythicChanger") ? "match" : (section.contains("material") ? "vanilla" : (section.contains("economy-plugin") ? "economy" : (section.contains("economy-type") && !section.contains("economy-plugin") ? "exp" : (section.getBoolean("block-as-price") ? "block" : "free"))))));
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7aPrice Type: " + this.type + "!");
        }
    }

    public boolean CheckPrice(boolean take, ItemStack keyItems) {
        if (ConfigManager.configManager.getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7aKey Item: " + String.valueOf(keyItems) + "!");
        }
        boolean priceBoolean = false;
        switch (this.type) {
            case "free": {
                priceBoolean = true;
                break;
            }
            case "block": {
                SchedulerUtil.runSync(() -> CommonUtil.removeBlock(this.block));
                break;
            }
            case "hook": {
                priceBoolean = ItemPriceUtil.getPrice(this.section.getString("hook-plugin"), this.section.getString("hook-item"), this.player, this.section.getInt("amount", 1), take, keyItems);
                break;
            }
            case "match": {
                priceBoolean = ItemPriceUtil.getPrice(this.player, this.section, this.section.getInt("amount", 1), take);
                break;
            }
            case "vanilla": {
                priceBoolean = ItemPriceUtil.getPrice(this.player, BuildItem.buildItemStack(this.player, this.section, 1, new String[0]), this.section.getInt("amount", 1), take, keyItems);
                break;
            }
            case "economy": {
                priceBoolean = HookManager.hookManager.getPrice(this.player, this.section.getString("economy-plugin"), this.section.getString("economy-type", "default"), this.section.getDouble("amount", 0.0), take);
                break;
            }
            case "exp": {
                priceBoolean = HookManager.hookManager.getPrice(this.player, this.section.getString("economy-type"), this.section.getInt("amount", 0), take);
                break;
            }
            case "unknwon": {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: There is something wrong in your totem configs!");
            }
        }
        return priceBoolean;
    }
}

