/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.objects.conditions;

import cn.superiormc.mythictotem.managers.ErrorManager;
import cn.superiormc.mythictotem.objects.checks.ObjectCheck;
import cn.superiormc.mythictotem.objects.checks.ObjectPlaceCheck;
import cn.superiormc.mythictotem.objects.conditions.ObjectSingleCondition;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class AbstractCheckCondition {
    private final String type;
    private String[] requiredArgs;
    private boolean requirePlayer = true;

    public AbstractCheckCondition(String type) {
        this.type = type;
    }

    protected void setRequiredArgs(String ... requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    protected void setRequirePlayer(boolean b) {
        this.requirePlayer = b;
    }

    public boolean checkCondition(ObjectSingleCondition singleCondition, Player player, Location startLocation, ObjectCheck check, ObjectPlaceCheck totem) {
        if (player == null && this.requirePlayer) {
            return false;
        }
        if (this.requiredArgs != null) {
            for (String arg : this.requiredArgs) {
                if (singleCondition.getSection().contains(arg)) continue;
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your condition missing required arg: " + arg + ".");
                return true;
            }
        }
        return this.onCheckCondition(singleCondition, player, startLocation, check, totem);
    }

    protected abstract boolean onCheckCondition(ObjectSingleCondition var1, Player var2, Location var3, ObjectCheck var4, ObjectPlaceCheck var5);

    public String getType() {
        return this.type;
    }
}

