/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.paper;

import cn.superiormc.mythictotem.paper.utils.PaperTextUtil;
import cn.superiormc.mythictotem.utils.CommonUtil;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.base.Enums;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import io.papermc.paper.datacomponent.item.BlocksAttacks;
import io.papermc.paper.datacomponent.item.BundleContents;
import io.papermc.paper.datacomponent.item.ChargedProjectiles;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.DamageResistant;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.Enchantable;
import io.papermc.paper.datacomponent.item.Fireworks;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ItemArmorTrim;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.JukeboxPlayable;
import io.papermc.paper.datacomponent.item.OminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.datacomponent.item.SuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.datacomponent.item.UseCooldown;
import io.papermc.paper.datacomponent.item.UseRemainder;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.JukeboxSong;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class BuildItemPaper {
    public static ItemStack buildItemStack(Player player, ConfigurationSection section, int amount, String ... args) {
        ItemStack item = new ItemStack(Material.STONE);
        return BuildItemPaper.editItemStack(item, player, section, amount, args);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static ItemStack editItemStack(ItemStack item, Player player, ConfigurationSection section, int amount, String ... args) {
        ConfigurationSection consumableKey;
        ConfigurationSection useReminderKey;
        String breakSoundKey;
        ConfigurationSection blocksAttacksKey;
        int cooldownSeconds;
        ConfigurationSection useCooldown;
        String tooltipStyle;
        String itemModel;
        int enchantable;
        int repairCost;
        MusicInstrument musicInstrument;
        String musicKey;
        int ominousPowerKey;
        ConfigurationSection bundleContentKey;
        List suspiciousStewEffects;
        ConfigurationSection fireworkKey;
        String skullTextureNameKey;
        String patternKey;
        String patternColorKey;
        String baseColorKey;
        Axolotl.Variant variant;
        String variantStr;
        String colorKey;
        ConfigurationSection trimKey;
        ConfigurationSection chargedProjectilesKey;
        ConfigurationSection potionKey;
        ConfigurationSection bannerPatternsKey;
        ConfigurationSection storedEnchantsKey;
        int maxDamageKey;
        int damageKey;
        ConfigurationSection attributesKey;
        ConfigurationSection enchantsKey;
        List itemFlagKey;
        String rarityKey;
        String song;
        ConfigurationSection toolKey;
        ConfigurationSection foodKey;
        int maxStackKey;
        ConfigurationSection customModelDataSection;
        List lores;
        String itemNameKey;
        String displayNameKey;
        if (amount > 0) {
            item.setAmount(amount);
        }
        if ((displayNameKey = section.getString("name", section.getString("display"))) != null) {
            item.setData(DataComponentTypes.CUSTOM_NAME, (Object)PaperTextUtil.modernParse(displayNameKey, player));
        }
        if ((itemNameKey = section.getString("item-name")) != null) {
            item.setData(DataComponentTypes.ITEM_NAME, (Object)PaperTextUtil.modernParse(itemNameKey, player));
        }
        if (!(lores = section.getStringList("lore")).isEmpty()) {
            ItemLore.Builder builder = ItemLore.lore();
            for (Object lore : lores) {
                lore = CommonUtil.modifyString((String)lore, args);
                for (String singleLore : ((String)lore).split("\n")) {
                    builder.addLine((ComponentLike)PaperTextUtil.modernParse(singleLore, player));
                }
            }
            item.setData(DataComponentTypes.LORE, (Object)((ItemLore)builder.build()));
        }
        if ((customModelDataSection = section.getConfigurationSection("custom-model-data")) != null) {
            CustomModelData.Builder builder = CustomModelData.customModelData();
            for (String customModelDataType : customModelDataSection.getKeys(false)) {
                switch (customModelDataType = customModelDataType.toLowerCase()) {
                    case "float": {
                        builder.addFloats(customModelDataSection.getFloatList("float"));
                    }
                    case "flag": {
                        builder.addFlags(customModelDataSection.getBooleanList("flag"));
                    }
                    case "string": {
                        builder.addStrings(customModelDataSection.getStringList("string"));
                    }
                    case "color": {
                        builder.addColors(CommonUtil.parseColorList(customModelDataSection.getStringList("color")));
                    }
                }
            }
            item.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)builder.build()));
        }
        if ((maxStackKey = section.getInt("max-stack", -1)) > 0 && maxStackKey < 100) {
            item.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)maxStackKey);
        }
        if ((foodKey = section.getConfigurationSection("food")) != null) {
            double foodSaturation;
            int foodNutrition;
            FoodProperties.Builder builder = FoodProperties.food();
            if (foodKey.contains("can-always-eat")) {
                builder.canAlwaysEat(foodKey.getBoolean("can-always-eat"));
            }
            if ((foodNutrition = foodKey.getInt("nutrition", -1)) > 0) {
                builder.nutrition(foodNutrition);
            }
            if ((foodSaturation = foodKey.getDouble("saturation", -1.0)) > 0.0) {
                builder.saturation((float)foodSaturation);
            }
            item.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)builder.build()));
        }
        if ((toolKey = section.getConfigurationSection("tool")) != null) {
            double miningSpeed;
            Tool.Builder builder = Tool.tool();
            int damagePerBlock = toolKey.getInt("damage-per-block", -1);
            if (damagePerBlock >= 0) {
                builder.damagePerBlock(damagePerBlock);
            }
            if ((miningSpeed = toolKey.getDouble("mining-speed", -1.0)) > 0.0) {
                builder.defaultMiningSpeed((float)miningSpeed);
            }
            if (toolKey.contains("destroy-blocks-in-creative")) {
                builder.canDestroyBlocksInCreative(toolKey.getBoolean("destroy-blocks-in-creative"));
            }
            for (String rules : toolKey.getStringList("rules")) {
                String singleMaterial;
                Object key;
                HashSet<TypedKey> blockTypeKeys = new HashSet<TypedKey>();
                String[] ruleParseResult = rules.replace(" ", "").split(",");
                if (ruleParseResult.length < 3) continue;
                int i = 0;
                String[] stringArray = ruleParseResult;
                int n = stringArray.length;
                for (int j = 0; j < n && Registry.BLOCK.get(key = RegistryKey.BLOCK.typedKey(singleMaterial = stringArray[j])) != null; ++j) {
                    blockTypeKeys.add((TypedKey)key);
                    ++i;
                }
                @NotNull RegistryKeySet blockTypes = RegistrySet.keySet((RegistryKey)RegistryKey.BLOCK, blockTypeKeys);
                Tool.Rule rule = Tool.rule((RegistryKeySet)blockTypes, (Float)Float.valueOf(Float.parseFloat(ruleParseResult[i])), (TriState)TriState.byBoolean((boolean)Boolean.parseBoolean(ruleParseResult[i + 1])));
                builder.addRule(rule);
            }
            item.setData(DataComponentTypes.TOOL, (Object)((Tool)builder.build()));
        }
        if ((song = section.getString("song")) != null) {
            JukeboxSong jukeboxSong = (JukeboxSong)RegistryAccess.registryAccess().getRegistry(RegistryKey.JUKEBOX_SONG).getOrThrow(CommonUtil.parseNamespacedKey(song));
            JukeboxPlayable.Builder builder = JukeboxPlayable.jukeboxPlayable((JukeboxSong)jukeboxSong);
            item.setData(DataComponentTypes.JUKEBOX_PLAYABLE, (Object)((JukeboxPlayable)builder.build()));
        }
        if (section.get("glow") != null) {
            item.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)section.getBoolean("glow"));
        }
        if (section.get("unbreakable") != null && section.getBoolean("unbreakable")) {
            item.setData(DataComponentTypes.UNBREAKABLE);
        }
        if ((rarityKey = section.getString("rarity")) != null) {
            item.setData(DataComponentTypes.RARITY, (Object)((ItemRarity)Enums.getIfPresent(ItemRarity.class, (String)rarityKey).or((Object)ItemRarity.COMMON)));
        }
        if (!(itemFlagKey = section.getStringList("hide-tooltip")).isEmpty()) {
            TooltipDisplay.Builder builder = TooltipDisplay.tooltipDisplay();
            for (Object flag : itemFlagKey) {
                DataComponentType type = (DataComponentType)Registry.DATA_COMPONENT_TYPE.get(CommonUtil.parseNamespacedKey((String)flag));
                if (type == null) continue;
                builder.addHiddenComponents(new DataComponentType[]{type});
            }
            item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)builder.build()));
        }
        if ((enchantsKey = section.getConfigurationSection("enchants")) != null) {
            ItemEnchantments.Builder builder = ItemEnchantments.itemEnchantments();
            for (Object ench : enchantsKey.getKeys(false)) {
                Enchantment vanillaEnchant = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(CommonUtil.parseNamespacedKey(((String)ench).toLowerCase()));
                if (vanillaEnchant == null) continue;
                builder.add(vanillaEnchant, enchantsKey.getInt((String)ench, 1));
            }
            item.setData(DataComponentTypes.ENCHANTMENTS, (Object)((ItemEnchantments)builder.build()));
        }
        if ((attributesKey = section.getConfigurationSection("attributes")) != null) {
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.itemAttributes();
            for (String attribute : attributesKey.getKeys(false)) {
                EquipmentSlotGroup targetSlot;
                Object subSection;
                Attribute attributeInst = (Attribute)Registry.ATTRIBUTE.get(CommonUtil.parseNamespacedKey(attribute));
                if (attributeInst == null || (subSection = attributesKey.getConfigurationSection(attribute)) == null) continue;
                String attribName = subSection.getString("name");
                double attribAmount = subSection.getDouble("amount");
                String attribOperation = subSection.getString("operation");
                String attribSlot = subSection.getString("slot");
                EquipmentSlotGroup slot = EquipmentSlotGroup.ANY;
                if (attribSlot != null && (targetSlot = EquipmentSlotGroup.getByName((String)attribSlot)) != null) {
                    slot = targetSlot;
                }
                if (attribName == null || attribOperation == null) continue;
                AttributeModifier modifier = new AttributeModifier(CommonUtil.parseNamespacedKey(attribName), attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot);
                builder.addModifier(attributeInst, modifier, slot);
            }
            item.setData(DataComponentTypes.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)builder.build()));
        }
        if ((damageKey = section.getInt("damage", -1)) > 0) {
            item.setData(DataComponentTypes.DAMAGE, (Object)damageKey);
        }
        if ((maxDamageKey = section.getInt("max-damage", -1)) > 0) {
            item.setData(DataComponentTypes.MAX_DAMAGE, (Object)maxDamageKey);
        }
        if ((storedEnchantsKey = section.getConfigurationSection("stored-enchants")) != null) {
            ItemEnchantments.Builder builder = ItemEnchantments.itemEnchantments();
            for (Object ench : storedEnchantsKey.getKeys(false)) {
                Enchantment vanillaEnchant = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(CommonUtil.parseNamespacedKey(((String)ench).toLowerCase()));
                if (vanillaEnchant == null) continue;
                builder.add(vanillaEnchant, storedEnchantsKey.getInt((String)ench, 1));
            }
            item.setData(DataComponentTypes.STORED_ENCHANTMENTS, (Object)((ItemEnchantments)builder.build()));
        }
        if ((bannerPatternsKey = section.getConfigurationSection("banner-patterns")) != null) {
            BannerPatternLayers.Builder builder = BannerPatternLayers.bannerPatternLayers();
            for (String pattern : bannerPatternsKey.getKeys(false)) {
                PatternType type = (PatternType)Registry.BANNER_PATTERN.get(CommonUtil.parseNamespacedKey(pattern));
                String bannerColor = bannerPatternsKey.getString(pattern);
                if (type == null || bannerColor == null) continue;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)bannerColor.toUpperCase()).or((Object)DyeColor.WHITE);
                builder.add(new Pattern(color, type));
            }
            item.setData(DataComponentTypes.BANNER_PATTERNS, (Object)((BannerPatternLayers)builder.build()));
        }
        if ((potionKey = section.getConfigurationSection("potion")) != null) {
            String potionName;
            String basePotionType = potionKey.getString("base-effect");
            assert (basePotionType != null);
            PotionContents.Builder builder = PotionContents.potionContents();
            String[] singlePotion = basePotionType.replace(" ", "").split(",");
            PotionType potionType = (PotionType)Enums.getIfPresent(PotionType.class, (String)singlePotion[0].toUpperCase()).orNull();
            builder.potion(potionType);
            for (String effects : potionKey.getStringList("effects")) {
                PotionEffectType potionEffectType;
                String[] effectParseResult = effects.replace(" ", "").split(",");
                if (effectParseResult.length < 3 || (potionEffectType = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(CommonUtil.parseNamespacedKey(effectParseResult[0]))) == null) continue;
                PotionEffect potionEffect = new PotionEffect(potionEffectType, Integer.parseInt(effectParseResult[1]), Integer.parseInt(effectParseResult[2]), effectParseResult.length < 4 || Boolean.parseBoolean(effectParseResult[3]), effectParseResult.length < 5 || Boolean.parseBoolean(effectParseResult[4]), effectParseResult.length < 6 || Boolean.parseBoolean(effectParseResult[5]));
                builder.addCustomEffect(potionEffect);
            }
            String potionColor = potionKey.getString("color");
            if (potionColor != null) {
                builder.customColor(CommonUtil.parseColor(potionColor));
            }
            if ((potionName = potionKey.getString("name")) != null) {
                builder.customName(potionName);
            }
            item.setData(DataComponentTypes.POTION_CONTENTS, (Object)((PotionContents)builder.build()));
        }
        if (section.contains("potion-duration-scale")) {
            item.setData(DataComponentTypes.POTION_DURATION_SCALE, (Object)Float.valueOf((float)section.getDouble("potion-duration-scale")));
        }
        if ((chargedProjectilesKey = section.getConfigurationSection("charged-projectiles")) != null) {
            ChargedProjectiles.Builder builder = ChargedProjectiles.chargedProjectiles();
            for (Object key : chargedProjectilesKey.getKeys(false)) {
                ConfigurationSection contentItemSection = chargedProjectilesKey.getConfigurationSection((String)key);
                if (contentItemSection == null) continue;
                builder.add(BuildItemPaper.buildItemStack(player, contentItemSection, contentItemSection.getInt("amount"), args));
            }
            item.setData(DataComponentTypes.CHARGED_PROJECTILES, (Object)((ChargedProjectiles)builder.build()));
        }
        if ((trimKey = section.getConfigurationSection("trim")) != null) {
            String trimMaterialKey = trimKey.getString("material");
            String trimPatternKey = trimKey.getString("pattern");
            if (trimMaterialKey != null && trimPatternKey != null) {
                NamespacedKey trimMaterialNamespacedKey = CommonUtil.parseNamespacedKey(trimMaterialKey);
                NamespacedKey trimPatternNamespacedKey = CommonUtil.parseNamespacedKey(trimPatternKey);
                if (trimMaterialNamespacedKey != null && trimPatternNamespacedKey != null) {
                    TrimMaterial trimMaterial = (TrimMaterial)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_MATERIAL).get(trimMaterialNamespacedKey);
                    TrimPattern trimPattern = (TrimPattern)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN).get(trimPatternNamespacedKey);
                    if (trimMaterial != null && trimPattern != null) {
                        item.setData(DataComponentTypes.TRIM, (DataComponentBuilder)ItemArmorTrim.itemArmorTrim((ArmorTrim)new ArmorTrim(trimMaterial, trimPattern)));
                    }
                }
            }
        }
        if ((colorKey = section.getString("leather-color")) != null) {
            item.setData(DataComponentTypes.DYED_COLOR, (Object)DyedItemColor.dyedItemColor((Color)CommonUtil.parseColor(colorKey)));
        }
        if ((variantStr = section.getString("axolotl-variant")) != null && (variant = (Axolotl.Variant)Enums.getIfPresent(Axolotl.Variant.class, (String)variantStr.toUpperCase()).orNull()) != null) {
            item.setData(DataComponentTypes.AXOLOTL_VARIANT, (Object)variant);
        }
        if ((baseColorKey = section.getString("tropical-fish-base-color")) != null) {
            DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)baseColorKey).or((Object)DyeColor.WHITE);
            item.setData(DataComponentTypes.TROPICAL_FISH_BASE_COLOR, (Object)color);
        }
        if ((patternColorKey = section.getString("tropical-fish-pattern-color")) != null) {
            DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patternColorKey).or((Object)DyeColor.WHITE);
            item.setData(DataComponentTypes.TROPICAL_FISH_PATTERN_COLOR, (Object)patternColor);
        }
        if ((patternKey = section.getString("tropical-fish-pattern")) != null) {
            TropicalFish.Pattern pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)patternKey).or((Object)TropicalFish.Pattern.BETTY);
            item.setData(DataComponentTypes.TROPICAL_FISH_PATTERN, (Object)pattern);
        }
        if ((skullTextureNameKey = section.getString("skull-meta", section.getString("skull"))) != null) {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), (String)"");
            profile.setProperty(new ProfileProperty("textures", skullTextureNameKey));
            item.setData(DataComponentTypes.PROFILE, (Object)ResolvableProfile.resolvableProfile((PlayerProfile)profile));
        }
        if ((fireworkKey = section.getConfigurationSection("firework")) != null) {
            Fireworks.Builder builder = Fireworks.fireworks();
            for (Object fws : fireworkKey.getKeys(false)) {
                int duration;
                ConfigurationSection fireworkFwsSection = fireworkKey.getConfigurationSection((String)fws);
                FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
                if (fireworkFwsSection != null) {
                    ConfigurationSection colorsSection;
                    fireworkBuilder.flicker(fireworkFwsSection.getBoolean("flicker"));
                    fireworkBuilder.trail(fireworkFwsSection.getBoolean("trail"));
                    String fireworkType = fireworkFwsSection.getString("type");
                    if (fireworkType != null) {
                        fireworkBuilder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fireworkType.toUpperCase()).or((Object)FireworkEffect.Type.STAR));
                    }
                    if ((colorsSection = fireworkFwsSection.getConfigurationSection("colors")) != null) {
                        ArrayList<Color> colors = new ArrayList<Color>();
                        for (String colorStr : colorsSection.getStringList("base")) {
                            colors.add(CommonUtil.parseColor(colorStr));
                        }
                        fireworkBuilder.withColor(colors);
                        colors = new ArrayList();
                        for (String colorStr : colorsSection.getStringList("fade")) {
                            colors.add(CommonUtil.parseColor(colorStr));
                        }
                        fireworkBuilder.withFade(colors);
                        builder.addEffect(fireworkBuilder.build());
                    }
                }
                if ((duration = fireworkKey.getInt("duration")) < 0 || duration > 255) continue;
                builder.flightDuration(duration);
            }
            item.setData(DataComponentTypes.FIREWORKS, (Object)((Fireworks)builder.build()));
        }
        if (!(suspiciousStewEffects = section.getStringList("suspicious-stew-effects")).isEmpty()) {
            SuspiciousStewEffects.Builder builder = SuspiciousStewEffects.suspiciousStewEffects();
            for (Object effects : suspiciousStewEffects) {
                PotionEffectType potionEffectType;
                String[] effectParseResult = ((String)effects).replace(" ", "").split(",");
                if (effectParseResult.length < 3 || (potionEffectType = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(CommonUtil.parseNamespacedKey(effectParseResult[0]))) == null) continue;
                builder.add(SuspiciousEffectEntry.create((PotionEffectType)potionEffectType, (int)Integer.parseInt(effectParseResult[1])));
            }
            item.setData(DataComponentTypes.SUSPICIOUS_STEW_EFFECTS, (Object)((SuspiciousStewEffects)builder.build()));
        }
        if ((bundleContentKey = section.getConfigurationSection("bundle-contents")) != null) {
            BundleContents.Builder builder = BundleContents.bundleContents();
            for (String key : bundleContentKey.getKeys(false)) {
                ConfigurationSection contentItemSection = bundleContentKey.getConfigurationSection(key);
                if (contentItemSection == null) continue;
                builder.add(BuildItemPaper.buildItemStack(player, contentItemSection, contentItemSection.getInt("amount"), args));
            }
            item.setData(DataComponentTypes.BUNDLE_CONTENTS, (Object)((BundleContents)builder.build()));
        }
        if ((ominousPowerKey = section.getInt("ominous-bottle-amplifier", -1)) >= 0 && ominousPowerKey <= 4) {
            item.setData(DataComponentTypes.OMINOUS_BOTTLE_AMPLIFIER, (Object)OminousBottleAmplifier.amplifier((int)ominousPowerKey));
        }
        if ((musicKey = section.getString("music")) != null && (musicInstrument = (MusicInstrument)RegistryAccess.registryAccess().getRegistry(RegistryKey.INSTRUMENT).get(CommonUtil.parseNamespacedKey(musicKey))) != null) {
            item.setData(DataComponentTypes.INSTRUMENT, (Object)musicInstrument);
        }
        if ((repairCost = section.getInt("repair-cost", -1)) >= 0) {
            item.setData(DataComponentTypes.REPAIR_COST, (Object)repairCost);
        }
        if ((enchantable = section.getInt("enchantable", -1)) >= 0) {
            item.setData(DataComponentTypes.ENCHANTABLE, (Object)Enchantable.enchantable((int)enchantable));
        }
        if (section.getString("glider") != null && section.getBoolean("glider")) {
            item.setData(DataComponentTypes.GLIDER);
        }
        if ((itemModel = section.getString("item-model", null)) != null) {
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)CommonUtil.parseNamespacedKey(itemModel));
        }
        if ((tooltipStyle = section.getString("tooltip-style", null)) != null) {
            item.setData(DataComponentTypes.TOOLTIP_STYLE, (Object)CommonUtil.parseNamespacedKey(tooltipStyle));
        }
        if ((useCooldown = section.getConfigurationSection("use-cooldown")) != null && (cooldownSeconds = useCooldown.getInt("cooldown-seconds", -1)) >= 0) {
            UseCooldown.Builder builder = UseCooldown.useCooldown((float)cooldownSeconds);
            String cooldownGroup = useCooldown.getString("cooldown-group", null);
            if (cooldownGroup != null) {
                builder.cooldownGroup((Key)CommonUtil.parseNamespacedKey(cooldownGroup));
            }
            item.setData(DataComponentTypes.USE_COOLDOWN, (Object)((UseCooldown)builder.build()));
        }
        ConfigurationSection equippable = section.getConfigurationSection("equippable");
        ConfigurationSection weaponKey = section.getConfigurationSection("weapon");
        String damageResistant = section.getString("damage-resistant");
        if (damageResistant != null) {
            TagKey damageTypeTag = TagKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (String)damageResistant);
            item.setData(DataComponentTypes.DAMAGE_RESISTANT, (Object)DamageResistant.damageResistant((TagKey)damageTypeTag));
        }
        if ((blocksAttacksKey = section.getConfigurationSection("blocks-attacks")) != null) {
            BlocksAttacks.Builder builder = BlocksAttacks.blocksAttacks();
            if (blocksAttacksKey.contains("block-delay-seconds")) {
                builder.blockDelaySeconds((float)blocksAttacksKey.getDouble("block-delay-seconds"));
            }
            if (blocksAttacksKey.contains("disable-cooldown-scale")) {
                builder.disableCooldownScale((float)blocksAttacksKey.getDouble("disable-cooldown-scale"));
            }
            if (blocksAttacksKey.contains("block-sound")) {
                builder.blockSound((Key)CommonUtil.parseNamespacedKey(blocksAttacksKey.getString("block-sound", "")));
            }
            if (blocksAttacksKey.contains("bypassed-by")) {
                TagKey damageTypeTag = TagKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (String)blocksAttacksKey.getString("bypassed-by", ""));
                builder.bypassedBy(damageTypeTag);
            }
            item.setData(DataComponentTypes.BLOCKS_ATTACKS, (Object)((BlocksAttacks)builder.build()));
        }
        if ((breakSoundKey = section.getString("break-sound")) != null) {
            item.setData(DataComponentTypes.BREAK_SOUND, (Object)CommonUtil.parseNamespacedKey(breakSoundKey));
        }
        if ((useReminderKey = section.getConfigurationSection("use-reminder")) != null) {
            item.setData(DataComponentTypes.USE_REMAINDER, (Object)UseRemainder.useRemainder((ItemStack)BuildItemPaper.buildItemStack(player, useReminderKey, useReminderKey.getInt("amount"), new String[0])));
        }
        if ((consumableKey = section.getConfigurationSection("consumable")) != null) {
            Consumable.Builder builder = Consumable.consumable();
            if (consumableKey.contains("consume-seconds")) {
                builder.consumeSeconds((float)consumableKey.getDouble("consume-seconds"));
            }
            if (consumableKey.contains("animation")) {
                builder.animation((ItemUseAnimation)Enums.getIfPresent(ItemUseAnimation.class, (String)consumableKey.getString("animation", "NONE")).or((Object)ItemUseAnimation.NONE));
            }
            if (consumableKey.contains("sound")) {
                builder.sound((Key)CommonUtil.parseNamespacedKey(consumableKey.getString("sound", "")));
            }
            if (consumableKey.contains("effects")) {
                Iterator iterator = consumableKey.getKeys(false).iterator();
                while (iterator.hasNext()) {
                    String consumeEffects;
                    switch (consumeEffects = (String)iterator.next()) {
                        case "apply-effect": {
                            ConfigurationSection effectSection = consumableKey.getConfigurationSection(consumeEffects);
                            if (effectSection == null) break;
                            ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
                            for (String effects : effectSection.getStringList("effects")) {
                                PotionEffectType potionEffectType;
                                String[] effectParseResult = effects.replace(" ", "").split(",");
                                if (effectParseResult.length < 4 || (potionEffectType = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(CommonUtil.parseNamespacedKey(effectParseResult[0]))) == null) continue;
                                PotionEffect potionEffect = new PotionEffect(potionEffectType, Integer.parseInt(effectParseResult[1]), Integer.parseInt(effectParseResult[2]), effectParseResult.length < 5 || Boolean.parseBoolean(effectParseResult[3]), effectParseResult.length < 6 || Boolean.parseBoolean(effectParseResult[4]), effectParseResult.length < 7 || Boolean.parseBoolean(effectParseResult[5]));
                                potionEffectList.add(potionEffect);
                            }
                            builder.addEffect((ConsumeEffect)ConsumeEffect.applyStatusEffects(potionEffectList, (float)((float)effectSection.getDouble("probability"))));
                        }
                        case "play-sound": {
                            builder.addEffect((ConsumeEffect)ConsumeEffect.playSoundConsumeEffect((Key)CommonUtil.parseNamespacedKey(consumableKey.getString("play-sound", ""))));
                        }
                        case "random-teleport": {
                            builder.addEffect((ConsumeEffect)ConsumeEffect.teleportRandomlyEffect((float)((float)consumableKey.getDouble("random-teleport"))));
                        }
                        case "clear-effect": {
                            builder.addEffect((ConsumeEffect)ConsumeEffect.clearAllStatusEffects());
                        }
                    }
                }
            }
            item.setData(DataComponentTypes.CONSUMABLE, (Object)((Consumable)builder.build()));
        }
        return item;
    }
}

