/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.paper;

import cn.superiormc.mythictotem.MythicTotem;
import cn.superiormc.mythictotem.managers.ConfigManager;
import cn.superiormc.mythictotem.paper.utils.PaperTextUtil;
import cn.superiormc.mythictotem.utils.CommonUtil;
import cn.superiormc.mythictotem.utils.SpecialMethodUtil;
import cn.superiormc.mythictotem.utils.TextUtil;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class PaperMethodUtil
implements SpecialMethodUtil {
    @Override
    public String methodID() {
        return "paper";
    }

    @Override
    public void dispatchCommand(String command) {
        if (MythicTotem.isFolia) {
            Bukkit.getGlobalRegionScheduler().run((Plugin)MythicTotem.instance, task -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
            return;
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Override
    public void dispatchCommand(Player player, String command) {
        if (MythicTotem.isFolia) {
            player.getScheduler().run((Plugin)MythicTotem.instance, task -> Bukkit.dispatchCommand((CommandSender)player, (String)command), () -> {});
            return;
        }
        Bukkit.dispatchCommand((CommandSender)player, (String)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchOpCommand(Player player, String command) {
        if (MythicTotem.isFolia) {
            player.getScheduler().run((Plugin)MythicTotem.instance, task -> {
                boolean playerIsOp = player.isOp();
                try {
                    player.setOp(true);
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                }
                finally {
                    player.setOp(playerIsOp);
                }
            }, () -> {});
            return;
        }
        boolean playerIsOp = player.isOp();
        try {
            player.setOp(true);
            Bukkit.dispatchCommand((CommandSender)player, (String)command);
        }
        finally {
            player.setOp(playerIsOp);
        }
    }

    @Override
    public ItemStack getItemObject(Object object) {
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        if (CommonUtil.getMajorVersion(15)) {
            return ItemStack.deserializeBytes((byte[])((byte[])object));
        }
        return null;
    }

    @Override
    public Object makeItemToObject(ItemStack item) {
        if (CommonUtil.getMajorVersion(15)) {
            return item.serializeAsBytes();
        }
        return item;
    }

    @Override
    public void spawnEntity(Location location, EntityType entity) {
        if (MythicTotem.isFolia) {
            Bukkit.getRegionScheduler().run((Plugin)MythicTotem.instance, location, task -> location.getWorld().spawnEntity(location, entity));
            return;
        }
        location.getWorld().spawnEntity(location, entity);
    }

    @Override
    public void playerTeleport(Player player, Location location) {
        if (MythicTotem.isFolia) {
            player.teleportAsync(location);
        } else {
            player.teleport(location);
        }
    }

    @Override
    public SkullMeta setSkullMeta(SkullMeta meta, String skull) {
        PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), (String)"");
        profile.setProperty(new ProfileProperty("textures", skull));
        meta.setPlayerProfile(profile);
        return meta;
    }

    @Override
    public void setItemName(ItemMeta meta, String name, Player player) {
        if (PaperTextUtil.containsLegacyCodes((String)name)) {
            name = "<!i>" + (String)name;
        }
        meta.displayName(PaperTextUtil.modernParse((String)name, player));
    }

    @Override
    public void setItemItemName(ItemMeta meta, String itemName, Player player) {
        if (!((String)itemName).isEmpty()) {
            if (PaperTextUtil.containsLegacyCodes((String)itemName)) {
                itemName = "<!i>" + (String)itemName;
            }
            meta.itemName(PaperTextUtil.modernParse((String)itemName, player));
        } else {
            meta.itemName();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setItemLore(ItemMeta meta, List<String> lores, Player player) {
        ArrayList<Component> veryNewLore = new ArrayList<Component>();
        for (String lore : lores) {
            for (String string : lore.split("\n")) {
                void var10_10;
                if (PaperTextUtil.containsLegacyCodes(string)) {
                    String string2 = "<!i>" + string;
                }
                veryNewLore.add(PaperTextUtil.modernParse((String)var10_10, player));
            }
        }
        if (!veryNewLore.isEmpty()) {
            meta.lore(veryNewLore);
        }
    }

    @Override
    public void sendMessage(Player player, String text) {
        if (player == null) {
            Bukkit.getConsoleSender().sendMessage(PaperTextUtil.modernParse(text));
        } else {
            player.sendMessage(PaperTextUtil.modernParse(text, player));
        }
    }

    @Override
    public void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        player.showTitle(Title.title((Component)PaperTextUtil.modernParse(title), (Component)PaperTextUtil.modernParse(subTitle), (Title.Times)Title.Times.times((Duration)Ticks.duration((long)fadeIn), (Duration)Ticks.duration((long)stay), (Duration)Ticks.duration((long)fadeOut))));
    }

    @Override
    public String legacyParse(String text) {
        if (text == null) {
            return "";
        }
        if (!ConfigManager.configManager.getBoolean("config-files.force-parse-mini-message", true)) {
            return TextUtil.colorize(text);
        }
        return LegacyComponentSerializer.legacySection().serialize(PaperTextUtil.modernParse(text));
    }

    @Override
    public String getItemName(ItemMeta meta) {
        return PaperTextUtil.changeToString(meta.displayName());
    }

    @Override
    public String getItemItemName(ItemMeta meta) {
        return PaperTextUtil.changeToString(meta.itemName());
    }

    @Override
    public List<String> getItemLore(ItemMeta meta) {
        return PaperTextUtil.changeToString(meta.lore());
    }

    @Override
    public ItemStack editItemStack(ItemStack item, Player player, ConfigurationSection section, int amount, String ... args) {
        if (CommonUtil.getMinorVersion(21, 5)) {
            // empty if block
        }
        return item;
    }
}

