/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.utils;

import cn.superiormc.mythictotem.MythicTotem;
import cn.superiormc.mythictotem.managers.ErrorManager;
import cn.superiormc.mythictotem.utils.TextUtil;
import dev.lone.itemsadder.api.CustomBlock;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommonUtil {
    public static String modifyString(String text, String ... args) {
        for (int i = 0; i < args.length; i += 2) {
            String var1 = "{" + args[i] + "}";
            String var2 = "%" + args[i] + "%";
            text = args[i + 1] == null ? text.replace(var1, "").replace(var2, "") : text.replace(var1, args[i + 1]).replace(var2, args[i + 1]);
        }
        return text;
    }

    public static List<String> modifyList(Player player, List<String> config, String ... args) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String s : config) {
            for (int i = 0; i < args.length; i += 2) {
                String var = "{" + args[i] + "}";
                s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
            }
            String[] tempVal1 = s.split(";;");
            if (tempVal1.length > 1) {
                for (String string : tempVal1) {
                    resultList.add(TextUtil.withPAPI(string, player));
                }
                continue;
            }
            resultList.add(TextUtil.withPAPI(s, player));
        }
        return resultList;
    }

    public static boolean checkPluginLoad(String pluginName) {
        return MythicTotem.instance.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public static boolean getClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean getMajorVersion(int version) {
        return MythicTotem.majorVersion >= version;
    }

    public static boolean getMinorVersion(int majorVersion, int minorVersion) {
        return MythicTotem.majorVersion > majorVersion || MythicTotem.majorVersion == majorVersion && MythicTotem.minorVersion >= minorVersion;
    }

    public static void giveOrDrop(Player player, ItemStack ... item) {
        if (player == null) {
            return;
        }
        HashMap result = player.getInventory().addItem(item);
        if (!result.isEmpty()) {
            Iterator iterator = result.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                player.getWorld().dropItem(player.getLocation(), (ItemStack)result.get(id));
            }
        }
    }

    public static Collection<Entity> getNearbyEntity(Location location, double distance) {
        Collection<Object> tempVal2 = new HashSet<Entity>();
        if (MythicTotem.isFolia) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Folia servers do not support entity as totem layout, skipping totem check.");
        } else {
            try {
                tempVal2 = (Collection)Bukkit.getScheduler().callSyncMethod((Plugin)MythicTotem.instance, () -> location.getWorld().getNearbyEntities(location, distance, distance, distance)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: There is something wrong when get nearby entities.");
                return new HashSet<Entity>();
            }
        }
        return tempVal2;
    }

    public static void summonMythicMobs(Location location, String mobID, int level) {
        block3: {
            if (!CommonUtil.checkPluginLoad("MythicMobs")) {
                return;
            }
            try {
                MythicBukkit.inst().getMobManager().getMythicMob(mobID).ifPresent(mob -> mob.spawn(io.lumine.mythic.bukkit.BukkitAdapter.adapt((Location)location), (double)level));
            }
            catch (NoClassDefFoundError ep) {
                MythicMob mob2 = MythicMobs.inst().getMobManager().getMythicMob(mobID);
                if (mob2 == null) break block3;
                mob2.spawn(BukkitAdapter.adapt((Location)location), (double)level);
            }
        }
    }

    public static void removeBlock(Block block) {
        CustomBlock customBlock;
        if (block == null) {
            return;
        }
        if (CommonUtil.checkPluginLoad("ItemsAdder") && (customBlock = CustomBlock.byAlreadyPlaced((Block)block)) != null) {
            customBlock.remove();
        }
        block.setType(Material.AIR);
    }

    public static void mkDir(File dir) {
        if (!dir.exists()) {
            File parentFile = dir.getParentFile();
            if (parentFile == null) {
                return;
            }
            String parentPath = parentFile.getPath();
            CommonUtil.mkDir(new File(parentPath));
            dir.mkdir();
        }
    }

    public static NamespacedKey parseNamespacedKey(String key) {
        String[] keySplit = key.split(":");
        if (keySplit.length == 1) {
            return NamespacedKey.minecraft((String)key.toLowerCase());
        }
        if (CommonUtil.getMajorVersion(16)) {
            return NamespacedKey.fromString((String)key);
        }
        return new NamespacedKey("mythictotem", "unknown");
    }

    public static Color parseColor(String color) {
        String[] keySplit = color.replace(" ", "").split(",");
        if (keySplit.length == 3) {
            return Color.fromRGB((int)Integer.parseInt(keySplit[0]), (int)Integer.parseInt(keySplit[1]), (int)Integer.parseInt(keySplit[2]));
        }
        return Color.fromRGB((int)Integer.parseInt(color));
    }

    public static List<Color> parseColorList(List<String> rawList) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String value : rawList) {
            try {
                colors.add(CommonUtil.parseColor(value));
            }
            catch (Exception e) {
                return colors;
            }
        }
        return colors;
    }

    public static boolean checkClass(String className, String methodName) {
        try {
            Method[] methods;
            Class<?> targetClass = Class.forName(className);
            for (Method method : methods = targetClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

