/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythictotem.utils;

import cn.superiormc.mythictotem.MythicTotem;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerUtil {
    private BukkitTask bukkitTask;
    private ScheduledTask scheduledTask;

    public SchedulerUtil(BukkitTask bukkitTask) {
        this.bukkitTask = bukkitTask;
    }

    public SchedulerUtil(ScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
    }

    public void cancel() {
        if (MythicTotem.isFolia) {
            this.scheduledTask.cancel();
        } else {
            this.bukkitTask.cancel();
        }
    }

    public static void runSync(Runnable task) {
        if (MythicTotem.isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)MythicTotem.instance, task);
        } else {
            Bukkit.getScheduler().runTask((Plugin)MythicTotem.instance, task);
        }
    }

    public static void runTaskAsynchronously(Runnable task) {
        if (MythicTotem.isFolia) {
            task.run();
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)MythicTotem.instance, task);
        }
    }

    public static SchedulerUtil runTaskLater(Runnable task, long delayTicks) {
        if (MythicTotem.isFolia) {
            if (delayTicks <= 0L) {
                delayTicks = 1L;
            }
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)MythicTotem.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLater((Plugin)MythicTotem.instance, task, delayTicks));
    }

    public static SchedulerUtil runTaskTimer(Runnable task, long delayTicks, long periodTicks) {
        if (MythicTotem.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)MythicTotem.instance, scheduledTask -> task.run(), delayTicks, periodTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskTimer((Plugin)MythicTotem.instance, task, delayTicks, periodTicks));
    }

    public static SchedulerUtil runTaskLaterAsynchronously(Runnable task, long delayTicks) {
        if (MythicTotem.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)MythicTotem.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)MythicTotem.instance, task, delayTicks));
    }
}

