/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.FluidPipeBlockEntity;
import me.jddev0.ep.machine.tier.FluidPipeTier;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_10225;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5894;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends class_2237
implements class_3737,
WrenchConfigurable {
    public static final MapCodec<FluidPipeBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_41759.xmap(FluidPipeTier::valueOf, Enum::toString).fieldOf("tier").forGetter(FluidPipeBlock::getTier), (App)class_4970.class_2251.field_46532.fieldOf("properties").forGetter(class_4970::method_54095)).apply((Applicative)instance, FluidPipeBlock::new));
    public static final class_2754<EPBlockStateProperties.PipeConnection> UP = EPBlockStateProperties.PIPE_CONNECTION_UP;
    public static final class_2754<EPBlockStateProperties.PipeConnection> DOWN = EPBlockStateProperties.PIPE_CONNECTION_DOWN;
    public static final class_2754<EPBlockStateProperties.PipeConnection> NORTH = EPBlockStateProperties.PIPE_CONNECTION_NORTH;
    public static final class_2754<EPBlockStateProperties.PipeConnection> SOUTH = EPBlockStateProperties.PIPE_CONNECTION_SOUTH;
    public static final class_2754<EPBlockStateProperties.PipeConnection> EAST = EPBlockStateProperties.PIPE_CONNECTION_EAST;
    public static final class_2754<EPBlockStateProperties.PipeConnection> WEST = EPBlockStateProperties.PIPE_CONNECTION_WEST;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE_CORE = class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final class_265 SHAPE_UP = class_2248.method_9541((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 SHAPE_DOWN = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final class_265 SHAPE_NORTH = class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    private static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    private static final class_265 SHAPE_EAST = class_2248.method_9541((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final class_265 SHAPE_WEST = class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    private final FluidPipeTier tier;

    @NotNull
    public static class_2754<EPBlockStateProperties.PipeConnection> getPipeConnectionPropertyFromDirection(@NotNull class_2350 dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036 -> UP;
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11039 -> WEST;
        };
    }

    public FluidPipeBlock(FluidPipeTier tier, class_4970.class_2251 props) {
        super(props);
        this.tier = tier;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(UP, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).method_11657(DOWN, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).method_11657(NORTH, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).method_11657(SOUTH, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).method_11657(EAST, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).method_11657(WEST, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidPipeTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 state) {
        return new FluidPipeBlockEntity(blockPos, state, this.tier);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    @NotNull
    public class_1269 onUseWrench(class_1838 useOnContext, class_2350 selectedFace, boolean nextPreviousValue) {
        class_1937 level = useOnContext.method_8045();
        class_2338 blockPos = useOnContext.method_8037();
        if (level.method_8608() || !(level.method_8321(blockPos) instanceof FluidPipeBlockEntity)) {
            return class_1269.field_5812;
        }
        class_2680 state = level.method_8320(blockPos);
        class_2338 testPos = blockPos.method_10093(selectedFace);
        class_1657 player = useOnContext.method_8036();
        class_2586 testBlockEntity = level.method_8321(testPos);
        if (testBlockEntity == null || testBlockEntity instanceof FluidPipeBlockEntity) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.energizedpower.direction." + selectedFace.method_15434())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1061)));
            }
            return class_1269.field_5812;
        }
        Storage fluidStorage = (Storage)FluidStorage.SIDED.find(level, testPos, (Object)selectedFace.method_10153());
        if (fluidStorage == null) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.energizedpower.direction." + selectedFace.method_15434())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1061)));
            }
            return class_1269.field_5812;
        }
        if (!fluidStorage.iterator().hasNext()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.energizedpower.direction." + selectedFace.method_15434())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1061)));
            }
            return class_1269.field_5812;
        }
        class_2754<EPBlockStateProperties.PipeConnection> pipeConnectionProperty = FluidPipeBlock.getPipeConnectionPropertyFromDirection(selectedFace);
        int diff = player != null && player.method_5715() ? -1 : 1;
        EPBlockStateProperties.PipeConnection pipeConnection = (EPBlockStateProperties.PipeConnection)((Object)state.method_11654(pipeConnectionProperty));
        pipeConnection = EPBlockStateProperties.PipeConnection.values()[(pipeConnection.ordinal() + diff + EPBlockStateProperties.PipeConnection.values().length) % EPBlockStateProperties.PipeConnection.values().length];
        level.method_8652(blockPos, (class_2680)state.method_11657(pipeConnectionProperty, (Comparable)((Object)pipeConnection)), 3);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_changed", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.energizedpower.direction." + selectedFace.method_15434())).method_27692(class_124.field_1068), class_2561.method_43471((String)pipeConnection.getTranslationKey()).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067})}).method_27692(class_124.field_1060)));
        }
        return class_1269.field_5812;
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_1937 level = blockPlaceContext.method_8045();
        class_2338 selfPos = blockPlaceContext.method_8037();
        class_3610 fluidState = level.method_8316(selfPos);
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(UP, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.method_9564(), class_2350.field_11036)))).method_11657(DOWN, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.method_9564(), class_2350.field_11033)))).method_11657(NORTH, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.method_9564(), class_2350.field_11043)))).method_11657(SOUTH, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.method_9564(), class_2350.field_11035)))).method_11657(EAST, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.method_9564(), class_2350.field_11034)))).method_11657(WEST, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.method_9564(), class_2350.field_11039)))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(WEST)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(EAST)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(NORTH)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(SOUTH)))));
            }
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(SOUTH)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(NORTH)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(WEST)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(EAST)))));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(EAST)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(WEST)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(SOUTH)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(NORTH)))));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(SOUTH)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(NORTH)))));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(WEST)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.method_11654(EAST)))));
            }
        }
        return state;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        class_265 shape = SHAPE_CORE;
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.method_11654(UP))).isConnected()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_UP);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.method_11654(DOWN))).isConnected()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_DOWN);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.method_11654(NORTH))).isConnected()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_NORTH);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.method_11654(SOUTH))).isConnected()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_SOUTH);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.method_11654(EAST))).isConnected()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_EAST);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.method_11654(WEST))).isConnected()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_WEST);
        }
        return shape;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 tickView, class_2338 selfPos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(selfPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return super.method_9559(state, level, tickView, selfPos, facing, facingPos, facingState, random);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{UP}).method_11667(new class_2769[]{DOWN}).method_11667(new class_2769[]{NORTH}).method_11667(new class_2769[]{SOUTH}).method_11667(new class_2769[]{EAST}).method_11667(new class_2769[]{WEST}).method_11667(new class_2769[]{WATERLOGGED});
    }

    public void method_9612(class_2680 selfState, class_1937 level, class_2338 selfPos, class_2248 fromBlock, @Nullable class_9904 wireOrientation, boolean isMoving) {
        super.method_9612(selfState, level, selfPos, fromBlock, wireOrientation, isMoving);
        if (level.method_8608()) {
            return;
        }
        class_3610 fluidState = level.method_8316(selfPos);
        class_2680 newState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(UP, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(UP)))))).method_11657(DOWN, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(DOWN)))))).method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(NORTH)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(SOUTH)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(EAST)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(WEST)))))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        for (class_2350 dir : class_2350.values()) {
            class_2754<EPBlockStateProperties.PipeConnection> pipeConnectionProperty = FluidPipeBlock.getPipeConnectionPropertyFromDirection(dir);
            newState = (class_2680)newState.method_11657(pipeConnectionProperty, (Comparable)((Object)this.shouldConnectTo(level, selfPos, selfState, dir)));
            level.method_8501(selfPos, newState);
        }
        class_2586 blockEntity = level.method_8321(selfPos);
        if (!(blockEntity instanceof FluidPipeBlockEntity)) {
            return;
        }
        FluidPipeBlockEntity.updateConnections(level, selfPos, newState, (FluidPipeBlockEntity)blockEntity);
    }

    private EPBlockStateProperties.PipeConnection shouldConnectTo(class_1937 level, class_2338 selfPos, class_2680 selfState, class_2350 direction) {
        Storage fluidStorage;
        FluidPipeBlockEntity fluidPipeBlockEntity;
        class_2338 toPos = selfPos.method_10093(direction);
        class_2586 blockEntity = level.method_8321(toPos);
        if (blockEntity == null) {
            return EPBlockStateProperties.PipeConnection.NOT_CONNECTED;
        }
        if (blockEntity instanceof FluidPipeBlockEntity && (fluidPipeBlockEntity = (FluidPipeBlockEntity)blockEntity).getTier() != this.getTier()) {
            return EPBlockStateProperties.PipeConnection.NOT_CONNECTED;
        }
        EPBlockStateProperties.PipeConnection currentConnectionState = (EPBlockStateProperties.PipeConnection)((Object)selfState.method_11654(FluidPipeBlock.getPipeConnectionPropertyFromDirection(direction)));
        if (currentConnectionState == EPBlockStateProperties.PipeConnection.NOT_CONNECTED) {
            currentConnectionState = EPBlockStateProperties.PipeConnection.CONNECTED;
        }
        return (fluidStorage = (Storage)FluidStorage.SIDED.find(level, toPos, (Object)direction.method_10153())) == null ? EPBlockStateProperties.PipeConnection.NOT_CONNECTED : currentConnectionState;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return FluidPipeBlock.method_31618(type, this.tier.getEntityTypeFromTier(), FluidPipeBlockEntity::tick);
    }

    public static class Item
    extends class_1747 {
        private final FluidPipeTier tier;

        public Item(class_2248 block, class_1792.class_1793 props, FluidPipeTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public FluidPipeTier getTier() {
            return this.tier;
        }

        public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
            if (class_310.method_1551().method_74187()) {
                tooltip.accept((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.wrench_configurable").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
                tooltip.accept((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.fluid_pipe.max_extraction", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(this.tier.getTransferRate()))}).method_27692(class_124.field_1080));
            } else {
                tooltip.accept((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
            }
        }
    }
}

