/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.AdvancedChargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncIngredientsS2CPacket;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientPacketUpdate;
import me.jddev0.ep.screen.AdvancedChargerMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class AdvancedChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277>
implements IngredientPacketUpdate {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    protected List<class_1856> ingredientsOfRecipes = new ArrayList<class_1856>();
    final InputOutputItemHandler itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
        class_3218 serverWorld;
        if (i < 0 || i > 2) {
            return false;
        }
        class_1799 itemStack = this.itemHandler.method_5438(i.intValue());
        class_1937 patt0$temp = this.field_11863;
        if (patt0$temp instanceof class_3218 && RecipeUtils.isResultOfAny(serverWorld = (class_3218)patt0$temp, ChargerRecipe.Type.INSTANCE, itemStack)) {
            return true;
        }
        class_1937 patt1$temp = this.field_11863;
        if (!(patt1$temp instanceof class_3218) || RecipeUtils.isIngredientOfAny(serverWorld = (class_3218)patt1$temp, ChargerRecipe.Type.INSTANCE, itemStack)) {
            return false;
        }
        if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)) {
            return true;
        }
        EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get((int)i))));
        if (limitingEnergyStorage == null) {
            return true;
        }
        if (!limitingEnergyStorage.supportsInsertion()) {
            return true;
        }
        return limitingEnergyStorage.getAmount() == limitingEnergyStorage.getCapacity();
    });
    private long[] energyConsumptionLeft = new long[]{-1L, -1L, -1L};

    public AdvancedChargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.ADVANCED_CHARGER_ENTITY, blockPos, blockState, "advanced_charger", ModConfigs.COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT.getValue() * 3L, ModConfigs.COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT.getValue() * 3L, 3, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                AdvancedChargerBlockEntity.this.method_5431();
                AdvancedChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                class_3218 serverWorld;
                class_1937 class_19372 = AdvancedChargerBlockEntity.this.field_11863;
                if (class_19372 instanceof class_3218 ? RecipeUtils.isIngredientOfAny(serverWorld = (class_3218)class_19372, EPRecipes.CHARGER_TYPE, stack) : RecipeUtils.isIngredientOfAny(AdvancedChargerBlockEntity.this.ingredientsOfRecipes, stack)) {
                    return true;
                }
                if (slot >= 0 && slot < 3) {
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                        return false;
                    }
                    EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                    if (limitingEnergyStorage == null) {
                        return false;
                    }
                    return limitingEnergyStorage.supportsInsertion();
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || EnergyStorageUtil.isEnergyStorage((class_1799)stack) && EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)))) {
                        AdvancedChargerBlockEntity.this.resetProgress(slot);
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AdvancedChargerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(this::getEnergyConsumptionPerTickSum, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[0], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[1], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[2], value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncIngredientListToPlayer(player);
        return new AdvancedChargerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        for (int i = 0; i < 3; ++i) {
            view.method_71466("recipe.energy_consumption_left." + i, this.energyConsumptionLeft[i]);
        }
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        for (int i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = view.method_71425("recipe.energy_consumption_left." + i, 0L);
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedChargerBlockEntity blockEntity) {
        if (level.method_8608() || !(level instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)level;
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AdvancedChargerBlock.POWERED))) {
            return;
        }
        long maxReceivePerSlot = (long)Math.min((double)blockEntity.limitingEnergyStorage.getMaxInsert() / 3.0, Math.ceil((double)((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                long energyConsumptionPerTick;
                class_1799 stack = blockEntity.itemHandler.method_5438(i);
                class_1277 inventory = new class_1277(1);
                inventory.method_5447(0, blockEntity.itemHandler.method_5438(i));
                Optional recipe = serverWorld.method_64577().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_9695)new ContainerRecipeInputWrapper((class_1263)inventory), level);
                if (recipe.isPresent()) {
                    if (blockEntity.energyConsumptionLeft[i] == -1L) {
                        blockEntity.energyConsumptionLeft[i] = (long)((float)((ChargerRecipe)((class_8786)recipe.get()).comp_1933()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                    }
                    if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() == 0L) {
                        AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()));
                } else {
                    EnergyStorage limitingEnergyStorage;
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack) || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.itemHandler, null).getSlots().get(i))))) == null || !limitingEnergyStorage.supportsInsertion()) continue;
                    blockEntity.energyConsumptionLeft[i] = Math.max(0L, limitingEnergyStorage.getCapacity() - limitingEnergyStorage.getAmount());
                    if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() == 0L) {
                        AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    try (Transaction transaction = Transaction.openOuter();){
                        energyConsumptionPerTick = limitingEnergyStorage.insert(Math.min(maxReceivePerSlot, ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                        transaction.commit();
                    }
                }
                if (blockEntity.energyConsumptionLeft[i] < 0L || energyConsumptionPerTick < 0L) {
                    blockEntity.resetProgress(i);
                    AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    energyConsumptionPerTick = ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                int n = i;
                blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                if (blockEntity.energyConsumptionLeft[i] <= 0L) {
                    int index = i;
                    recipe.ifPresent(advancedChargerRecipe -> blockEntity.itemHandler.method_5447(index, ((ChargerRecipe)advancedChargerRecipe.comp_1933()).method_8116(null, (class_7225.class_7874)level.method_30349()).method_46651(1)));
                    blockEntity.resetProgress(i);
                }
                AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    protected final long getEnergyConsumptionPerTickSum() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return -1L;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        long maxReceivePerSlot = (long)Math.min((double)this.limitingEnergyStorage.getMaxInsert() / 3.0, Math.ceil((double)((EnergizedPowerEnergyStorage)this.energyStorage).getAmount() / 3.0));
        long energyConsumptionSum = -1L;
        for (int i = 0; i < 3; ++i) {
            long energyConsumption;
            class_1799 stack = this.itemHandler.method_5438(i);
            class_1277 inventory = new class_1277(1);
            inventory.method_5447(0, this.itemHandler.method_5438(i));
            Optional recipe = serverWorld.method_64577().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_9695)new ContainerRecipeInputWrapper((class_1263)inventory), this.field_11863);
            if (recipe.isPresent()) {
                energyConsumption = Math.min(this.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount()));
            } else {
                EnergyStorage limitingEnergyStorage;
                if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack) || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get(i))))) == null || !limitingEnergyStorage.supportsInsertion()) continue;
                try (Transaction transaction = Transaction.openOuter();){
                    energyConsumption = limitingEnergyStorage.insert(Math.min(maxReceivePerSlot, ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount()), (TransactionContext)transaction);
                }
            }
            energyConsumptionSum = energyConsumptionSum == -1L ? energyConsumption : (energyConsumptionSum += energyConsumption);
            if (energyConsumptionSum >= 0L) continue;
            energyConsumptionSum = Long.MAX_VALUE;
        }
        return energyConsumptionSum;
    }

    private void resetProgress(int index) {
        this.energyConsumptionLeft[index] = -1L;
    }

    private boolean hasRecipe(int index) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1799 stack = this.itemHandler.method_5438(index);
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, this.itemHandler.method_5438(index));
        Optional recipe = serverWorld.method_64577().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_9695)new ContainerRecipeInputWrapper((class_1263)inventory), this.field_11863);
        if (recipe.isPresent()) {
            return true;
        }
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i);
        }
        super.updateUpgradeModules();
    }

    protected void syncIngredientListToPlayer(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncIngredientsS2CPacket(this.method_11016(), 0, RecipeUtils.getIngredientsOf(serverWorld, EPRecipes.CHARGER_TYPE)));
    }

    public List<class_1856> getIngredientsOfRecipes() {
        return new ArrayList<class_1856>(this.ingredientsOfRecipes);
    }

    @Override
    public void setIngredients(int index, List<class_1856> ingredients) {
        if (index == 0) {
            this.ingredientsOfRecipes = ingredients;
        }
    }
}

