/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncIngredientsS2CPacket;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientPacketUpdate;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.screen.AlloyFurnaceMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceBlockEntity
extends MenuInventoryStorageBlockEntity<class_1277>
implements IngredientPacketUpdate {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ALLOY_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private int progress;
    private int maxProgress;
    private int litDuration;
    private int maxLitDuration;
    protected List<class_1856> ingredientsOfRecipes = new ArrayList<class_1856>();
    private final Predicate<Integer> canOutput = i -> {
        if (i == 3) {
            class_1799 item = this.itemHandler.method_5438(i.intValue());
            return this.field_11863 != null && this.field_11863.method_61269().method_61755(item) <= 0;
        }
        return i > 3 && i < 6;
    };
    private final InputOutputItemHandler itemHandlerSidedTopBottom = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 3, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedFront = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i >= 0 && i < 3, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedBack = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 1, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedLeft = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedRight = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 2, this.canOutput);

    public AlloyFurnaceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.ALLOY_FURNACE_ENTITY, blockPos, blockState, "alloy_furnace", 6);
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        class_1937 var4_3 = AlloyFurnaceBlockEntity.this.field_11863;
                        if (var4_3 instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)var4_3;
                            yield RecipeUtils.isIngredientOfAny(serverWorld, EPRecipes.ALLOY_FURNACE_TYPE, stack);
                        }
                        yield RecipeUtils.isIngredientOfAny(AlloyFurnaceBlockEntity.this.ingredientsOfRecipes, stack);
                    }
                    case 3 -> {
                        if (AlloyFurnaceBlockEntity.this.field_11863 != null && AlloyFurnaceBlockEntity.this.field_11863.method_61269().method_61755(stack) > 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4, 5 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        AlloyFurnaceBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AlloyFurnaceBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new ProgressValueContainerData(() -> this.litDuration, value -> {
            this.litDuration = value;
        }), new ProgressValueContainerData(() -> this.maxLitDuration, value -> {
            this.maxLitDuration = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncIngredientListToPlayer(player);
        return new AlloyFurnaceMenu(id, this, inventory, (class_1263)this.itemHandler, this.data);
    }

    public int getRedstoneOutput() {
        return class_1703.method_7618((class_1263)this.itemHandler);
    }

    public Storage<ItemVariant> getInventoryStorageForDirection(class_2350 side) {
        if (side == null) {
            return null;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654(AssemblingMachineBlock.FACING);
        if (facing == side) {
            return this.itemHandlerSidedFront.apply(side);
        }
        if (facing.method_10153() == side) {
            return this.itemHandlerSidedBack.apply(side);
        }
        if (facing.method_10170() == side) {
            return this.itemHandlerSidedLeft.apply(side);
        }
        if (facing.method_10160() == side) {
            return this.itemHandlerSidedRight.apply(side);
        }
        return this.itemHandlerSidedTopBottom.apply(side);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("recipe.progress", this.progress);
        view.method_71465("recipe.max_progress", this.maxProgress);
        view.method_71465("recipe.lit_duration", this.litDuration);
        view.method_71465("recipe.max_lit_duration", this.maxLitDuration);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.progress = view.method_71424("recipe.progress", 0);
        this.maxProgress = view.method_71424("recipe.max_progress", 0);
        this.litDuration = view.method_71424("recipe.lit_duration", 0);
        this.maxLitDuration = view.method_71424("recipe.max_lit_duration", 0);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AlloyFurnaceBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        boolean hasNotEnoughFuel = false;
        if (blockEntity.litDuration > 0) {
            --blockEntity.litDuration;
            if (blockEntity.litDuration <= 0) {
                blockEntity.maxLitDuration = 0;
                hasNotEnoughFuel = true;
            }
            AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        if (blockEntity.hasRecipe()) {
            Optional<class_8786<AlloyFurnaceRecipe>> recipe = blockEntity.getCurrentRecipe();
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.litDuration <= 0) {
                class_1799 item = blockEntity.itemHandler.method_5438(3);
                blockEntity.litDuration = blockEntity.maxLitDuration = blockEntity.field_11863.method_61269().method_61755(item);
                if (blockEntity.maxLitDuration > 0) {
                    blockEntity.onHasEnoughFuel();
                    hasNotEnoughFuel = false;
                    if (!item.getRecipeRemainder().method_7960()) {
                        blockEntity.itemHandler.method_5447(3, item.getRecipeRemainder());
                    } else {
                        blockEntity.itemHandler.method_5434(3, 1);
                    }
                }
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)((float)((AlloyFurnaceRecipe)recipe.get().comp_1933()).getTicks() * RECIPE_DURATION_MULTIPLIER));
            }
            if (blockEntity.litDuration > 0) {
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                    if (hasNotEnoughFuel) {
                        blockEntity.onHasNotEnoughFuel();
                    }
                    blockEntity.resetProgress();
                    AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem(recipe.get());
                }
                AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.progress = Math.max(blockEntity.progress - 2, 0);
                hasNotEnoughFuel = true;
                AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress();
            AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        if (hasNotEnoughFuel) {
            blockEntity.onHasNotEnoughFuel();
        }
    }

    private void onHasEnoughFuel() {
        if (this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12548) && !((Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void onHasNotEnoughFuel() {
        if (this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12548) && ((Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private class_9695 getRecipeInput(class_1263 inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    private Optional<class_8786<AlloyFurnaceRecipe>> getRecipeFor(class_1277 inventory) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return serverWorld.method_64577().method_8132(EPRecipes.ALLOY_FURNACE_TYPE, this.getRecipeInput((class_1263)inventory), this.field_11863);
    }

    private Optional<class_8786<AlloyFurnaceRecipe>> getCurrentRecipe() {
        return this.getRecipeFor(this.itemHandler);
    }

    private boolean hasRecipe() {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<class_8786<AlloyFurnaceRecipe>> recipe = this.getRecipeFor(this.itemHandler);
        return recipe.isPresent() && this.canCraftRecipe(this.itemHandler, recipe.get());
    }

    protected void craftItem(class_8786<AlloyFurnaceRecipe> recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        IngredientWithCount[] inputs = ((AlloyFurnaceRecipe)recipe.comp_1933()).getInputs();
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = this.itemHandler.method_5438(i).method_7960();
        }
        int len = Math.min(inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                class_1799 item = this.itemHandler.method_5438(j);
                if (indexMinCount != -1 && item.method_7947() >= minCount || !input.input().method_8093(item) || item.method_7947() < input.count()) continue;
                indexMinCount = j;
                minCount = item.method_7947();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.method_5434(indexMinCount, input.count());
        }
        class_1799[] outputs = ((AlloyFurnaceRecipe)recipe.comp_1933()).generateOutputs(this.field_11863.field_9229);
        this.itemHandler.method_5447(4, outputs[0].method_46651(this.itemHandler.method_5438(4).method_7947() + outputs[0].method_7947()));
        if (!outputs[1].method_7960()) {
            this.itemHandler.method_5447(5, outputs[1].method_46651(this.itemHandler.method_5438(5).method_7947() + outputs[1].method_7947()));
        }
        this.resetProgress();
    }

    private boolean canCraftRecipe(class_1277 inventory, class_8786<AlloyFurnaceRecipe> recipe) {
        class_1799[] maxOutputs = ((AlloyFurnaceRecipe)recipe.comp_1933()).getMaxOutputCounts();
        return this.field_11863 != null && InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 4, maxOutputs[0]) && (maxOutputs[1].method_7960() || InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 5, maxOutputs[1]));
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
    }

    protected void syncIngredientListToPlayer(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncIngredientsS2CPacket(this.method_11016(), 0, RecipeUtils.getIngredientsOf(serverWorld, EPRecipes.ALLOY_FURNACE_TYPE)));
    }

    public List<class_1856> getIngredientsOfRecipes() {
        return new ArrayList<class_1856>(this.ingredientsOfRecipes);
    }

    @Override
    public void setIngredients(int index, List<class_1856> ingredients) {
        if (index == 0) {
            this.ingredientsOfRecipes = ingredients;
        }
    }
}

