/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.energy.InfinityEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.screen.CreativeBatteryBoxMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class CreativeBatteryBoxBlockEntity
extends MenuEnergyStorageBlockEntity<InfinityEnergyStorage>
implements CheckboxUpdate {
    private boolean energyProduction = true;
    private boolean energyConsumption;

    public CreativeBatteryBoxBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.CREATIVE_BATTERY_BOX_ENTITY, blockPos, blockState, "creative_battery_box", Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    protected InfinityEnergyStorage initEnergyStorage() {
        return new InfinityEnergyStorage(){

            @Override
            public long extract(long maxAmount, TransactionContext transaction) {
                return CreativeBatteryBoxBlockEntity.this.energyProduction ? super.extract(maxAmount, transaction) : 0L;
            }

            @Override
            public long insert(long maxAmount, TransactionContext transaction) {
                return CreativeBatteryBoxBlockEntity.this.energyConsumption ? super.insert(maxAmount, transaction) : 0L;
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new BooleanValueContainerData(() -> this.energyProduction, value -> {
            this.energyProduction = value;
        }), new BooleanValueContainerData(() -> this.energyConsumption, value -> {
            this.energyConsumption = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new CreativeBatteryBoxMenu(id, this, inventory, this.data);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71472("energy_production", this.energyProduction);
        view.method_71472("energy_consumption", this.energyConsumption);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.energyProduction = view.method_71433("energy_production", true);
        this.energyConsumption = view.method_71433("energy_consumption", false);
    }

    public void setEnergyProduction(boolean energyProduction) {
        this.energyProduction = energyProduction;
        CreativeBatteryBoxBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setEnergyConsumption(boolean energyConsumption) {
        this.energyConsumption = energyConsumption;
        CreativeBatteryBoxBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setEnergyProduction(checked);
                break;
            }
            case 1: {
                this.setEnergyConsumption(checked);
            }
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        CreativeBatteryBoxBlockEntity.transferInfiniteEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferInfiniteEnergy(class_1937 level, class_2338 blockPos, class_2680 state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.energyProduction) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            long received;
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                received = limitingEnergyStorage.insert(limitingEnergyStorage.getCapacity(), (TransactionContext)transaction);
            }
            transaction = Transaction.openOuter();
            try {
                limitingEnergyStorage.insert(received, (TransactionContext)transaction);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }
}

