/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSwitchBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class ItemConveyorBeltSwitchBlockEntity
extends class_2586 {
    private final int ticksPerItem;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltSwitchBlockEntity(class_2338 blockPos, class_2680 blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltSwitchBlockEntityFromTier(), blockPos, blockState);
        this.tier = tier;
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM.getValue();
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltSwitchBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (level.method_8510() % (long)blockEntity.ticksPerItem == 0L) {
            class_2350 facing = (class_2350)state.method_11654(ItemConveyorBeltSwitchBlock.FACING);
            class_2338 inputPos = blockPos.method_10093(facing);
            class_2680 inputBlockState = level.method_8320(inputPos);
            if (!(inputBlockState.method_26204() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.method_11654(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().method_10153() != facing) {
                return;
            }
            class_2586 inputBlockEntity = level.method_8321(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            Storage inputBeltItemStackStorage = (Storage)ItemStorage.SIDED.find(level, inputPos, (Object)facing.method_10153());
            if (inputBeltItemStackStorage == null || !inputBeltItemStackStorage.supportsExtraction()) {
                return;
            }
            class_1799 itemStackToSwitch = class_1799.field_8037;
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView itemView : inputBeltItemStackStorage) {
                    ItemVariant itemVariant;
                    long amount;
                    if (itemView.isResourceBlank() || (amount = inputBeltItemStackStorage.extract((Object)(itemVariant = (ItemVariant)itemView.getResource()), 1L, (TransactionContext)transaction)) <= 0L) continue;
                    itemStackToSwitch = itemVariant.toStack(1);
                    break;
                }
            }
            if (itemStackToSwitch.method_7960()) {
                return;
            }
            boolean isPowered = (Boolean)state.method_11654((class_2769)ItemConveyorBeltSwitchBlock.POWERED);
            class_2350 outputDirection = isPowered ? facing.method_10160() : facing.method_10170();
            class_2338 outputPos = blockPos.method_10093(outputDirection);
            class_2680 outputBlockState = level.method_8320(outputPos);
            if (!(outputBlockState.method_26204() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            class_2586 outputBlockEntity = level.method_8321(outputPos);
            if (!(outputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            Storage outputBeltItemStackStorage = (Storage)ItemStorage.SIDED.find(level, outputPos, (Object)outputDirection.method_10153());
            if (outputBeltItemStackStorage == null || !outputBeltItemStackStorage.supportsInsertion()) {
                return;
            }
            try (Transaction transaction = Transaction.openOuter();){
                long amount = outputBeltItemStackStorage.insert((Object)ItemVariant.of((class_1799)itemStackToSwitch), 1L, (TransactionContext)transaction);
                if (amount > 0L) {
                    inputBeltItemStackStorage.extract((Object)ItemVariant.of((class_1799)itemStackToSwitch), 1L, (TransactionContext)transaction);
                }
                transaction.commit();
            }
        }
    }
}

