/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncIngredientsS2CPacket;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.PlantGrowthChamberFertilizerRecipe;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.screen.PlantGrowthChamberMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class PlantGrowthChamberBlockEntity
extends SimpleRecipeMachineBlockEntity<class_9695, PlantGrowthChamberRecipe> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    final InputOutputItemHandler itemHandlerSidesSided;
    final InputOutputItemHandler itemHandlerTopBottomSided;
    private double fertilizerSpeedMultiplier;
    private double fertilizerEnergyConsumptionMultiplier;
    protected List<class_1856> ingredientsOfFertilizerRecipes;

    public PlantGrowthChamberBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.PLANT_GROWTH_CHAMBER_ENTITY, blockPos, blockState, "plant_growth_chamber", PlantGrowthChamberMenu::new, 6, EPRecipes.PLANT_GROWTH_CHAMBER_TYPE, 1, (long)ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_CAPACITY.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSidesSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, i -> i > 1 && i < 6);
        this.itemHandlerTopBottomSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 1, i -> i > 1 && i < 6);
        this.fertilizerSpeedMultiplier = 1.0;
        this.fertilizerEnergyConsumptionMultiplier = 1.0;
        this.ingredientsOfFertilizerRecipes = new ArrayList<class_1856>();
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0 -> {
                        class_1937 var4_3 = PlantGrowthChamberBlockEntity.this.field_11863;
                        if (var4_3 instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)var4_3;
                            yield RecipeUtils.isIngredientOfAny(serverWorld, PlantGrowthChamberBlockEntity.this.recipeType, stack);
                        }
                        yield RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.ingredientsOfRecipes, stack);
                    }
                    case 1 -> {
                        class_1937 var4_4 = PlantGrowthChamberBlockEntity.this.field_11863;
                        if (var4_4 instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)var4_4;
                            yield RecipeUtils.isIngredientOfAny(serverWorld, EPRecipes.PLANT_GROWTH_CHAMBER_FERTILIZER_TYPE, stack);
                        }
                        yield RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.ingredientsOfFertilizerRecipes, stack);
                    }
                    case 2, 3, 4, 5 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(PlantGrowthChamberBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        PlantGrowthChamberBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                PlantGrowthChamberBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncFertilizerIngredientListToPlayer(player);
        return super.createMenu(id, inventory, player);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71463("recipe.speed_multiplier", this.fertilizerSpeedMultiplier);
        view.method_71463("recipe.energy_consumption_multiplier", this.fertilizerEnergyConsumptionMultiplier);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.fertilizerSpeedMultiplier = view.method_71422("recipe.speed_multiplier", 0.0);
        this.fertilizerEnergyConsumptionMultiplier = view.method_71422("recipe.energy_consumption_multiplier", 0.0);
    }

    @Override
    protected double getRecipeDependentRecipeDuration(class_8786<PlantGrowthChamberRecipe> recipe) {
        return (double)((float)((PlantGrowthChamberRecipe)recipe.comp_1933()).getTicks() * RECIPE_DURATION_MULTIPLIER) / this.fertilizerSpeedMultiplier;
    }

    @Override
    protected double getRecipeDependentEnergyConsumption(class_8786<PlantGrowthChamberRecipe> recipe) {
        return this.fertilizerEnergyConsumptionMultiplier;
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.fertilizerSpeedMultiplier = 1.0;
        this.fertilizerEnergyConsumptionMultiplier = 1.0;
    }

    @Override
    protected void onStartCrafting(class_8786<PlantGrowthChamberRecipe> recipe) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        Optional fertilizerRecipe = serverWorld.method_64577().method_8132((class_3956)PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, (class_9695)new ContainerRecipeInputWrapper((class_1263)this.itemHandler), this.field_11863);
        if (fertilizerRecipe.isPresent()) {
            this.fertilizerSpeedMultiplier = ((PlantGrowthChamberFertilizerRecipe)((class_8786)fertilizerRecipe.get()).comp_1933()).getSpeedMultiplier();
            this.fertilizerEnergyConsumptionMultiplier = ((PlantGrowthChamberFertilizerRecipe)((class_8786)fertilizerRecipe.get()).comp_1933()).getEnergyConsumptionMultiplier();
            this.itemHandler.method_5434(1, 1);
        }
    }

    @Override
    protected class_9695 getRecipeInput(class_1277 inventory) {
        return new ContainerRecipeInputWrapper((class_1263)inventory);
    }

    @Override
    protected void craftItem(class_8786<PlantGrowthChamberRecipe> recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.method_5434(0, 1);
        ArrayList<class_1799> itemStacksInsert = new ArrayList<class_1799>(Arrays.asList(((PlantGrowthChamberRecipe)recipe.comp_1933()).generateOutputs(this.field_11863.field_9229)));
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (class_1799 itemStack : itemStacksInsert) {
            if (itemStack.method_7960()) continue;
            for (int i = 2; i < this.itemHandler.method_5439(); ++i) {
                int amount;
                class_1799 testItemStack = this.itemHandler.method_5438(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.method_7960()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947())) <= 0) continue;
                this.itemHandler.method_5447(i, this.itemHandler.method_5438(i).method_46651(testItemStack.method_7947() + amount));
                itemStack.method_7939(itemStack.method_7947() - amount);
                if (itemStack.method_7960()) continue block0;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.method_5447(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(class_1277 inventory, class_8786<PlantGrowthChamberRecipe> recipe) {
        return this.field_11863 != null && PlantGrowthChamberBlockEntity.canInsertItemsIntoOutputSlots(inventory, new ArrayList<class_1799>(Arrays.asList(((PlantGrowthChamberRecipe)recipe.comp_1933()).getMaxOutputCounts())));
    }

    private static boolean canInsertItemsIntoOutputSlots(class_1277 inventory, List<class_1799> itemsStacks) {
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(4);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (int i = Math.min(4, itemsStacks.size()) - 1; i >= 0; --i) {
            class_1799 itemStack = itemsStacks.get(i);
            for (int j = 2; j < inventory.method_5439(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                class_1799 testItemStack = inventory.method_5438(j);
                if (testItemStack.method_7960()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                int amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947());
                if (amount + testItemStack.method_7947() == testItemStack.method_7914()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.method_7947()) {
                    itemsStacks.remove(i);
                    continue block0;
                }
                itemStack.method_7934(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack.method_7947() == itemStack.method_7914()) {
                checkedIndices.add(index);
            }
            itemsStacks.remove(i);
        }
        return itemsStacks.isEmpty();
    }

    protected void syncFertilizerIngredientListToPlayer(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncIngredientsS2CPacket(this.method_11016(), 1, RecipeUtils.getIngredientsOf(serverWorld, EPRecipes.PLANT_GROWTH_CHAMBER_FERTILIZER_TYPE)));
    }

    public List<class_1856> getIngredientsOfFertilizerRecipes() {
        return this.ingredientsOfFertilizerRecipes;
    }

    @Override
    public void setIngredients(int index, List<class_1856> ingredients) {
        super.setIngredients(index, ingredients);
        if (index == 1) {
            this.ingredientsOfFertilizerRecipes = ingredients;
        }
    }
}

