/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncCurrentRecipeS2CPacket;
import me.jddev0.ep.networking.packet.SyncIngredientsS2CPacket;
import me.jddev0.ep.recipe.ChangeCurrentRecipeIndexPacketUpdate;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import me.jddev0.ep.recipe.IngredientPacketUpdate;
import me.jddev0.ep.recipe.SetCurrentRecipeIdPacketUpdate;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableRecipeFluidMachineBlockEntity<F extends Storage<FluidVariant>, C extends class_9695, R extends class_1860<C>>
extends WorkerFluidMachineBlockEntity<F, class_8786<R>>
implements ChangeCurrentRecipeIndexPacketUpdate,
CurrentRecipePacketUpdate<R>,
SetCurrentRecipeIdPacketUpdate,
IngredientPacketUpdate {
    protected final UpgradableMenuProvider menuProvider;
    protected final class_3956<R> recipeType;
    protected final class_1865<R> recipeSerializer;
    protected class_2960 currentRecipeIdForLoad;
    protected class_8786<R> currentRecipe;
    protected List<class_1856> ingredientsOfRecipes = new ArrayList<class_1856>();

    public SelectableRecipeFluidMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, class_3956<R> recipeType, class_1865<R> recipeSerializer, int baseRecipeDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, long baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(this::getEnergyConsumptionFor).orElse(-1L) : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (this.currentRecipe != null) {
            view.method_71469("recipe.id", this.currentRecipe.comp_1932().method_29177().toString());
        }
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        view.method_71441("recipe.id").ifPresent(recipeId -> {
            this.currentRecipeIdForLoad = class_2960.method_12829((String)recipeId);
        });
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        this.syncCurrentRecipeToPlayer(player);
        this.syncIngredientListToPlayer(player);
        return this.menuProvider.createMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected final void onTickStart() {
        class_1937 class_19372;
        if (this.currentRecipeIdForLoad != null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            Collection<class_8786<R>> recipes = RecipeUtils.getAllRecipesFor(serverWorld, this.recipeType);
            this.currentRecipe = recipes.stream().filter(recipe -> recipe.comp_1932().method_29177().equals((Object)this.currentRecipeIdForLoad)).findFirst().orElse(null);
            this.currentRecipeIdForLoad = null;
        }
    }

    @Override
    protected Optional<class_8786<R>> getCurrentWorkData() {
        return Optional.ofNullable(this.currentRecipe);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(class_8786<R> workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(class_8786<R> workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.field_11863 == null || this.currentRecipe == null) {
            return false;
        }
        return this.canCraftRecipe(this.itemHandler, this.currentRecipe);
    }

    @Override
    protected final void onWorkStarted(class_8786<R> workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(class_8786<R> recipe) {
    }

    @Override
    protected final void onWorkCompleted(class_8786<R> workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(class_8786<R> var1);

    protected abstract boolean canCraftRecipe(class_1277 var1, class_8786<R> var2);

    @Override
    public void changeRecipeIndex(boolean downUp) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        List<Object> recipes = new ArrayList<class_8786<R>>(RecipeUtils.getAllRecipesFor(serverWorld, this.recipeType));
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> recipe.comp_1932().method_29177())).toList();
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.comp_1932().method_29177().equals((Object)((class_8786)recipes.get(i)).comp_1932().method_29177())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : (class_8786)recipes.get(currentIndex);
        this.resetProgress();
        this.method_5431();
        this.syncCurrentRecipeToPlayers(32);
    }

    @Override
    public void setRecipeId(class_2960 recipeId) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (recipeId == null) {
            this.currentRecipe = null;
        } else {
            Collection<class_8786<R>> recipes = RecipeUtils.getAllRecipesFor(serverWorld, this.recipeType);
            Optional<class_8786> recipe = recipes.stream().filter(r -> r.comp_1932().method_29177().equals((Object)recipeId)).findFirst();
            this.currentRecipe = recipe.orElse(null);
        }
        this.resetProgress();
        this.method_5431();
        this.syncCurrentRecipeToPlayers(32);
    }

    protected final void syncCurrentRecipeToPlayer(class_1657 player) {
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncCurrentRecipeS2CPacket<R>(this.method_11016(), this.recipeSerializer, this.currentRecipe));
    }

    protected final void syncCurrentRecipeToPlayers(int distance) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, distance, new SyncCurrentRecipeS2CPacket<R>(this.method_11016(), this.recipeSerializer, this.currentRecipe));
        }
    }

    @Nullable
    public class_8786<R> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(@Nullable class_8786<R> currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    protected void syncIngredientListToPlayer(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncIngredientsS2CPacket(this.method_11016(), 0, RecipeUtils.getIngredientsOf(serverWorld, this.recipeType)));
    }

    public List<class_1856> getIngredientsOfRecipes() {
        return new ArrayList<class_1856>(this.ingredientsOfRecipes);
    }

    @Override
    public void setIngredients(int index, List<class_1856> ingredients) {
        if (index == 0) {
            this.ingredientsOfRecipes = ingredients;
        }
    }
}

