/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.validation;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ValueValidator<T> {
    public void validate(@NotNull T var1) throws ConfigValidationException;

    @NotNull
    default public List<String> getValidationCommentLines() {
        return new ArrayList<String>();
    }

    @NotNull
    default public ValueValidator<? super T> validateBefore(final @NotNull ValueValidator<? super T> validator) {
        return new ValueValidator<T>(){

            @Override
            public void validate(@NotNull T value) throws ConfigValidationException {
                validator.validate(value);
                ValueValidator.this.validate(value);
            }

            @Override
            @NotNull
            public List<String> getValidationCommentLines() {
                ArrayList<String> commentLines = new ArrayList<String>(validator.getValidationCommentLines());
                commentLines.addAll(ValueValidator.this.getValidationCommentLines());
                return commentLines;
            }
        };
    }

    @NotNull
    default public ValueValidator<? super T> validateAfter(final @NotNull ValueValidator<? super T> validator) {
        return new ValueValidator<T>(){

            @Override
            public void validate(@NotNull T value) throws ConfigValidationException {
                ValueValidator.this.validate(value);
                validator.validate(value);
            }

            @Override
            @NotNull
            public List<String> getValidationCommentLines() {
                ArrayList<String> commentLines = new ArrayList<String>(ValueValidator.this.getValidationCommentLines());
                commentLines.addAll(validator.getValidationCommentLines());
                return commentLines;
            }
        };
    }
}

