/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.codec.PacketCodecFix;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.slf4j.Logger;

public class FluidStack {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<FluidStack> CODEC_MILLIBUCKETS = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(fluidStack -> class_7923.field_41173.method_10221((Object)fluidStack.fluidVariant.getFluid())), (App)CodecFix.NON_NEGATIVE_LONG.fieldOf("amount").forGetter(fluidStack -> FluidUtils.convertDropletsToMilliBuckets(fluidStack.dropletsAmount)), (App)CodecFix.NON_NEGATIVE_LONG.optionalFieldOf("leftoverDropletsAmount", (Object)0L).forGetter(fluidStack -> {
        long milliBucketsAmount = FluidUtils.convertDropletsToMilliBuckets(fluidStack.dropletsAmount);
        return fluidStack.dropletsAmount - FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount);
    }), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(fluidStack -> fluidStack.fluidVariant.getComponents())).apply((Applicative)instance, (id, milliBucketsAmount, leftoverDropletsAmount, fluidComponents) -> {
        class_3611 fluid = (class_3611)class_7923.field_41173.method_63535(id);
        long dropletsAmount = FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount) + leftoverDropletsAmount;
        return new FluidStack(fluid, (class_9326)fluidComponents, dropletsAmount);
    }));
    public static final class_9139<class_9129, FluidStack> PACKET_CODEC = class_9139.method_56435((class_9139)FluidVariant.PACKET_CODEC, FluidStack::getFluidVariant, PacketCodecFix.LONG, FluidStack::getDropletsAmount, FluidStack::new);
    private FluidVariant fluidVariant;
    private long dropletsAmount;

    public FluidStack(class_3611 fluid, long dropletsAmount) {
        this(fluid, class_9326.field_49588, dropletsAmount);
    }

    public FluidStack(class_3611 fluid, class_9326 fluidComponents, long dropletsAmount) {
        this(FluidVariant.of((class_3611)fluid, (class_9326)fluidComponents), dropletsAmount);
    }

    public FluidStack(FluidVariant fluidVariant, long dropletsAmount) {
        this.fluidVariant = fluidVariant;
        this.dropletsAmount = dropletsAmount;
    }

    public FluidVariant getFluidVariant() {
        return this.fluidVariant;
    }

    public void setFluidVariant(FluidVariant fluidVariant) {
        this.fluidVariant = fluidVariant;
    }

    public long getDropletsAmount() {
        return this.dropletsAmount;
    }

    public void setDropletsAmount(long dropletsAmount) {
        this.dropletsAmount = dropletsAmount;
    }

    public long getMilliBucketsAmount() {
        return FluidUtils.convertDropletsToMilliBuckets(this.dropletsAmount);
    }

    public boolean isEmpty() {
        return this.fluidVariant.isBlank();
    }

    public class_3611 getFluid() {
        return this.fluidVariant.getFluid();
    }

    public String getTranslationKey() {
        return this.fluidVariant.getFluid().method_15785().method_15759().method_26204().method_63499();
    }
}

