/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import com.mojang.serialization.Codec;
import me.jddev0.ep.fluid.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class InfinityFluidStorage
extends SingleFluidStorage {
    public static final Codec<FluidStack> CODEC = FluidStack.CODEC_MILLIBUCKETS;

    public InfinityFluidStorage() {
        this.amount = Long.MAX_VALUE;
    }

    public boolean isEmpty() {
        return this.isResourceBlank();
    }

    public FluidStack getFluid() {
        return new FluidStack((FluidVariant)this.variant, Long.MAX_VALUE);
    }

    public void setFluid(FluidStack fluidStack) {
        this.variant = fluidStack.getFluidVariant();
    }

    protected long getCapacity(FluidVariant variant) {
        return Long.MAX_VALUE;
    }

    public void setFluid(FluidStack fluidStack, TransactionContext transaction) {
        FluidVariant fluidVariant = fluidStack.getFluidVariant();
        this.updateSnapshots(transaction);
        this.variant = fluidVariant;
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        return maxAmount;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        return !extractedVariant.isBlank() && extractedVariant.isOf((Object)((FluidVariant)this.variant).getFluid()) && extractedVariant.componentsMatch(((FluidVariant)this.variant).getComponents()) ? maxAmount : 0L;
    }
}

