/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import java.util.Arrays;
import java.util.List;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record OutputItemStackWithPercentages(class_1799 output, double[] percentages) {
    public static final OutputItemStackWithPercentages EMPTY = new OutputItemStackWithPercentages(class_1799.field_8037, new double[0]);
    private static final Codec<double[]> DOUBLE_ARRAY_CODEC = new Codec<double[]>(){
        private static final Codec<List<Double>> DOUBLE_LIST_CODEC = Codec.doubleRange((double)0.0, (double)1.0).listOf();

        public <T> DataResult<Pair<double[], T>> decode(DynamicOps<T> ops, T input) {
            return DOUBLE_LIST_CODEC.decode(ops, input).map(res -> Pair.of((Object)((List)res.getFirst()).stream().mapToDouble(Double::doubleValue).toArray(), (Object)res.getSecond()));
        }

        public <T> DataResult<T> encode(double[] input, DynamicOps<T> ops, T prefix) {
            return DOUBLE_LIST_CODEC.encode(Arrays.stream(input).boxed().toList(), ops, prefix);
        }
    };
    public static final Codec<OutputItemStackWithPercentages> CODEC_NONEMPTY = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("result").forGetter(output -> output.output), (App)DOUBLE_ARRAY_CODEC.fieldOf("percentages").forGetter(output -> output.percentages)).apply((Applicative)instance, OutputItemStackWithPercentages::new));
    public static final class_9139<class_9129, OutputItemStackWithPercentages> OPTIONAL_STREAM_CODEC = new class_9139<class_9129, OutputItemStackWithPercentages>(){

        @NotNull
        public OutputItemStackWithPercentages decode(@NotNull class_9129 buffer) {
            int percentageCount = buffer.readInt();
            if (percentageCount <= 0) {
                return EMPTY;
            }
            double[] percentages = new double[percentageCount];
            for (int j = 0; j < percentageCount; ++j) {
                percentages[j] = buffer.readDouble();
            }
            class_1799 output = (class_1799)class_1799.field_49268.decode((Object)buffer);
            return new OutputItemStackWithPercentages(output, percentages);
        }

        public void encode(@NotNull class_9129 buffer, OutputItemStackWithPercentages output) {
            if (output.isEmpty()) {
                buffer.method_53002(0);
            } else {
                buffer.method_53002(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.method_52940(percentage);
                }
                class_1799.field_49268.encode((Object)buffer, (Object)output.output);
            }
        }
    };
    public static final class_9139<class_9129, OutputItemStackWithPercentages> STREAM_CODEC = new class_9139<class_9129, OutputItemStackWithPercentages>(){

        @NotNull
        public OutputItemStackWithPercentages decode(@NotNull class_9129 buffer) {
            OutputItemStackWithPercentages ingredient = (OutputItemStackWithPercentages)OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            if (ingredient.isEmpty()) {
                throw new DecoderException("Empty OutputItemStackWithPercentages not allowed");
            }
            return ingredient;
        }

        public void encode(@NotNull class_9129 buffer, OutputItemStackWithPercentages output) {
            if (output.isEmpty()) {
                throw new DecoderException("Empty OutputItemStackWithPercentages not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)output);
        }
    };

    public OutputItemStackWithPercentages(class_1799 output, double percentage) {
        this(output, new double[]{percentage});
    }

    public OutputItemStackWithPercentages(class_1799 output) {
        this(output, 1.0);
    }

    public boolean isEmpty() {
        return this.output.method_7960() || this.percentages.length == 0;
    }
}

