/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.EnergizedPowerBaseRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public class PlantGrowthChamberRecipe
implements EnergizedPowerBaseRecipe<class_9695> {
    private final OutputItemStackWithPercentages[] outputs;
    private final class_1856 input;
    private final int ticks;

    public PlantGrowthChamberRecipe(OutputItemStackWithPercentages[] outputs, class_1856 input, int ticks) {
        this.outputs = outputs;
        this.input = input;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages[] getOutputs() {
        return this.outputs;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public int getTicks() {
        return this.ticks;
    }

    public class_1799[] getMaxOutputCounts() {
        class_1799[] generatedOutputs = new class_1799[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            OutputItemStackWithPercentages output = this.outputs[i];
            generatedOutputs[i] = output.output().method_46651(output.percentages().length);
        }
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource) {
        class_1799[] generatedOutputs = new class_1799[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = this.outputs[i];
            for (double percentage : output.percentages()) {
                if (!(randomSource.method_43058() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output().method_46651(count);
        }
        return generatedOutputs;
    }

    public boolean method_8115(class_9695 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        return this.input.method_8093(container.method_59984(0));
    }

    public class_1799 method_8116(class_9695 container, class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public boolean method_8118() {
        return true;
    }

    public class_10355 method_64668() {
        return EPRecipes.PLANT_GROWTH_CHAMBER_CATEGORY;
    }

    public class_1865<? extends class_1860<class_9695>> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<? extends class_1860<class_9695>> method_17716() {
        return Type.INSTANCE;
    }

    @Override
    public List<class_1856> getIngredients() {
        return List.of(this.input);
    }

    @Override
    public boolean isIngredient(class_1799 itemStack) {
        return this.input.method_8093(itemStack);
    }

    @Override
    public boolean isResult(class_1799 itemStack) {
        return Arrays.stream(this.outputs).map(OutputItemStackWithPercentages::output).anyMatch(output -> class_1799.method_31577((class_1799)output, (class_1799)itemStack));
    }

    public static final class Serializer
    implements class_1865<PlantGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = EPAPI.id("plant_growth_chamber");
        private final MapCodec<PlantGrowthChamberRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)new ArrayCodec<OutputItemStackWithPercentages>(OutputItemStackWithPercentages.CODEC_NONEMPTY, OutputItemStackWithPercentages[]::new).fieldOf("results").forGetter(recipe -> recipe.outputs), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)class_5699.field_33442.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, PlantGrowthChamberRecipe::new));
        private final class_9139<class_9129, PlantGrowthChamberRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<PlantGrowthChamberRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, PlantGrowthChamberRecipe> method_56104() {
            return this.PACKET_CODEC;
        }

        private static PlantGrowthChamberRecipe read(class_9129 buffer) {
            class_1856 input = (class_1856)class_1856.field_48355.decode((Object)buffer);
            int ticks = buffer.readInt();
            int outputCount = buffer.readInt();
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                outputs[i] = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            }
            return new PlantGrowthChamberRecipe(outputs, input, ticks);
        }

        private static void write(class_9129 buffer, PlantGrowthChamberRecipe recipe) {
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.input);
            buffer.method_53002(recipe.ticks);
            buffer.method_53002(recipe.outputs.length);
            for (OutputItemStackWithPercentages output : recipe.outputs) {
                OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)output);
            }
        }
    }

    public static final class Type
    implements class_3956<PlantGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plant_growth_chamber";

        private Type() {
        }
    }
}

