/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.PopEnergizedPowerBookFromLecternC2SPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3722;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class EnergizedPowerBookScreen
extends class_437 {
    public static final class_2960 TEXTURE = EPAPI.id("textures/gui/book/energized_power_book.png");
    public static final class_2960 FRONT_COVER = EPAPI.id("textures/gui/book/front_cover.png");
    public static final class_2960 BACK_COVER = EPAPI.id("textures/gui/book/back_cover.png");
    public static final class_2960 ENERGIZED_COPPER_INGOT = EPAPI.id("textures/item/energized_copper_ingot.png");
    public static final int IMAGE_CYCLE_DELAY = ModConfigs.CLIENT_ENERGIZED_POWER_BOOK_IMAGE_CYCLE_DELAY.getValue();
    private static final int MAX_CHARS_PER_LINE = 148;
    private static final int MAX_LINES = 19;
    private static List<PageContent> pages = new ArrayList<PageContent>();
    private int currentTick;
    private class_474 forwardButton;
    private class_474 backButton;
    private final class_3722 lecternBlockEntity;
    private class_2960 openOnPageForBlock;
    private List<FormattedPageContent> formattedPages;
    private int currentPage;
    private class_2561 currentPageNumberOutput = class_2561.method_43473();
    private boolean isCurrentPageCached;

    public static void setPages(List<PageContent> pages) {
        EnergizedPowerBookScreen.pages = new ArrayList<PageContent>(pages);
    }

    public EnergizedPowerBookScreen() {
        this(null, null);
    }

    public EnergizedPowerBookScreen(class_2960 openOnPageForBlock) {
        this(null, openOnPageForBlock);
    }

    public EnergizedPowerBookScreen(class_3722 lecternBlockEntity) {
        this(lecternBlockEntity, null);
    }

    public EnergizedPowerBookScreen(class_3722 lecternBlockEntity, class_2960 openOnPageForBlock) {
        super(class_333.field_18967);
        this.lecternBlockEntity = lecternBlockEntity;
        this.openOnPageForBlock = openOnPageForBlock;
    }

    protected void method_25426() {
        this.createMenuControls();
        this.createPageControlButtons();
        ArrayList<FormattedPageContent> formattedPages = new ArrayList<FormattedPageContent>();
        formattedPages.add(new FormattedPageContent(EPAPI.id("front_cover"), null, this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"book.energizedpower.front.cover.text").method_27692(class_124.field_1080), 148), null, null, null));
        for (PageContent pageContent : pages) {
            ArrayList<class_5481> formattedPageComponents;
            class_2960 pageId = pageContent.getPageId();
            class_2561 chapterTitleComponent = pageContent.getChapterTitleComponent();
            class_2960[] imageResourceLocations = pageContent.getImageResourceLocations();
            class_2960[] blockResourceLocations = pageContent.getBlockResourceLocations();
            Map<Integer, class_2960> changePageIntToId = pageContent.getChangePageIntToId();
            List<Object> list = formattedPageComponents = pageContent.getPageComponent() == null ? new ArrayList<class_5481>(0) : this.field_22793.method_1728((class_5348)pageContent.getPageComponent(), 148);
            if (chapterTitleComponent != null) {
                formattedPages.add(new FormattedPageContent(pageId, chapterTitleComponent, formattedPageComponents, imageResourceLocations, blockResourceLocations, changePageIntToId));
                continue;
            }
            int maxLineCountFirstPage = 19 - (imageResourceLocations != null || blockResourceLocations != null ? 7 : 0);
            formattedPages.add(new FormattedPageContent(pageId, chapterTitleComponent, formattedPageComponents.subList(0, Math.min(maxLineCountFirstPage, formattedPageComponents.size())), imageResourceLocations, blockResourceLocations, changePageIntToId));
            int i = maxLineCountFirstPage;
            int splitPageCount = 2;
            while (i < formattedPageComponents.size()) {
                class_2960 tmpPageId = class_2960.method_60655((String)pageId.method_12836(), (String)(pageId.method_12832() + "/tmp_page_" + splitPageCount));
                formattedPages.add(new FormattedPageContent(tmpPageId, null, formattedPageComponents.subList(i, Math.min(i + 19, formattedPageComponents.size())), null, null, changePageIntToId));
                i += 19;
                ++splitPageCount;
            }
        }
        formattedPages.add(new FormattedPageContent(EPAPI.id("back_cover"), null, new ArrayList<class_5481>(0), null, null, null));
        this.formattedPages = new ArrayList<FormattedPageContent>(formattedPages);
        this.updateButtonVisibility();
        if (this.openOnPageForBlock != null) {
            block2: for (int i = 0; i < formattedPages.size(); ++i) {
                class_2960[] blockResourceLocations = ((FormattedPageContent)formattedPages.get(i)).getBlockResourceLocations();
                if (blockResourceLocations == null) continue;
                for (class_2960 block : blockResourceLocations) {
                    if (!block.equals((Object)this.openOnPageForBlock)) continue;
                    this.setPage(i);
                    break block2;
                }
            }
            this.openOnPageForBlock = null;
        }
    }

    private void createMenuControls() {
        boolean showTakeButton = this.lecternBlockEntity != null && this.field_22787.field_1724.method_7294();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 116, 232, showTakeButton ? 116 : 236, 20).method_46431());
        if (showTakeButton) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"lectern.take_book"), button -> {
                ModMessages.sendClientPacketToServer(new PopEnergizedPowerBookFromLecternC2SPacket(this.lecternBlockEntity.method_11016()));
                this.method_25419();
            }).method_46434(this.field_22789 / 2 + 2, 232, 116, 20).method_46431());
        }
    }

    private void createPageControlButtons() {
        int startX = (this.field_22789 - 226) / 2;
        this.forwardButton = (class_474)this.method_37063((class_364)new class_474(startX + 150, 193, true, button -> this.pageForward(), true));
        this.backButton = (class_474)this.method_37063((class_364)new class_474(startX + 43, 193, false, button -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    private int getPageCount() {
        return this.formattedPages == null ? 0 : this.formattedPages.size();
    }

    private void pageForward() {
        if (this.currentPage < this.getPageCount() - 1) {
            ++this.currentPage;
            this.isCurrentPageCached = false;
        }
        this.updateButtonVisibility();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.isCurrentPageCached = false;
        }
        this.updateButtonVisibility();
    }

    private boolean setPage(int page) {
        if (page < 0 || page >= this.getPageCount() || page == this.currentPage) {
            return false;
        }
        this.currentPage = page;
        this.isCurrentPageCached = false;
        this.updateButtonVisibility();
        return true;
    }

    private void updateButtonVisibility() {
        this.forwardButton.field_22764 = this.currentPage < this.getPageCount() - 1;
        this.backButton.field_22764 = this.currentPage > 0;
    }

    public boolean method_25404(class_11908 input) {
        int keyCode = input.comp_4795();
        if (super.method_25404(input)) {
            return true;
        }
        int oldCurrentPage = this.currentPage;
        return switch (keyCode) {
            case 266 -> {
                this.backButton.method_25306((class_11907)input);
                if (this.currentPage != oldCurrentPage) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
                }
                yield true;
            }
            case 267 -> {
                this.forwardButton.method_25306((class_11907)input);
                if (this.currentPage != oldCurrentPage) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
                }
                yield true;
            }
            default -> false;
        };
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        class_2583 style;
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int mouseButton = click.method_74245();
        if (mouseButton == 0 && (style = this.getComponentStyleAt(mouseX, mouseY)) != null && this.method_25430(style)) {
            return true;
        }
        return super.method_25402(click, doubled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_25430(class_2583 style) {
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null || this.formattedPages == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            FormattedPageContent formattedPageContent = this.formattedPages.get(this.currentPage);
            Map<Integer, class_2960> changePageIntToId = formattedPageContent.getChangePageIntToId();
            class_2558.class_10605 changePageEvent = (class_2558.class_10605)clickEvent;
            int oldCurrentPage = this.currentPage;
            try {
                int i;
                class_2960 pageId;
                int pageNum = changePageEvent.comp_3502();
                class_2960 class_29602 = pageId = changePageIntToId == null ? null : changePageIntToId.get(pageNum);
                if (pageId == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean containsKeyFlag = false;
                for (i = 0; i < this.formattedPages.size(); ++i) {
                    if (!this.formattedPages.get(i).getPageId().equals((Object)pageId)) continue;
                    containsKeyFlag = true;
                    break;
                }
                if (!containsKeyFlag) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.setPage(i);
                return bl;
            }
            finally {
                if (this.currentPage != oldCurrentPage) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
                }
            }
        }
        boolean flag = super.method_25430(style);
        if (flag && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return flag;
    }

    public void method_25420(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25420(drawContext, mouseX, mouseY, delta);
        if (this.formattedPages == null) {
            return;
        }
        int startX = (this.field_22789 - 226) / 2;
        if (this.currentPage == 0) {
            drawContext.method_25290(class_10799.field_56883, FRONT_COVER, startX, 2, 0.0f, 0.0f, 226, 230, 256, 256);
        } else if (this.currentPage == this.getPageCount() - 1) {
            drawContext.method_25290(class_10799.field_56883, BACK_COVER, startX, 2, 0.0f, 0.0f, 226, 230, 256, 256);
        } else {
            drawContext.method_25290(class_10799.field_56883, TEXTURE, startX, 2, 0.0f, 0.0f, 226, 230, 256, 256);
        }
        if (!this.isCurrentPageCached) {
            this.currentPageNumberOutput = class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage, Math.max(this.getPageCount() - 1, 1)});
            this.isCurrentPageCached = true;
        }
        int textWidth = this.field_22793.method_27525((class_5348)this.currentPageNumberOutput);
        drawContext.method_51439(this.field_22793, this.currentPageNumberOutput, (int)((float)(this.field_22789 - textWidth) / 2.0f), 222, -1, false);
        if (this.currentPage == 0) {
            this.renderFrontCover(drawContext);
            return;
        }
        if (this.currentPage == this.getPageCount() - 1) {
            this.renderImageCentered(drawContext, ENERGIZED_COPPER_INGOT, -1);
            return;
        }
        int yOffset = 0;
        class_2960[] images = this.formattedPages.get(this.currentPage).getImageResourceLocations();
        class_2960[] blocks = this.formattedPages.get(this.currentPage).getBlockResourceLocations();
        class_2561 chapterTitleComponent = this.formattedPages.get(this.currentPage).getChapterTitleComponent();
        if (chapterTitleComponent != null) {
            float f;
            float scaleFactor = 1.5f;
            float f2 = 230.0f / scaleFactor;
            Objects.requireNonNull(this.field_22793);
            float f3 = f2 - 9.0f;
            if (this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
                f = 0.0f;
            } else {
                int n = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size() + 1;
                Objects.requireNonNull(this.field_22793);
                f = (float)(n * 9) / scaleFactor;
            }
            yOffset = (int)((f3 - f) * 0.5f);
            if (images != null) {
                yOffset = (int)((float)yOffset - 30.0f / scaleFactor);
            }
            if (blocks != null) {
                yOffset = (int)((float)yOffset - 30.0f / scaleFactor);
            }
            drawContext.method_51448().scale(scaleFactor, scaleFactor);
            drawContext.method_51439(this.field_22793, chapterTitleComponent, (int)(((float)this.field_22789 / scaleFactor - (float)this.field_22793.method_27525((class_5348)chapterTitleComponent)) * 0.5f), yOffset, -16777216, false);
            drawContext.method_51448().scale(1.0f / scaleFactor, 1.0f / scaleFactor);
            yOffset = (int)((float)yOffset * scaleFactor);
        }
        if (images != null) {
            this.renderImageCentered(drawContext, images[this.currentTick / IMAGE_CYCLE_DELAY % images.length], yOffset + 15);
            yOffset += 60;
        }
        if (blocks != null) {
            this.renderBlockCentered(drawContext, blocks[this.currentTick / IMAGE_CYCLE_DELAY % blocks.length], yOffset + 15);
            yOffset += 60;
        }
        if (!this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
            for (int i = 0; i < this.formattedPages.get(this.currentPage).getPageFormattedTexts().size(); ++i) {
                class_5481 formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(i);
                float x = chapterTitleComponent == null ? (float)startX + 36.0f : (float)(this.field_22789 - this.field_22793.method_30880(formattedCharSequence)) * 0.5f;
                drawContext.method_51430(this.field_22793, formattedCharSequence, (int)x, 20 + yOffset + 9 * i, -16777216, false);
            }
            class_2583 style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null) {
                drawContext.method_51441(this.field_22793, style, mouseX, mouseY);
            }
        }
    }

    private void renderFrontCover(class_332 drawContext) {
        int startX = (this.field_22789 - 226) / 2;
        float scaleFactor = 1.35f;
        class_5250 component = class_2561.method_43470((String)"Energized Power").method_27692(class_124.field_1065);
        int textWidth = this.field_22793.method_27525((class_5348)component);
        drawContext.method_51448().scale(scaleFactor, scaleFactor);
        drawContext.method_51439(this.field_22793, (class_2561)component, (int)(((float)this.field_22789 / scaleFactor - (float)textWidth) * 0.5f), (int)(30.0f / scaleFactor), -16777216, false);
        drawContext.method_51448().scale(1.0f / scaleFactor, 1.0f / scaleFactor);
        component = class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{"JDDev0"}).method_27692(class_124.field_1065);
        textWidth = this.field_22793.method_27525((class_5348)component);
        drawContext.method_51439(this.field_22793, (class_2561)component, (int)((float)(this.field_22789 - textWidth) * 0.5f), 147, -16777216, false);
        for (int i = 0; i < this.formattedPages.get(this.currentPage).getPageFormattedTexts().size(); ++i) {
            class_5481 formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(i);
            drawContext.method_51430(this.field_22793, formattedCharSequence, startX + 36, 120 + 9 * i, -16777216, false);
        }
        this.renderImageCentered(drawContext, ENERGIZED_COPPER_INGOT, 48);
    }

    private void renderImageCentered(class_332 drawContext, class_2960 image, int y) {
        float scaleFactor = 0.25f;
        if (y == -1) {
            y = (int)((230.0f - 256.0f * scaleFactor) * 0.5f) + 2;
        }
        drawContext.method_51448().scale(scaleFactor, scaleFactor);
        drawContext.method_25290(class_10799.field_56883, image, (int)(((float)this.field_22789 / scaleFactor - 256.0f) * 0.5f), (int)((float)y / scaleFactor), 0.0f, 0.0f, 256, 256, 256, 256);
        drawContext.method_51448().scale(1.0f / scaleFactor, 1.0f / scaleFactor);
    }

    private void renderBlockCentered(class_332 drawContext, class_2960 blockResourceLocation, int y) {
        if (y == -1) {
            y = 85;
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(blockResourceLocation);
        class_1799 itemStack = new class_1799((class_1935)block);
        drawContext.method_51448().pushMatrix();
        drawContext.method_51448().translate(((float)this.field_22789 - 64.0f) * 0.5f, (float)y - 2.0f);
        drawContext.method_51448().scale(4.0f, 4.0f);
        drawContext.method_51445(itemStack, 0, 0);
        drawContext.method_51448().popMatrix();
    }

    private class_2583 getComponentStyleAt(double x, double y) {
        if (this.formattedPages == null || this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
            return null;
        }
        int componentX = class_3532.method_15357((double)(x - (double)(this.field_22789 - 226) * 0.5 - 36.0));
        int componentY = class_3532.method_15357((double)(y - 20.0));
        if (this.currentPage > 0 && this.currentPage < this.getPageCount() - 1) {
            class_2960[] images = this.formattedPages.get(this.currentPage).getImageResourceLocations();
            class_2960[] blocks = this.formattedPages.get(this.currentPage).getBlockResourceLocations();
            class_2561 chapterTitleComponent = this.formattedPages.get(this.currentPage).getChapterTitleComponent();
            if (chapterTitleComponent != null) {
                float f;
                float scaleFactor = 1.5f;
                float f2 = 230.0f / scaleFactor;
                Objects.requireNonNull(this.field_22793);
                float f3 = f2 - 9.0f;
                if (this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
                    f = 0.0f;
                } else {
                    int n = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size() + 1;
                    Objects.requireNonNull(this.field_22793);
                    f = (float)(n * 9) / scaleFactor;
                }
                componentY = -((int)((f3 - f) * 0.5f));
                if (images != null) {
                    componentY = (int)((float)componentY + 30.0f / scaleFactor);
                }
                if (blocks != null) {
                    componentY = (int)((float)componentY + 30.0f / scaleFactor);
                }
                componentY = (int)((float)componentY * scaleFactor);
                componentY += class_3532.method_15357((double)(y - 20.0));
            }
            if (images != null) {
                componentY -= 60;
            }
            if (blocks != null) {
                componentY -= 60;
            }
            if (chapterTitleComponent != null) {
                int componentIndex = componentY / 9;
                if (componentIndex < 0 || componentIndex >= this.formattedPages.get(this.currentPage).getPageFormattedTexts().size()) {
                    return null;
                }
                class_5481 formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(componentIndex);
                componentX = class_3532.method_15357((double)(x - (double)((float)(this.field_22789 - this.field_22793.method_30880(formattedCharSequence)) * 0.5f)));
            }
        }
        if (componentX < 0 || componentY < 0) {
            return null;
        }
        int componentCount = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size();
        if (componentX > 178 || componentY >= 9 * componentCount + componentCount) {
            return null;
        }
        int componentIndex = componentY / 9;
        if (componentIndex >= this.formattedPages.get(this.currentPage).getPageFormattedTexts().size()) {
            return null;
        }
        return this.field_22787.field_1772.method_27527().method_30876(this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(componentIndex), componentX);
    }

    public boolean method_25421() {
        return this.lecternBlockEntity == null;
    }

    public void method_25393() {
        ++this.currentTick;
    }

    @Environment(value=EnvType.CLIENT)
    private static class FormattedPageContent {
        private final class_2960 pageId;
        private final class_2561 chapterTitleComponent;
        private final List<class_5481> pageFormattedTexts;
        private final class_2960[] imageResourceLocations;
        private final class_2960[] blockResourceLocations;
        private final Map<Integer, class_2960> changePageIntToId;

        public FormattedPageContent(class_2960 pageId, class_2561 chapterTitleComponent, List<class_5481> pageFormattedTexts, class_2960[] imageResourceLocations, class_2960[] blockResourceLocations, Map<Integer, class_2960> changePageIntToId) {
            this.pageId = pageId;
            this.chapterTitleComponent = chapterTitleComponent;
            this.pageFormattedTexts = pageFormattedTexts;
            this.imageResourceLocations = imageResourceLocations;
            this.blockResourceLocations = blockResourceLocations;
            this.changePageIntToId = changePageIntToId;
        }

        public class_2960 getPageId() {
            return this.pageId;
        }

        public class_2561 getChapterTitleComponent() {
            return this.chapterTitleComponent;
        }

        public List<class_5481> getPageFormattedTexts() {
            return this.pageFormattedTexts;
        }

        public class_2960[] getImageResourceLocations() {
            return this.imageResourceLocations;
        }

        public class_2960[] getBlockResourceLocations() {
            return this.blockResourceLocations;
        }

        public Map<Integer, class_2960> getChangePageIntToId() {
            return this.changePageIntToId;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PageContent {
        private final class_2960 pageId;
        private final class_2561 chapterTitleComponent;
        private final class_2561 pageComponent;
        private final class_2960[] imageResourceLocations;
        private final class_2960[] blockResourceLocations;
        private final Map<Integer, class_2960> changePageIntToId;

        public PageContent(class_2960 pageId, class_2561 chapterTitleComponent, class_2561 pageComponent, class_2960[] imageResourceLocations, class_2960[] blockResourceLocations, Map<Integer, class_2960> changePageIntToId) {
            this.pageId = pageId;
            this.chapterTitleComponent = chapterTitleComponent;
            this.pageComponent = pageComponent;
            this.imageResourceLocations = imageResourceLocations;
            this.blockResourceLocations = blockResourceLocations;
            this.changePageIntToId = changePageIntToId;
        }

        public class_2960 getPageId() {
            return this.pageId;
        }

        public class_2561 getChapterTitleComponent() {
            return this.chapterTitleComponent;
        }

        public class_2561 getPageComponent() {
            return this.pageComponent;
        }

        public class_2960[] getImageResourceLocations() {
            return this.imageResourceLocations;
        }

        public class_2960[] getBlockResourceLocations() {
            return this.blockResourceLocations;
        }

        public Map<Integer, class_2960> getChangePageIntToId() {
            return this.changePageIntToId;
        }
    }
}

