/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import java.util.Collection;
import java.util.List;
import me.jddev0.ep.recipe.EnergizedPowerBaseRecipe;
import net.minecraft.class_10295;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public final class RecipeUtils {
    private RecipeUtils() {
    }

    public static <C extends class_9695, T extends class_1860<C>> Collection<class_8786<T>> getAllRecipesFor(class_3218 level, class_3956<T> recipeType) {
        return level.method_64577().getAllOfType(recipeType);
    }

    public static <C extends class_9695, T extends class_1860<C>> boolean isIngredientOfAny(class_3218 level, class_3956<T> recipeType, class_1799 itemStack) {
        Collection<class_8786<T>> recipes = RecipeUtils.getAllRecipesFor(level, recipeType);
        return recipes.stream().map(class_8786::comp_1933).anyMatch(recipe -> {
            if (recipe instanceof EnergizedPowerBaseRecipe) {
                EnergizedPowerBaseRecipe epRecipe = (EnergizedPowerBaseRecipe)recipe;
                return epRecipe.isIngredient(itemStack);
            }
            return recipe.method_61671().method_64675().stream().anyMatch(ingredient -> ingredient.method_8093(itemStack));
        });
    }

    public static boolean isIngredientOfAny(List<class_1856> ingredientList, class_1799 itemStack) {
        return ingredientList.stream().anyMatch(ingredient -> ingredient.method_8093(itemStack));
    }

    public static <C extends class_9695, T extends class_1860<C>> List<class_1856> getIngredientsOf(class_3218 level, class_3956<T> recipeType) {
        Collection<class_8786<T>> recipes = RecipeUtils.getAllRecipesFor(level, recipeType);
        return recipes.stream().map(class_8786::comp_1933).flatMap(recipe -> {
            if (recipe instanceof EnergizedPowerBaseRecipe) {
                EnergizedPowerBaseRecipe epRecipe = (EnergizedPowerBaseRecipe)recipe;
                return epRecipe.getIngredients().stream();
            }
            return recipe.method_61671().method_64675().stream();
        }).toList();
    }

    public static <C extends class_9695, T extends class_1860<C>> boolean isResultOfAny(class_3218 level, class_3956<T> recipeType, class_1799 itemStack) {
        Collection<class_8786<T>> recipes = RecipeUtils.getAllRecipesFor(level, recipeType);
        return recipes.stream().map(class_8786::comp_1933).anyMatch(recipe -> {
            if (recipe instanceof EnergizedPowerBaseRecipe) {
                EnergizedPowerBaseRecipe epRecipe = (EnergizedPowerBaseRecipe)recipe;
                return epRecipe.isResult(itemStack);
            }
            return recipe.method_64664().stream().filter(recipeDisplay -> recipeDisplay.method_64728(level.method_45162())).map(class_10295::comp_3258).flatMap(result -> result.method_64738(class_10363.method_65008((class_1937)level)).stream()).anyMatch(stack -> class_1799.method_31577((class_1799)stack, (class_1799)itemStack));
        });
    }
}

