/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.jddev0.ep.block.AdvancedAutoCrafterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.inventory.data.ShortValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AdvancedAutoCrafterMenu;
import me.jddev0.ep.util.ItemStackUtils;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedAutoCrafterBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277>
implements CheckboxUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    public static final long ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue().intValue();
    private static final int RECIPE_DURATION = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private boolean secondaryExtractMode = false;
    private boolean allowOutputOverflow = true;
    final InputOutputItemHandler itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i >= 5, i -> this.secondaryExtractMode ? !this.isInput(this.itemHandler.method_5438(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.itemHandler.method_5438(i.intValue())));
    private final class_1277[] patternSlots = new class_1277[]{new class_1277(9){

        public int method_5444() {
            return 1;
        }
    }, new class_1277(9){

        public int method_5444() {
            return 1;
        }
    }, new class_1277(9){

        public int method_5444() {
            return 1;
        }
    }};
    private final class_1277[] patternResultSlots = new class_1277[]{new class_1277(1), new class_1277(1), new class_1277(1)};
    private final class_1265[] updatePatternListener = new class_1265[]{container -> this.updateRecipe(0), container -> this.updateRecipe(1), container -> this.updateRecipe(2)};
    private final boolean[] hasRecipeLoaded = new boolean[]{false, false, false};
    private final class_2960[] recipeIdForSetRecipe = new class_2960[]{null, null, null};
    private final class_3955[] craftingRecipe = new class_3955[]{null, null, null};
    private final class_1715[] oldCopyOfRecipe = new class_1715[]{null, null, null};
    private final class_1703 dummyContainerMenu = new class_1703(null, -1){

        public class_1799 method_7601(class_1657 player, int index) {
            return null;
        }

        public boolean method_7597(class_1657 player) {
            return false;
        }

        public void method_7609(class_1263 container) {
        }
    };
    private final int[] progress = new int[]{0, 0, 0};
    private final int[] maxProgress = new int[]{0, 0, 0};
    private final long[] energyConsumptionLeft = new long[]{-1L, -1L, -1L};
    private final boolean[] hasEnoughEnergy = new boolean[]{false, false, false};
    private final boolean[] ignoreNBT = new boolean[]{false, false, false};
    private int currentRecipeIndex = 0;

    public AdvancedAutoCrafterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.ADVANCED_AUTO_CRAFTER_ENTITY, blockPos, blockState, "advanced_auto_crafter", ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_TRANSFER_RATE.getValue(), 27, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.patternSlots[i2].method_5489(this.updatePatternListener[i2]);
        }
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * AdvancedAutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                AdvancedAutoCrafterBlockEntity.this.method_5431();
                AdvancedAutoCrafterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * AdvancedAutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot < 0 || slot >= 27) {
                    return super.method_5437(slot, stack);
                }
                return slot >= 5;
            }

            public void method_5431() {
                super.method_5431();
                AdvancedAutoCrafterBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress[0], value -> {
            this.progress[0] = value;
        }), new ProgressValueContainerData(() -> this.progress[1], value -> {
            this.progress[1] = value;
        }), new ProgressValueContainerData(() -> this.progress[2], value -> {
            this.progress[2] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[0], value -> {
            this.maxProgress[0] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[1], value -> {
            this.maxProgress[1] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[2], value -> {
            this.maxProgress[2] = value;
        }), new EnergyValueContainerData(this::getEnergyConsumptionPerTickSum, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[0], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[1], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[2], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[0], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[1], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[2], value -> {}), new BooleanValueContainerData(() -> this.ignoreNBT[0], value -> {
            this.ignoreNBT[0] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[1], value -> {
            this.ignoreNBT[1] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[2], value -> {
            this.ignoreNBT[2] = value;
        }), new BooleanValueContainerData(() -> this.secondaryExtractMode, value -> {
            this.secondaryExtractMode = value;
        }), new BooleanValueContainerData(() -> this.allowOutputOverflow, value -> {
            this.allowOutputOverflow = value;
        }), new ShortValueContainerData(() -> (short)this.currentRecipeIndex, value -> {
            this.currentRecipeIndex = value.shortValue();
        }), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new AdvancedAutoCrafterMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, (class_1263[])this.patternSlots, (class_1263[])this.patternResultSlots, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        int i;
        super.method_11007(nbt);
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("pattern." + i, (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.patternSlots[i].field_5828));
        }
        for (i = 0; i < 3; ++i) {
            if (this.craftingRecipe[i] != null) {
                nbt.method_10566("recipe.id." + i, (class_2520)class_2519.method_23256((String)this.craftingRecipe[i].method_8114().toString()));
            }
            nbt.method_10566("recipe.progress." + i, (class_2520)class_2497.method_23247((int)this.progress[i]));
            nbt.method_10566("recipe.max_progress." + i, (class_2520)class_2497.method_23247((int)this.maxProgress[i]));
            nbt.method_10566("recipe.energy_consumption_left." + i, (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft[i]));
            nbt.method_10556("ignore_nbt." + i, this.ignoreNBT[i]);
        }
        nbt.method_10556("secondary_extract_mode", this.secondaryExtractMode);
        nbt.method_10556("allow_output_overflow", this.allowOutputOverflow);
        nbt.method_10569("current_recipe_index", this.currentRecipeIndex);
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        int i;
        super.method_11014(nbt);
        for (i = 0; i < 3; ++i) {
            this.patternSlots[i].method_5488(this.updatePatternListener[i]);
            class_1262.method_5429((class_2487)nbt.method_10562("pattern." + i), (class_2371)this.patternSlots[i].field_5828);
            this.patternSlots[i].method_5489(this.updatePatternListener[i]);
        }
        for (i = 0; i < 3; ++i) {
            if (nbt.method_10545("recipe.id." + i)) {
                class_2520 tag = nbt.method_10580("recipe.id." + i);
                if (!(tag instanceof class_2519)) {
                    throw new IllegalArgumentException("Tag must be of type StringTag!");
                }
                class_2519 stringTag = (class_2519)tag;
                this.recipeIdForSetRecipe[i] = class_2960.method_12829((String)stringTag.method_10714());
            }
            this.progress[i] = nbt.method_10550("recipe.progress." + i);
            this.maxProgress[i] = nbt.method_10550("recipe.max_progress." + i);
            this.energyConsumptionLeft[i] = nbt.method_10537("recipe.energy_consumption_left." + i);
            this.ignoreNBT[i] = nbt.method_10577("ignore_nbt." + i);
        }
        this.secondaryExtractMode = nbt.method_10577("secondary_extract_mode");
        this.allowOutputOverflow = !nbt.method_10545("allow_output_overflow") || nbt.method_10577("allow_output_overflow");
        this.currentRecipeIndex = nbt.method_10550("current_recipe_index");
        if (this.currentRecipeIndex < 0 || this.currentRecipeIndex >= 3) {
            this.currentRecipeIndex = 0;
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedAutoCrafterBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AdvancedAutoCrafterBlock.POWERED))) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (!blockEntity.hasRecipeLoaded[i]) {
                blockEntity.updateRecipe(i);
                if (blockEntity.craftingRecipe[i] == null) {
                    blockEntity.resetProgress(i);
                }
                AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
            int itemCount = 0;
            for (int j = 0; j < blockEntity.patternSlots[i].method_5439(); ++j) {
                if (blockEntity.patternSlots[i].method_5438(j).method_7960()) continue;
                ++itemCount;
            }
            if (itemCount == 0) continue;
            if (blockEntity.craftingRecipe[i] != null && (blockEntity.progress[i] > 0 || blockEntity.canInsertItemsIntoOutputSlots(i) && blockEntity.canExtractItemsFromInput(i))) {
                if (!blockEntity.canInsertItemsIntoOutputSlots(i) || !blockEntity.canExtractItemsFromInput(i)) continue;
                if (blockEntity.maxProgress[i] == 0) {
                    blockEntity.maxProgress[i] = Math.max(1, (int)Math.ceil((double)RECIPE_DURATION / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
                }
                long energyConsumptionPerTick = Math.max(1L, (long)Math.ceil((double)((long)itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
                if (blockEntity.progress[i] == 0) {
                    if (!blockEntity.canExtractItemsFromInput(i)) continue;
                    blockEntity.energyConsumptionLeft[i] = energyConsumptionPerTick * (long)blockEntity.maxProgress[i];
                }
                if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0L) {
                    blockEntity.resetProgress(i);
                    AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                if (energyConsumptionPerTick <= blockEntity.limitingEnergyStorage.getAmount()) {
                    try (Transaction transaction = Transaction.openOuter();){
                        blockEntity.limitingEnergyStorage.extract(energyConsumptionPerTick, (TransactionContext)transaction);
                        transaction.commit();
                    }
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        class_1277 patternSlotsForRecipe = blockEntity.ignoreNBT[i] ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots[i]) : blockEntity.patternSlots[i];
                        class_1715 copyOfPatternSlots = new class_1715(blockEntity.dummyContainerMenu, 3, 3);
                        for (int j = 0; j < patternSlotsForRecipe.method_5439(); ++j) {
                            copyOfPatternSlots.method_5447(j, patternSlotsForRecipe.method_5438(j));
                        }
                        blockEntity.extractItems(i);
                        blockEntity.craftItem(i, copyOfPatternSlots);
                    }
                    AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    protected final long getEnergyConsumptionPerTickSum() {
        long energyConsumptionSum = -1L;
        for (int i = 0; i < 3; ++i) {
            int itemCount = 0;
            for (int j = 0; j < this.patternSlots[i].method_5439(); ++j) {
                if (this.patternSlots[i].method_5438(j).method_7960()) continue;
                ++itemCount;
            }
            if (itemCount == 0 || this.craftingRecipe[i] == null || this.progress[i] <= 0) continue;
            long energyConsumption = Math.max(1L, (long)Math.ceil((double)((long)itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            energyConsumptionSum = energyConsumptionSum == -1L ? energyConsumption : (energyConsumptionSum += energyConsumption);
            if (energyConsumptionSum >= 0L) continue;
            energyConsumptionSum = Long.MAX_VALUE;
        }
        return energyConsumptionSum;
    }

    private void resetProgress(int index) {
        this.progress[index] = 0;
        this.maxProgress[index] = 0;
        this.energyConsumptionLeft[index] = -1L;
        this.hasEnoughEnergy[index] = true;
    }

    public void resetProgressAndMarkAsChanged(int index) {
        this.resetProgress(index);
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void cycleRecipe() {
        class_1277 patternSlotsForRecipe = this.ignoreNBT[this.currentRecipeIndex] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[this.currentRecipeIndex]) : this.patternSlots[this.currentRecipeIndex];
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        List<class_3955> recipes = this.getRecipesFor(copyOfPatternSlots, this.field_11863);
        if (recipes.isEmpty()) {
            this.updateRecipe(this.currentRecipeIndex);
            return;
        }
        if (this.recipeIdForSetRecipe[this.currentRecipeIndex] == null) {
            this.recipeIdForSetRecipe[this.currentRecipeIndex] = this.craftingRecipe[this.currentRecipeIndex] == null || this.craftingRecipe[this.currentRecipeIndex].method_8114() == null ? recipes.get(0).method_8114() : this.craftingRecipe[this.currentRecipeIndex].method_8114();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).method_8114(), this.recipeIdForSetRecipe[this.currentRecipeIndex])) continue;
            this.recipeIdForSetRecipe[this.currentRecipeIndex] = recipes.get((i + 1) % recipes.size()).method_8114();
            break;
        }
        this.updateRecipe(this.currentRecipeIndex);
    }

    public void setRecipeIdForSetRecipe(class_2960 recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe[this.currentRecipeIndex] = recipeIdForSetRecipe;
        this.updateRecipe(this.currentRecipeIndex);
    }

    private void updateRecipe(int index) {
        if (this.field_11863 == null) {
            return;
        }
        class_3955 oldRecipe = null;
        class_1799 oldResult = null;
        if (this.hasRecipeLoaded[index] && this.craftingRecipe[index] != null && this.oldCopyOfRecipe[index] != null) {
            oldRecipe = this.craftingRecipe[index];
            oldResult = this.craftingRecipe[index] instanceof class_1852 ? this.craftingRecipe[index].method_8116((class_1263)this.oldCopyOfRecipe[index], this.field_11863.method_30349()) : this.craftingRecipe[index].method_8110(this.field_11863.method_30349());
        }
        this.hasRecipeLoaded[index] = true;
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        Optional<Pair<class_2960, class_3955>> recipe = this.getRecipeFor(copyOfPatternSlots, this.field_11863, this.recipeIdForSetRecipe[index]);
        if (recipe.isPresent()) {
            this.craftingRecipe[index] = (class_3955)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe[index] != null && !Objects.equals(this.craftingRecipe[index].method_8114(), this.recipeIdForSetRecipe[index])) {
                this.recipeIdForSetRecipe[index] = this.craftingRecipe[index].method_8114();
                this.resetProgress(index);
            }
            class_1799 resultItemStack = this.craftingRecipe[index] instanceof class_1852 ? this.craftingRecipe[index].method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : this.craftingRecipe[index].method_8110(this.field_11863.method_30349());
            this.patternResultSlots[index].method_5447(0, resultItemStack);
            if (!(oldRecipe == null || oldResult == null || this.oldCopyOfRecipe[index] == null || this.craftingRecipe[index] == oldRecipe && class_1799.method_7973((class_1799)resultItemStack, (class_1799)oldResult))) {
                this.resetProgress(index);
            }
            this.oldCopyOfRecipe[index] = new class_1715(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
                this.oldCopyOfRecipe[index].method_5447(i, copyOfPatternSlots.method_5438(i).method_7972());
            }
        } else {
            this.recipeIdForSetRecipe[index] = null;
            this.craftingRecipe[index] = null;
            this.patternResultSlots[index].method_5447(0, class_1799.field_8037);
            this.oldCopyOfRecipe[index] = null;
            this.resetProgress(index);
        }
    }

    private void extractItems(int index) {
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        ArrayList<class_1799> patternItemStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            if (patternSlotsForRecipe.method_5438(i).method_7960()) continue;
            patternItemStacks.add(patternSlotsForRecipe.method_5438(i));
        }
        List<class_1799> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (class_1799 itemStack : itemStacksExtract) {
            for (int i = 0; i < this.itemHandler.method_5439(); ++i) {
                class_1799 ret;
                class_1799 testItemStack = this.itemHandler.method_5438(i);
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (ret = this.itemHandler.method_5434(i, itemStack.method_7947())).method_7960()) continue;
                int amount = ret.method_7947();
                if (amount == itemStack.method_7947()) continue block1;
                itemStack.method_7934(amount);
            }
        }
    }

    private void craftItem(int index, class_1715 copyOfPatternSlots) {
        if (this.craftingRecipe[index] == null) {
            this.resetProgress(index);
            return;
        }
        ArrayList<class_1799> outputItemStacks = new ArrayList<class_1799>(10);
        class_1799 resultItemStack = this.craftingRecipe[index] instanceof class_1852 ? this.craftingRecipe[index].method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : this.craftingRecipe[index].method_8110(this.field_11863.method_30349());
        outputItemStacks.add(resultItemStack);
        for (class_1799 remainingItem : this.craftingRecipe[index].method_8111((class_1263)copyOfPatternSlots)) {
            if (remainingItem.method_7960()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<class_1799> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        int outputSlotCount = this.allowOutputOverflow ? this.itemHandler.method_5439() : 5;
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(outputSlotCount);
        block1: for (class_1799 itemStack : itemStacksInsert) {
            for (int i = 0; i < outputSlotCount; ++i) {
                int amount;
                class_1799 testItemStack = this.itemHandler.method_5438(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.method_7960()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947())) <= 0) continue;
                this.itemHandler.method_5447(i, this.itemHandler.method_5438(i).method_46651(testItemStack.method_7947() + amount));
                itemStack.method_7939(itemStack.method_7947() - amount);
                if (itemStack.method_7960()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.method_5447(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT[index]) {
            this.updateRecipe(index);
        }
        this.resetProgress(index);
    }

    private boolean canExtractItemsFromInput(int index) {
        if (this.craftingRecipe[index] == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        ArrayList<class_1799> patternItemStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            if (patternSlotsForRecipe.method_5438(i).method_7960()) continue;
            patternItemStacks.add(patternSlotsForRecipe.method_5438(i));
        }
        List<class_1799> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(27);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                class_1799 itemStack = itemStacks.get(i);
                for (int j = 0; j < this.itemHandler.method_5439(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    class_1799 testItemStack = this.itemHandler.method_5438(j);
                    if (testItemStack.method_7960()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                    int amount = Math.min(itemStack.method_7947(), testItemStack.method_7947());
                    checkedIndices.add(j);
                    if (amount != itemStack.method_7947()) {
                        itemStack.method_7934(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertItemsIntoOutputSlots(int index) {
        class_1799 resultItemStack;
        if (this.craftingRecipe[index] == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        ArrayList<class_1799> outputItemStacks = new ArrayList<class_1799>(10);
        class_1799 class_17992 = resultItemStack = this.craftingRecipe[index] instanceof class_1852 ? this.craftingRecipe[index].method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : this.craftingRecipe[index].method_8110(this.field_11863.method_30349());
        if (!resultItemStack.method_7960()) {
            outputItemStacks.add(resultItemStack);
        }
        for (class_1799 remainingItem : this.craftingRecipe[index].method_8111((class_1263)copyOfPatternSlots)) {
            if (remainingItem.method_7960()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<class_1799> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        int outputSlotCount = this.allowOutputOverflow ? this.itemHandler.method_5439() : 5;
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(outputSlotCount);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(outputSlotCount);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            class_1799 itemStack = itemStacks.get(i);
            for (int j = 0; j < outputSlotCount; ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                class_1799 testItemStack = this.itemHandler.method_5438(j);
                if (testItemStack.method_7960()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                int amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947());
                if (amount + testItemStack.method_7947() == testItemStack.method_7914()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.method_7947()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack.method_7934(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int emptyIndex = (Integer)emptyIndices.remove(0);
            if (itemStack.method_7947() == itemStack.method_7914()) {
                checkedIndices.add(emptyIndex);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(class_1799 itemStack) {
        for (int i = 0; i < 3; ++i) {
            class_1799 resultItemStack;
            if (this.craftingRecipe[i] == null) continue;
            class_1277 patternSlotsForRecipe = this.ignoreNBT[i] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[i]) : this.patternSlots[i];
            class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
            for (int j = 0; j < patternSlotsForRecipe.method_5439(); ++j) {
                copyOfPatternSlots.method_5447(j, patternSlotsForRecipe.method_5438(j));
            }
            class_1799 class_17992 = resultItemStack = this.craftingRecipe[i] instanceof class_1852 ? this.craftingRecipe[i].method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : this.craftingRecipe[i].method_8110(this.field_11863.method_30349());
            if (class_1799.method_7984((class_1799)itemStack, (class_1799)resultItemStack) && class_1799.method_31577((class_1799)itemStack, (class_1799)resultItemStack)) {
                return true;
            }
            for (class_1799 remainingItem : this.craftingRecipe[i].method_8111((class_1263)copyOfPatternSlots)) {
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)remainingItem) || !class_1799.method_31577((class_1799)itemStack, (class_1799)remainingItem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInput(class_1799 itemStack) {
        for (int i = 0; i < 3; ++i) {
            if (this.craftingRecipe[i] == null) continue;
            for (int j = 0; j < this.patternSlots[i].method_5439(); ++j) {
                if (!(this.ignoreNBT[i] ? class_1799.method_7984((class_1799)itemStack, (class_1799)this.patternSlots[i].method_5438(j)) : class_1799.method_7984((class_1799)itemStack, (class_1799)this.patternSlots[i].method_5438(j)) && class_1799.method_31577((class_1799)itemStack, (class_1799)this.patternSlots[i].method_5438(j)))) continue;
                return true;
            }
        }
        return false;
    }

    private class_1277 replaceCraftingPatternWithCurrentNBTItems(class_1277 container) {
        class_1277 copyOfContainer = new class_1277(container.method_5439());
        for (int i = 0; i < container.method_5439(); ++i) {
            copyOfContainer.method_5447(i, container.method_5438(i).method_7972());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.method_5439(); ++i) {
            int usedCount;
            class_1799 testItemStack;
            int j;
            class_1799 itemStack = copyOfContainer.method_5438(i);
            if (itemStack.method_7960()) continue;
            for (j = 0; j < this.itemHandler.method_5439(); ++j) {
                testItemStack = this.itemHandler.method_5438(j).method_7972();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.method_7939(testItemStack.method_7947() - usedCount);
                if (testItemStack.method_7947() <= 0 || !class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.itemHandler.method_5439(); ++j) {
                testItemStack = this.itemHandler.method_5438(j).method_7972();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.method_7939(testItemStack.method_7947() - usedCount);
                if (testItemStack.method_7947() <= 0 || !class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.method_5447(i, testItemStack.method_46651(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<class_3955> getRecipesFor(class_1715 patternSlots, class_1937 level) {
        return level.method_8433().method_30027(class_3956.field_17545).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.method_8114())).filter(recipe -> recipe.method_8115((class_1263)patternSlots, level)).sorted(Comparator.comparing(recipe -> recipe.method_8110(level.method_30349()).method_7922())).toList();
    }

    private Optional<Pair<class_2960, class_3955>> getRecipeFor(class_1715 patternSlots, class_1937 level, class_2960 recipeId) {
        List<class_3955> recipes = this.getRecipesFor(patternSlots, level);
        Optional<class_3955> recipe = recipes.stream().filter(r -> r.method_8114().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.method_8114(), (Object)r));
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i);
        }
        super.updateUpgradeModules();
    }

    public int getCurrentRecipeIndex() {
        return this.currentRecipeIndex;
    }

    public void setCurrentRecipeIndex(int currentRecipeIndex) {
        if (currentRecipeIndex < 0 || currentRecipeIndex >= 3) {
            currentRecipeIndex = 0;
        }
        this.currentRecipeIndex = currentRecipeIndex;
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT[this.currentRecipeIndex] = ignoreNBT;
        this.updateRecipe(this.currentRecipeIndex);
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setAllowOutputOverflow(boolean allowOutputOverflow) {
        this.allowOutputOverflow = allowOutputOverflow;
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
                break;
            }
            case 1: {
                this.setSecondaryExtractMode(checked);
                break;
            }
            case 2: {
                this.setAllowOutputOverflow(checked);
            }
        }
    }
}

