/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.EnergizerRecipe;
import me.jddev0.ep.screen.EnergizerMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergizerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    public static final double ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ENERGIZER_ENERGY_CONSUMPTION_MULTIPLIER.getValue();
    final InputOutputItemHandler itemHandlerSided;
    private int progress;
    private int maxProgress;
    private long energyConsumptionLeft;
    private boolean hasEnoughEnergy;
    private int timeoutOffState;

    public EnergizerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.ENERGIZER_ENTITY, blockPos, blockState, "energizer", ModConfigs.COMMON_ENERGIZER_CAPACITY.getValue(), ModConfigs.COMMON_ENERGIZER_TRANSFER_RATE.getValue(), 2, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
        this.maxProgress = ModConfigs.COMMON_ENERGIZER_RECIPE_DURATION.getValue();
        this.energyConsumptionLeft = -1L;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * EnergizerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                EnergizerBlockEntity.this.method_5431();
                EnergizerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * EnergizerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0 -> {
                        if (EnergizerBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(EnergizerBlockEntity.this.field_11863, EnergizerRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(EnergizerBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        EnergizerBlockEntity.this.resetProgress(EnergizerBlockEntity.this.field_11867, EnergizerBlockEntity.this.field_11863.method_8320(EnergizerBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                EnergizerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> EnergizerBlockEntity.hasRecipe(this) ? this.getEnergyConsumptionPerTick() : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new EnergizerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.progress = nbt.method_10550("recipe.progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, EnergizerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0 && level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && ((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            return;
        }
        if (EnergizerBlockEntity.hasRecipe(blockEntity)) {
            long energyConsumptionPerTick;
            Optional recipe = level.method_8433().method_8132((class_3956)EnergizerRecipe.Type.INSTANCE, (class_1263)blockEntity.itemHandler, level);
            if (recipe.isEmpty()) {
                return;
            }
            long energyConsumption = ((EnergizerRecipe)recipe.get()).getEnergyConsumption();
            energyConsumption = (long)((double)energyConsumption * ENERGY_CONSUMPTION_MULTIPLIER);
            if (blockEntity.progress == 0) {
                blockEntity.energyConsumptionLeft = energyConsumption;
            }
            if ((energyConsumptionPerTick = blockEntity.getEnergyConsumptionPerTick()) <= ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.timeoutOffState = 0;
                if (level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && !((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    EnergizerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    EnergizerBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                EnergizerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                EnergizerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            EnergizerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    protected final long getEnergyConsumptionPerTick() {
        if (this.field_11863 == null) {
            return -1L;
        }
        Optional recipe = this.field_11863.method_8433().method_8132((class_3956)EnergizerRecipe.Type.INSTANCE, (class_1263)this.itemHandler, this.field_11863);
        if (recipe.isEmpty()) {
            return -1L;
        }
        long energyConsumption = ((EnergizerRecipe)recipe.get()).getEnergyConsumption();
        energyConsumption = (long)((double)energyConsumption * ENERGY_CONSUMPTION_MULTIPLIER);
        long energyConsumptionPerTick = (long)Math.ceil((double)energyConsumption / (double)this.maxProgress);
        if (this.progress == this.maxProgress - 1) {
            energyConsumptionPerTick = this.energyConsumptionLeft;
        }
        return energyConsumptionPerTick;
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = false;
    }

    private static void craftItem(class_2338 blockPos, class_2680 state, EnergizerBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional recipe = level.method_8433().method_8132((class_3956)EnergizerRecipe.Type.INSTANCE, (class_1263)blockEntity.itemHandler, level);
        if (!EnergizerBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.method_5434(0, 1);
        blockEntity.itemHandler.method_5447(1, ((EnergizerRecipe)recipe.get()).method_8110(level.method_30349()).method_46651(blockEntity.itemHandler.method_5438(1).method_7947() + ((EnergizerRecipe)recipe.get()).method_8110(level.method_30349()).method_7947()));
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(EnergizerBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional recipe = level.method_8433().method_8132((class_3956)EnergizerRecipe.Type.INSTANCE, (class_1263)blockEntity.itemHandler, level);
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((class_1263)blockEntity.itemHandler, 1, ((EnergizerRecipe)recipe.get()).method_8110(level.method_30349()));
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress(this.method_11016(), this.method_11010());
        super.updateUpgradeModules();
    }
}

