/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.SelectableRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EPFluids;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.screen.FiltrationPlantMenu;
import me.jddev0.ep.util.FluidUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FiltrationPlantBlockEntity
extends SelectableRecipeFluidMachineBlockEntity<CombinedStorage<FluidVariant, SimpleFluidStorage>, FiltrationPlantRecipe> {
    public static final long TANK_CAPACITY = FluidUtils.convertMilliBucketsToDroplets(1000L * ModConfigs.COMMON_FILTRATION_PLANT_TANK_CAPACITY.getValue());
    public static final long DIRTY_WATER_CONSUMPTION_PER_RECIPE = FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_FILTRATION_PLANT_DIRTY_WATER_USAGE_PER_RECIPE.getValue());
    final InputOutputItemHandler itemHandlerSided;

    public FiltrationPlantBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.FILTRATION_PLANT_ENTITY, blockPos, blockState, "filtration_plant", FiltrationPlantMenu::new, 4, EPRecipes.FILTRATION_PLANT_TYPE, EPRecipes.FILTRATION_PLANT_SERIALIZER, ModConfigs.COMMON_FILTRATION_PLANT_RECIPE_DURATION.getValue(), ModConfigs.COMMON_FILTRATION_PLANT_CAPACITY.getValue(), (long)ModConfigs.COMMON_FILTRATION_PLANT_TRANSFER_RATE.getValue(), ModConfigs.COMMON_FILTRATION_PLANT_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 2 || i == 3);
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1 -> stack.method_31574(EPItems.CHARCOAL_FILTER);
                    case 2, 3 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5431() {
                super.method_5431();
                FiltrationPlantBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected CombinedStorage<FluidVariant, SimpleFluidStorage> initFluidStorage() {
        return new CombinedStorage(List.of(new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FiltrationPlantBlockEntity.this.method_5431();
                FiltrationPlantBlockEntity.this.syncFluidToPlayers(32);
            }

            private boolean isFluidValid(FluidVariant variant) {
                return variant.isOf((Object)EPFluids.DIRTY_WATER);
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        }, new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FiltrationPlantBlockEntity.this.method_5431();
                FiltrationPlantBlockEntity.this.syncFluidToPlayers(32);
            }

            private boolean isFluidValid(FluidVariant variant) {
                return variant.isOf((Object)class_3612.field_15910);
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        }));
    }

    @Override
    protected void craftItem(FiltrationPlantRecipe recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            ((CombinedStorage)this.fluidStorage).extract((Object)FluidVariant.of((class_3611)EPFluids.DIRTY_WATER), DIRTY_WATER_CONSUMPTION_PER_RECIPE, (TransactionContext)transaction);
            ((CombinedStorage)this.fluidStorage).insert((Object)FluidVariant.of((class_3611)class_3612.field_15910), DIRTY_WATER_CONSUMPTION_PER_RECIPE, (TransactionContext)transaction);
            transaction.commit();
        }
        for (int i = 0; i < 2; ++i) {
            class_1799 charcoalFilter = this.itemHandler.method_5438(i).method_7972();
            if (charcoalFilter.method_7960() && !charcoalFilter.method_31574(EPItems.CHARCOAL_FILTER)) continue;
            if (charcoalFilter.method_7970(1, this.field_11863.field_9229, null)) {
                this.itemHandler.method_5447(i, class_1799.field_8037);
                continue;
            }
            this.itemHandler.method_5447(i, charcoalFilter);
        }
        class_1799[] outputs = recipe.generateOutputs(this.field_11863.field_9229);
        if (!outputs[0].method_7960()) {
            this.itemHandler.method_5447(2, outputs[0].method_46651(this.itemHandler.method_5438(2).method_7947() + outputs[0].method_7947()));
        }
        if (!outputs[1].method_7960()) {
            this.itemHandler.method_5447(3, outputs[1].method_46651(this.itemHandler.method_5438(3).method_7947() + outputs[1].method_7947()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(class_1277 inventory, FiltrationPlantRecipe recipe) {
        class_1799[] maxOutputs = recipe.getMaxOutputCounts();
        return !(this.field_11863 == null || ((SimpleFluidStorage)((Object)((CombinedStorage)this.fluidStorage).parts.get(0))).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || ((SimpleFluidStorage)((Object)((CombinedStorage)this.fluidStorage).parts.get(1))).getCapacity() - ((SimpleFluidStorage)((Object)((CombinedStorage)this.fluidStorage).parts.get(1))).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || !this.itemHandler.method_5438(0).method_31574(EPItems.CHARCOAL_FILTER) || !this.itemHandler.method_5438(1).method_31574(EPItems.CHARCOAL_FILTER) || !maxOutputs[0].method_7960() && !InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 2, maxOutputs[0]) || !maxOutputs[1].method_7960() && !InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 3, maxOutputs[1]));
    }
}

