/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.entity.base.InventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.ItemStackPacketUpdate;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.ItemStackSyncS2CPacket;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class ItemConveyorBeltBlockEntity
extends InventoryStorageBlockEntity<class_1277>
implements ItemStackPacketUpdate {
    private final int ticksPerStep;
    final InputOutputItemHandler itemHandlerFrontSided;
    final InputOutputItemHandler itemHandlerOthersSided;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltBlockEntity(class_2338 blockPos, class_2680 blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltBlockEntityFromTier(), blockPos, blockState, 4);
        this.itemHandlerFrontSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, i -> i == 3);
        this.itemHandlerOthersSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 1, i -> i == 3);
        this.tier = tier;
        this.ticksPerStep = switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, @NotNull class_1799 stack) {
                return switch (slot) {
                    case 0, 1 -> true;
                    case 2, 3 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5431() {
                super.method_5431();
                ItemConveyorBeltBlockEntity.this.method_5431();
                for (int i = 0; i < this.method_5439(); ++i) {
                    if (ItemConveyorBeltBlockEntity.this.field_11863 == null || ItemConveyorBeltBlockEntity.this.field_11863.method_8608()) continue;
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(ItemConveyorBeltBlockEntity.this.method_11016(), (class_3218)ItemConveyorBeltBlockEntity.this.field_11863, 64.0, new ItemStackSyncS2CPacket(i, this.method_5438(i), ItemConveyorBeltBlockEntity.this.method_11016()));
                }
            }
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    public int getRedstoneOutput() {
        return class_1703.method_7618((class_1263)this.itemHandler);
    }

    static Storage<ItemVariant> getInventoryStorageForDirection(ItemConveyorBeltBlockEntity entity, class_2350 side) {
        if (side == null) {
            return null;
        }
        class_2350 facing = ((EPBlockStateProperties.ConveyorBeltDirection)((Object)entity.method_11010().method_11654(ItemConveyorBeltBlock.FACING))).getDirection();
        if (side.method_10153() == facing) {
            return entity.itemHandlerFrontSided.apply(side);
        }
        return entity.itemHandlerOthersSided.apply(side);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (level.method_8510() % 100L == 0L) {
            for (int i = 0; i < blockEntity.itemHandler.method_5439(); ++i) {
                if (level.method_8608()) continue;
                ModMessages.sendServerPacketToPlayersWithinXBlocks(blockPos, (class_3218)level, 64.0, new ItemStackSyncS2CPacket(i, blockEntity.getStack(i), blockPos));
            }
        }
        if (level.method_8510() % (long)blockEntity.ticksPerStep == 0L) {
            int slotCount = blockEntity.itemHandler.method_5439();
            if (!blockEntity.itemHandler.method_5438(slotCount - 1).method_7960()) {
                ItemConveyorBeltBlockEntity.insertItemStackIntoBlockEntity(level, blockPos, state, blockEntity, blockEntity.itemHandler.method_5438(slotCount - 1).method_7972());
            }
            for (int i = slotCount - 2; i >= 0; --i) {
                class_1799 toItemStack;
                class_1799 fromItemStack = blockEntity.itemHandler.method_5438(i);
                if (fromItemStack.method_7960() || !(toItemStack = blockEntity.itemHandler.method_5438(i + 1)).method_7960()) continue;
                blockEntity.itemHandler.method_5447(i, class_1799.field_8037);
                blockEntity.itemHandler.method_5447(i + 1, fromItemStack);
            }
        }
    }

    private static void insertItemStackIntoBlockEntity(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltBlockEntity blockEntity, class_1799 itemStackToInsert) {
        class_2586 testBlockEntity;
        Storage itemStackStorage;
        EPBlockStateProperties.ConveyorBeltDirection facing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)blockEntity.method_11010().method_11654(ItemConveyorBeltBlock.FACING));
        class_2350 facingDirection = facing.getDirection();
        class_2338 testPos = blockPos.method_10093(facingDirection);
        if (facing.isAscending()) {
            testPos = testPos.method_10093(class_2350.field_11036);
        }
        Storage storage = itemStackStorage = (testBlockEntity = level.method_8321(testPos)) == null ? null : (Storage)ItemStorage.SIDED.find(level, testPos, (Object)facingDirection.method_10153());
        if (itemStackStorage == null) {
            class_2680 testBlockState = level.method_8320(testPos = testPos.method_10093(class_2350.field_11033));
            if (!(testBlockState.method_26204() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection testFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)testBlockState.method_11654(ItemConveyorBeltBlock.FACING));
            if (!testFacing.isDescending() || testFacing.getDirection() != facingDirection) {
                return;
            }
            testBlockEntity = level.method_8321(testPos);
            if (!(testBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            itemStackStorage = (Storage)ItemStorage.SIDED.find(level, testPos, (Object)facingDirection.method_10153());
            if (itemStackStorage == null) {
                return;
            }
        }
        if (!itemStackStorage.supportsInsertion()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long amount = itemStackStorage.insert((Object)ItemVariant.of((class_1799)itemStackToInsert), 1L, (TransactionContext)transaction);
            if (amount > 0L) {
                blockEntity.itemHandler.method_5447(blockEntity.itemHandler.method_5439() - 1, class_1799.field_8037);
            }
            transaction.commit();
        }
    }

    public int getSlotCount() {
        return this.itemHandler.method_5439();
    }

    public class_1799 getStack(int slot) {
        return this.itemHandler.method_5438(slot);
    }

    @Override
    public void setItemStack(int slot, class_1799 itemStack) {
        this.itemHandler.method_5447(slot, itemStack);
    }
}

