/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSorterBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import me.jddev0.ep.screen.ItemConveyorBeltSorterMenu;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltSorterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
CheckboxUpdate {
    private final int ticksPerItem;
    private static final int PATTERN_SLOTS_PER_OUTPUT = 5;
    private final class_1277 patternSlots = new class_1277(15){

        public int method_5444() {
            return 1;
        }
    };
    private final class_1265 updatePatternListener = container -> this.method_5431();
    protected final class_3913 data;
    private boolean[] outputBeltConnected = new boolean[]{false, false, false};
    private boolean[] whitelist = new boolean[]{true, true, true};
    private boolean[] ignoreNBT = new boolean[]{false, false, false};
    private boolean loaded;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltSorterBlockEntity(class_2338 blockPos, class_2680 blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltSorterBlockEntityFromTier(), blockPos, blockState);
        this.tier = tier;
        this.patternSlots.method_5489(this.updatePatternListener);
        this.data = new CombinedContainerData(new BooleanValueContainerData(() -> this.outputBeltConnected[0], value -> {
            this.outputBeltConnected[0] = value;
        }), new BooleanValueContainerData(() -> this.outputBeltConnected[1], value -> {
            this.outputBeltConnected[1] = value;
        }), new BooleanValueContainerData(() -> this.outputBeltConnected[2], value -> {
            this.outputBeltConnected[2] = value;
        }), new BooleanValueContainerData(() -> this.whitelist[0], value -> {
            this.whitelist[0] = value;
        }), new BooleanValueContainerData(() -> this.whitelist[1], value -> {
            this.whitelist[1] = value;
        }), new BooleanValueContainerData(() -> this.whitelist[2], value -> {
            this.whitelist[2] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[0], value -> {
            this.ignoreNBT[0] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[1], value -> {
            this.ignoreNBT[1] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[2], value -> {
            this.ignoreNBT[2] = value;
        }));
        this.ticksPerItem = switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)("container.energizedpower." + (switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case ConveyorBeltTier.BASIC -> "item_conveyor_belt_sorter";
            case ConveyorBeltTier.FAST -> "fast_item_conveyor_belt_sorter";
            case ConveyorBeltTier.EXPRESS -> "express_item_conveyor_belt_sorter";
        })));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new ItemConveyorBeltSorterMenu(id, inventory, this, (class_1263)this.patternSlots, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(@NotNull class_2487 nbt) {
        int i;
        super.method_11007(nbt);
        nbt.method_10566("pattern", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.patternSlots.field_5828));
        for (i = 0; i < 3; ++i) {
            nbt.method_10556("recipe.whitelist." + i, this.whitelist[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbt.method_10556("recipe.ignore_nbt." + i, this.ignoreNBT[i]);
        }
    }

    public void method_11014(@NotNull class_2487 nbt) {
        int i;
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("pattern"), (class_2371)this.patternSlots.field_5828);
        for (i = 0; i < 3; ++i) {
            this.whitelist[i] = nbt.method_10577("recipe.whitelist." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.ignoreNBT[i] = nbt.method_10577("recipe.ignore_nbt." + i);
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltSorterBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.loaded) {
            for (int i = 0; i < 3; ++i) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)ItemConveyorBeltSorterBlock.FACING);
                class_2350 outputBeltDirection = switch (i) {
                    case 0 -> facing.method_10170();
                    case 1 -> facing.method_10153();
                    case 2 -> facing.method_10160();
                    default -> null;
                };
                class_2680 outputBeltState = level.method_8320(blockPos.method_10093(outputBeltDirection));
                blockEntity.setOutputBeltConnected(i, outputBeltState.method_26204() instanceof ItemConveyorBeltBlock);
            }
            blockEntity.loaded = true;
        }
        if (level.method_8510() % (long)blockEntity.ticksPerItem == 0L) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)ItemConveyorBeltSorterBlock.FACING);
            class_2338 inputPos = blockPos.method_10093(facing);
            class_2680 inputBlockState = level.method_8320(inputPos);
            if (!(inputBlockState.method_26204() instanceof ItemConveyorBeltBlock)) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.method_11654(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().method_10153() != facing) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            class_2586 inputBlockEntity = level.method_8321(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            Storage inputBeltItemStackStorage = (Storage)ItemStorage.SIDED.find(level, inputPos, (Object)facing.method_10153());
            if (inputBeltItemStackStorage == null || !inputBeltItemStackStorage.supportsExtraction()) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            class_1799 itemStackToSort = class_1799.field_8037;
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView itemView : inputBeltItemStackStorage) {
                    ItemVariant itemVariant;
                    long amount;
                    if (itemView.isResourceBlank() || (amount = inputBeltItemStackStorage.extract((Object)(itemVariant = (ItemVariant)itemView.getResource()), 1L, (TransactionContext)transaction)) <= 0L) continue;
                    itemStackToSort = itemVariant.toStack(1);
                    break;
                }
            }
            if (itemStackToSort.method_7960()) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            for (int i = 0; i < 3; ++i) {
                if (!ItemConveyorBeltSorterBlockEntity.filterMatches(blockEntity, i, itemStackToSort)) continue;
                Storage<ItemVariant> outputBeltItemStackStorage = ItemConveyorBeltSorterBlockEntity.getOutputBeltItemStackStorage(level, blockPos, state, blockEntity, i);
                if (outputBeltItemStackStorage == null) {
                    ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                    return;
                }
                ItemConveyorBeltSorterBlockEntity.tryInsertItemStackIntoOutputBelt(itemStackToSort, (Storage<ItemVariant>)inputBeltItemStackStorage, outputBeltItemStackStorage);
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, true);
        }
    }

    private static void updatePoweredState(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltSorterBlockEntity blockEntity, boolean powered) {
        if (powered != (Boolean)state.method_11654((class_2769)ItemConveyorBeltSorterBlock.POWERED)) {
            level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)ItemConveyorBeltSorterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            ItemConveyorBeltSorterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private static boolean filterMatches(ItemConveyorBeltSorterBlockEntity blockEntity, int index, class_1799 itemStackToSort) {
        for (int i = 0; i < 5; ++i) {
            class_1799 patternItemStack = blockEntity.patternSlots.method_5438(5 * index + i);
            if (patternItemStack.method_7960() || !(blockEntity.ignoreNBT[index] ? class_1799.method_7984((class_1799)itemStackToSort, (class_1799)patternItemStack) : class_1799.method_31577((class_1799)itemStackToSort, (class_1799)patternItemStack))) continue;
            return blockEntity.whitelist[index];
        }
        return !blockEntity.whitelist[index];
    }

    private static Storage<ItemVariant> getOutputBeltItemStackStorage(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltSorterBlockEntity blockEntity, int index) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)ItemConveyorBeltSorterBlock.FACING);
        switch (index) {
            case 0: {
                class_2350 class_23502 = direction.method_10170();
                break;
            }
            case 1: {
                class_2350 class_23502 = direction.method_10153();
                break;
            }
            case 2: {
                class_2350 class_23502 = direction.method_10160();
                break;
            }
            default: {
                class_2350 class_23502 = direction = null;
            }
        }
        if (direction == null) {
            return null;
        }
        class_2338 outputPos = blockPos.method_10093(direction);
        class_2680 outputBlockState = level.method_8320(outputPos);
        if (!(outputBlockState.method_26204() instanceof ItemConveyorBeltBlock)) {
            return null;
        }
        class_2586 outputBlockEntity = level.method_8321(outputPos);
        if (!(outputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return null;
        }
        Storage itemStackStorage = (Storage)ItemStorage.SIDED.find(level, outputPos, (Object)direction.method_10153());
        if (itemStackStorage == null || !itemStackStorage.supportsInsertion()) {
            return null;
        }
        return itemStackStorage;
    }

    private static boolean tryInsertItemStackIntoOutputBelt(class_1799 itemStackToSort, Storage<ItemVariant> inputBeltItemStackStorage, Storage<ItemVariant> outputBeltItemStackStorage) {
        try (Transaction transaction = Transaction.openOuter();){
            long amount = outputBeltItemStackStorage.insert((Object)ItemVariant.of((class_1799)itemStackToSort), 1L, (TransactionContext)transaction);
            if (amount > 0L) {
                inputBeltItemStackStorage.extract((Object)ItemVariant.of((class_1799)itemStackToSort), 1L, (TransactionContext)transaction);
            }
            transaction.commit();
            if (amount > 0L) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void setOutputBeltConnected(int index, boolean outputBeltConnected) {
        this.outputBeltConnected[index] = outputBeltConnected;
        ItemConveyorBeltSorterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setWhitelist(int index, boolean whitelist) {
        this.whitelist[index] = whitelist;
        ItemConveyorBeltSorterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setIgnoreNBT(int index, boolean ignoreNBT) {
        this.ignoreNBT[index] = ignoreNBT;
        ItemConveyorBeltSorterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: 
            case 1: 
            case 2: {
                this.setWhitelist(checkboxId, checked);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.setIgnoreNBT(checkboxId - 3, checked);
            }
        }
    }
}

