/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncFurnaceRecipeTypeS2CPacket;
import me.jddev0.ep.recipe.FurnaceRecipeTypePacketUpdate;
import me.jddev0.ep.screen.PoweredFurnaceMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredFurnaceBlockEntity
extends WorkerMachineBlockEntity<class_1874>
implements FurnaceRecipeTypePacketUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    final InputOutputItemHandler itemHandlerSided;
    @NotNull
    private class_3956<? extends class_1874> recipeType;

    public PoweredFurnaceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.POWERED_FURNACE_ENTITY, blockPos, blockState, "powered_furnace", 2, 1, ModConfigs.COMMON_POWERED_FURNACE_CAPACITY.getValue(), ModConfigs.COMMON_POWERED_FURNACE_TRANSFER_RATE.getValue(), ModConfigs.COMMON_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.FURNACE_MODE);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
        this.recipeType = class_3956.field_17546;
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PoweredFurnaceBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(PoweredFurnaceBlockEntity.this.field_11863, PoweredFurnaceBlockEntity.this.getRecipeForFurnaceModeUpgrade(), stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(PoweredFurnaceBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        PoweredFurnaceBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                PoweredFurnaceBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1L) : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.method_11016()));
        return new PoweredFurnaceMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void onHasEnoughEnergy() {
        if (this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12548) && !((Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    protected void onHasNotEnoughEnergyWithOffTimeout() {
        if (this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12548) && ((Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    protected Optional<class_1874> getCurrentWorkData() {
        return this.getRecipeFor((class_1263)this.itemHandler, this.field_11863);
    }

    @Override
    protected boolean hasWork() {
        return PoweredFurnaceBlockEntity.hasRecipe(this);
    }

    @Override
    protected void onWorkStarted(class_1874 recipe) {
    }

    @Override
    protected void onWorkCompleted(class_1874 workData) {
        PoweredFurnaceBlockEntity.craftItem(this.method_11016(), this.method_11010(), this);
    }

    @Override
    protected double getWorkDataDependentWorkDuration(class_1874 recipe) {
        return (float)recipe.method_8167() * RECIPE_DURATION_MULTIPLIER / 2.0f;
    }

    private static void craftItem(class_2338 blockPos, class_2680 state, PoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional<? extends class_1874> recipe = blockEntity.getRecipeFor((class_1263)blockEntity.itemHandler, level);
        if (!PoweredFurnaceBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.method_5434(0, 1);
        blockEntity.itemHandler.method_5447(1, recipe.get().method_8110(level.method_30349()).method_46651(blockEntity.itemHandler.method_5438(1).method_7947() + recipe.get().method_8110(level.method_30349()).method_7947()));
        blockEntity.resetProgress();
    }

    private static boolean hasRecipe(PoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional<? extends class_1874> recipe = blockEntity.getRecipeFor((class_1263)blockEntity.itemHandler, level);
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((class_1263)blockEntity.itemHandler, 1, recipe.get().method_8110(level.method_30349()));
    }

    private Optional<? extends class_1874> getRecipeFor(class_1263 container, class_1937 level) {
        return level.method_8433().method_30027(this.getRecipeForFurnaceModeUpgrade()).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.method_8114())).filter(recipe -> recipe.method_8115(container, level)).findFirst();
    }

    public class_3956<? extends class_1874> getRecipeForFurnaceModeUpgrade() {
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return this.recipeType;
        }
        double value = this.upgradeModuleInventory.getUpgradeModuleModifierEffect(3, UpgradeModuleModifier.FURNACE_MODE);
        if (value == 1.0) {
            return class_3956.field_17547;
        }
        if (value == 2.0) {
            return class_3956.field_17548;
        }
        return class_3956.field_17546;
    }

    @Override
    public void setRecipeType(@NotNull class_3956<? extends class_1874> recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    protected void updateUpgradeModules() {
        super.updateUpgradeModules();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, 32.0, new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.method_11016()));
        }
    }
}

