/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ShortValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.WeatherControllerMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherControllerBlockEntity
extends UpgradableEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    private static final int WEATHER_CHANGED_TICKS = ModConfigs.COMMON_WEATHER_CONTROLLER_CONTROL_DURATION.getValue();
    private int selectedWeatherType = -1;

    public WeatherControllerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.WEATHER_CONTROLLER_ENTITY, blockPos, blockState, "weather_controller", ModConfigs.COMMON_WEATHER_CONTROLLER_CAPACITY.getValue(), ModConfigs.COMMON_WEATHER_CONTROLLER_TRANSFER_RATE.getValue(), UpgradeModuleModifier.DURATION);
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ShortValueContainerData(() -> (short)this.selectedWeatherType, value -> {
            this.selectedWeatherType = value.shortValue();
        }), new EnergyValueContainerData(() -> !this.hasInfiniteWeatherChangedDuration() || this.selectedWeatherType == -1 ? -1L : (long)this.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION), value -> {}), new BooleanValueContainerData(this::hasEnoughEnergy, value -> {}));
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            protected void onFinalCommit() {
                WeatherControllerBlockEntity.this.method_5431();
                WeatherControllerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * WeatherControllerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new WeatherControllerMenu(id, this, inventory, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("selected_weather_type", (class_2520)class_2497.method_23247((int)this.selectedWeatherType));
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.selectedWeatherType = nbt.method_10545("selected_weather_type") ? nbt.method_10550("selected_weather_type") : -1;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, WeatherControllerBlockEntity blockEntity) {
        if (level.field_9236 || !(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        if (!blockEntity.hasInfiniteWeatherChangedDuration() || blockEntity.selectedWeatherType == -1) {
            return;
        }
        double energyConsumptionPerTick = blockEntity.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION);
        if ((double)((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() >= energyConsumptionPerTick) {
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract((long)energyConsumptionPerTick, (TransactionContext)transaction);
                transaction.commit();
            }
            if (level.method_8510() % 100L == 0L) {
                int duration = blockEntity.getWeatherChangedDuration();
                switch (blockEntity.selectedWeatherType) {
                    case 0: {
                        serverLevel.method_27910(duration, 0, false, false);
                        break;
                    }
                    case 1: {
                        serverLevel.method_27910(0, duration, true, false);
                        break;
                    }
                    case 2: {
                        serverLevel.method_27910(0, duration, true, true);
                    }
                }
            }
        } else {
            blockEntity.setSelectedWeatherType(-1);
        }
    }

    public void clearEnergy() {
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)this.energyStorage).extract(((EnergizedPowerEnergyStorage)this.energyStorage).getCapacity(), (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public boolean hasEnoughEnergy() {
        if (this.hasInfiniteWeatherChangedDuration()) {
            double energyConsumptionPerTick = this.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION);
            return (double)((EnergizedPowerEnergyStorage)this.energyStorage).getAmount() >= energyConsumptionPerTick;
        }
        return ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount() >= ((EnergizedPowerEnergyStorage)this.energyStorage).getCapacity();
    }

    public boolean hasInfiniteWeatherChangedDuration() {
        return this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.DURATION) == Double.POSITIVE_INFINITY;
    }

    public int getWeatherChangedDuration() {
        if (this.hasInfiniteWeatherChangedDuration()) {
            return 300;
        }
        return (int)Math.max(1.0, (double)WEATHER_CHANGED_TICKS * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.DURATION));
    }

    public int getSelectedWeatherType() {
        return this.selectedWeatherType;
    }

    public void setSelectedWeatherType(int selectedWeatherType) {
        this.selectedWeatherType = selectedWeatherType;
        this.method_5431();
    }

    @Override
    protected void updateUpgradeModules() {
        if (!this.hasInfiniteWeatherChangedDuration()) {
            this.selectedWeatherType = -1;
        }
        super.updateUpgradeModules();
    }
}

