/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class EnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage>
extends class_2586
implements EnergyStoragePacketUpdate {
    protected final E energyStorage;
    public final EnergizedPowerLimitingEnergyStorage limitingEnergyStorage;
    protected final long baseEnergyCapacity;
    protected final long baseEnergyTransferRate;

    public EnergyStorageBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, long baseEnergyCapacity, long baseEnergyTransferRate) {
        super(type, blockPos, blockState);
        this.baseEnergyCapacity = baseEnergyCapacity;
        this.baseEnergyTransferRate = baseEnergyTransferRate;
        this.energyStorage = this.initEnergyStorage();
        this.limitingEnergyStorage = this.initLimitingEnergyStorage();
    }

    protected abstract E initEnergyStorage();

    protected abstract EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage();

    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("energy", this.energyStorage.getAmount());
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.energyStorage.setAmountWithoutUpdate(nbt.method_10537("energy"));
    }

    protected final void syncEnergyToPlayer(class_1657 player) {
        ModMessages.sendServerPacketToPlayer((class_3222)player, new EnergySyncS2CPacket(this.energyStorage.getAmount(), this.energyStorage.getCapacity(), this.method_11016()));
    }

    protected final void syncEnergyToPlayers(int distance) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, distance, new EnergySyncS2CPacket(this.energyStorage.getAmount(), this.energyStorage.getCapacity(), this.method_11016()));
        }
    }

    public long getEnergy() {
        return this.energyStorage.getAmount();
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(long energy) {
        this.energyStorage.setAmountWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(long capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

