/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncCurrentRecipeS2CPacket;
import me.jddev0.ep.recipe.ChangeCurrentRecipeIndexPacketUpdate;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import me.jddev0.ep.recipe.SetCurrentRecipeIdPacketUpdate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableRecipeMachineBlockEntity<R extends class_1860<class_1263>>
extends WorkerMachineBlockEntity<R>
implements ChangeCurrentRecipeIndexPacketUpdate,
CurrentRecipePacketUpdate<R>,
SetCurrentRecipeIdPacketUpdate {
    protected final UpgradableMenuProvider menuProvider;
    protected final class_3956<R> recipeType;
    protected final class_1865<R> recipeSerializer;
    protected class_2960 currentRecipeIdForLoad;
    protected R currentRecipe;

    public SelectableRecipeMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, class_3956<R> recipeType, class_1865<R> recipeSerializer, int baseRecipeDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(this::getEnergyConsumptionFor).orElse(-1L) : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        if (this.currentRecipe != null) {
            nbt.method_10566("recipe.id", (class_2520)class_2519.method_23256((String)this.currentRecipe.method_8114().toString()));
        }
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("recipe.id")) {
            this.currentRecipeIdForLoad = class_2960.method_12829((String)nbt.method_10558("recipe.id"));
        }
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncCurrentRecipeToPlayer(player);
        return this.menuProvider.createMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected final void onTickStart() {
        if (this.currentRecipeIdForLoad != null) {
            List recipes = this.field_11863.method_8433().method_30027(this.recipeType);
            this.currentRecipe = recipes.stream().filter(recipe -> recipe.method_8114().equals((Object)this.currentRecipeIdForLoad)).findFirst().orElse(null);
            this.currentRecipeIdForLoad = null;
        }
    }

    @Override
    protected Optional<R> getCurrentWorkData() {
        return Optional.ofNullable(this.currentRecipe);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(R workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(R recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(R workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(R recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.field_11863 == null || this.currentRecipe == null) {
            return false;
        }
        return this.canCraftRecipe(this.itemHandler, this.currentRecipe);
    }

    @Override
    protected final void onWorkStarted(R workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(R recipe) {
    }

    @Override
    protected final void onWorkCompleted(R workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(R var1);

    protected abstract boolean canCraftRecipe(class_1277 var1, R var2);

    @Override
    public void changeRecipeIndex(boolean downUp) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        List<class_1860> recipes = this.field_11863.method_8433().method_30027(this.recipeType);
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> recipe.method_8110(this.field_11863.method_30349()).method_7922())).toList();
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.method_8114().equals((Object)recipes.get(i).method_8114())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : recipes.get(currentIndex);
        this.resetProgress();
        this.method_5431();
        this.syncCurrentRecipeToPlayers(32);
    }

    @Override
    public void setRecipeId(class_2960 recipeId) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        if (recipeId == null) {
            this.currentRecipe = null;
        } else {
            List recipes = this.field_11863.method_8433().method_30027(this.recipeType);
            Optional<class_1860> recipe = recipes.stream().filter(r -> r.method_8114().equals((Object)recipeId)).findFirst();
            this.currentRecipe = recipe.orElse(null);
        }
        this.resetProgress();
        this.method_5431();
        this.syncCurrentRecipeToPlayers(32);
    }

    protected final void syncCurrentRecipeToPlayer(class_1657 player) {
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncCurrentRecipeS2CPacket<R>(this.method_11016(), this.recipeSerializer, this.currentRecipe));
    }

    protected final void syncCurrentRecipeToPlayers(int distance) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, distance, new SyncCurrentRecipeS2CPacket<R>(this.method_11016(), this.recipeSerializer, this.currentRecipe));
        }
    }

    @Nullable
    public R getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(@Nullable R currentRecipe) {
        this.currentRecipe = currentRecipe;
    }
}

