/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class PlantGrowthChamberRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final OutputItemStackWithPercentages[] outputs;
    private final class_1856 input;
    private final int ticks;

    public PlantGrowthChamberRecipe(class_2960 id, OutputItemStackWithPercentages[] outputs, class_1856 input, int ticks) {
        this.id = id;
        this.outputs = outputs;
        this.input = input;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages[] getOutputs() {
        return this.outputs;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public int getTicks() {
        return this.ticks;
    }

    public class_1799[] getMaxOutputCounts() {
        class_1799[] generatedOutputs = new class_1799[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            OutputItemStackWithPercentages output = this.outputs[i];
            generatedOutputs[i] = output.output().method_46651(output.percentages().length);
        }
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource) {
        class_1799[] generatedOutputs = new class_1799[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = this.outputs[i];
            for (double percentage : output.percentages()) {
                if (!(randomSource.method_43058() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output().method_46651(count);
        }
        return generatedOutputs;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        return this.input.method_8093(container.method_5438(0));
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryManager) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_37434((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)EPBlocks.PLANT_GROWTH_CHAMBER_ITEM);
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements class_1865<PlantGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = EPAPI.id("plant_growth_chamber");

        private Serializer() {
        }

        public PlantGrowthChamberRecipe read(class_2960 recipeID, JsonObject json) {
            class_1856 input = class_1856.method_52177((JsonElement)json.get("ingredient"));
            int ticks = class_3518.method_15260((JsonObject)json, (String)"ticks");
            JsonArray outputsJson = class_3518.method_15261((JsonObject)json, (String)"outputs");
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputsJson.size()];
            for (int i = 0; i < outputsJson.size(); ++i) {
                outputs[i] = OutputItemStackWithPercentages.fromJson(outputsJson.get(i).getAsJsonObject());
            }
            return new PlantGrowthChamberRecipe(recipeID, outputs, input, ticks);
        }

        public PlantGrowthChamberRecipe read(class_2960 recipeID, class_2540 buffer) {
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            int ticks = buffer.readInt();
            int outputCount = buffer.readInt();
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                outputs[i] = OutputItemStackWithPercentages.fromNetwork(buffer);
            }
            return new PlantGrowthChamberRecipe(recipeID, outputs, input, ticks);
        }

        public void write(class_2540 buffer, PlantGrowthChamberRecipe recipe) {
            recipe.input.method_8088(buffer);
            buffer.writeInt(recipe.ticks);
            buffer.writeInt(recipe.outputs.length);
            for (OutputItemStackWithPercentages output : recipe.outputs) {
                output.toNetwork(buffer);
            }
        }
    }

    public static final class Type
    implements class_3956<PlantGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plant_growth_chamber";

        private Type() {
        }
    }
}

