/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import java.util.Locale;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public final class FluidUtils {
    private static final String[] FLUID_PREFIXES = new String[]{"", "k", "M", "G", "T", "P", "E"};

    private FluidUtils() {
    }

    public static String getFluidAmountWithPrefix(long milliBuckets) {
        if (milliBuckets < 1000L) {
            return String.format(Locale.ENGLISH, "%d mB", milliBuckets);
        }
        double milliBucketsWithPrefix = milliBuckets;
        int prefixIndex = 0;
        while ((long)milliBucketsWithPrefix >= 1000L && prefixIndex + 1 < FLUID_PREFIXES.length) {
            milliBucketsWithPrefix /= 1000.0;
            ++prefixIndex;
        }
        return String.format(Locale.ENGLISH, "%.2f%s mB", milliBucketsWithPrefix, FLUID_PREFIXES[prefixIndex]);
    }

    public static long convertDropletsToMilliBuckets(long droplets) {
        if (droplets == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return droplets * 1000L / 81000L;
    }

    public static long convertMilliBucketsToDroplets(long milliBuckets) {
        if (milliBuckets == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return milliBuckets * 81000L / 1000L;
    }

    public static long readFluidAmountInMilliBucketsWithLeftover(String milliBucketsKey, String leftoverKey, class_2487 nbtCompound) {
        long milliBucketsAmount = nbtCompound.method_10537(milliBucketsKey);
        if (milliBucketsAmount == -1L) {
            return -1L;
        }
        long dropletsLeftOverAmount = nbtCompound.method_10545(leftoverKey) ? nbtCompound.method_10537(leftoverKey) : 0L;
        return FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount) + dropletsLeftOverAmount;
    }

    public static void writeFluidAmountInMilliBucketsWithLeftover(long droplets, String milliBucketsKey, String leftoverKey, class_2487 nbtCompound) {
        if (droplets == -1L) {
            nbtCompound.method_10544(milliBucketsKey, -1L);
            return;
        }
        long milliBucketsAmount = FluidUtils.convertDropletsToMilliBuckets(droplets);
        long dropletsLeftOverAmount = droplets - FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount);
        nbtCompound.method_10544(milliBucketsKey, milliBucketsAmount);
        if (dropletsLeftOverAmount > 0L) {
            nbtCompound.method_10544(leftoverKey, dropletsLeftOverAmount);
        }
    }

    public static int getRedstoneSignalFromFluidHandler(Storage<FluidVariant> fluidStorage) {
        double fullnessPercentSum = 0.0;
        boolean isEmptyFlag = true;
        int size = 0;
        for (StorageView fluidView : fluidStorage) {
            if (++size > 100) break;
            if (fluidView.isResourceBlank()) continue;
            fullnessPercentSum += (double)fluidView.getAmount() / (double)fluidView.getCapacity();
            isEmptyFlag = false;
        }
        return Math.min(class_3532.method_15357((double)(fullnessPercentSum / (double)size * 14.0)) + (isEmptyFlag ? 0 : 1), 15);
    }
}

