/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import java.util.List;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.TransformerBlockEntity;
import me.jddev0.ep.machine.tier.TransformerTier;
import me.jddev0.ep.machine.tier.TransformerType;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5894;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableTransformerBlock
extends class_2237
implements class_3737,
WrenchConfigurable {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<EPBlockStateProperties.TransformerConnection> UP = EPBlockStateProperties.TRANSFORMER_CONNECTION_UP;
    public static final class_2754<EPBlockStateProperties.TransformerConnection> DOWN = EPBlockStateProperties.TRANSFORMER_CONNECTION_DOWN;
    public static final class_2754<EPBlockStateProperties.TransformerConnection> NORTH = EPBlockStateProperties.TRANSFORMER_CONNECTION_NORTH;
    public static final class_2754<EPBlockStateProperties.TransformerConnection> SOUTH = EPBlockStateProperties.TRANSFORMER_CONNECTION_SOUTH;
    public static final class_2754<EPBlockStateProperties.TransformerConnection> EAST = EPBlockStateProperties.TRANSFORMER_CONNECTION_EAST;
    public static final class_2754<EPBlockStateProperties.TransformerConnection> WEST = EPBlockStateProperties.TRANSFORMER_CONNECTION_WEST;
    private final TransformerTier tier;

    @NotNull
    public static class_2754<EPBlockStateProperties.TransformerConnection> getTransformerConnectionPropertyFromDirection(@NotNull class_2350 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> UP;
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11039 -> WEST;
        };
    }

    public ConfigurableTransformerBlock(TransformerTier tier, class_4970.class_2251 properties) {
        super(properties);
        this.tier = tier;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(UP, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(DOWN, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(NORTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(SOUTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(EAST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(WEST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED)));
    }

    public TransformerTier getTier() {
        return this.tier;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 state) {
        return new TransformerBlockEntity(blockPos, state, this.tier, TransformerType.CONFIGURABLE);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 handItem, class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof TransformerBlockEntity) || ((TransformerBlockEntity)blockEntity).getTier() != this.tier || ((TransformerBlockEntity)blockEntity).getTransformerType() != TransformerType.CONFIGURABLE) {
            throw new IllegalStateException("Container is invalid");
        }
        player.method_17355((class_3908)((TransformerBlockEntity)blockEntity));
        return class_1269.field_5812;
    }

    @Override
    @NotNull
    public class_1269 onUseWrench(class_1838 useOnContext, class_2350 selectedFace, boolean nextPreviousValue) {
        class_1937 level = useOnContext.method_8045();
        class_2338 blockPos = useOnContext.method_8037();
        if (level.method_8608() || !(level.method_8321(blockPos) instanceof TransformerBlockEntity)) {
            return class_1269.field_5812;
        }
        class_2680 state = level.method_8320(blockPos);
        class_1657 player = useOnContext.method_8036();
        class_2754<EPBlockStateProperties.TransformerConnection> transformerConnectionProperty = ConfigurableTransformerBlock.getTransformerConnectionPropertyFromDirection(selectedFace);
        int diff = nextPreviousValue ? -1 : 1;
        EPBlockStateProperties.TransformerConnection transformerConnection = (EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(transformerConnectionProperty));
        transformerConnection = EPBlockStateProperties.TransformerConnection.values()[(transformerConnection.ordinal() + diff + EPBlockStateProperties.TransformerConnection.values().length) % EPBlockStateProperties.TransformerConnection.values().length];
        level.method_8652(blockPos, (class_2680)state.method_11657(transformerConnectionProperty, (Comparable)((Object)transformerConnection)), 3);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.configurable_transformer.wrench_configuration.face_changed", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.energizedpower.direction." + selectedFace.method_15434())).method_27692(class_124.field_1068), class_2561.method_43471((String)transformerConnection.getTranslationKey()).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067})}).method_27692(class_124.field_1060)));
        }
        return class_1269.field_5812;
    }

    public void method_9612(class_2680 selfState, class_1937 level, class_2338 selfPos, class_2248 fromBlock, class_2338 fromPos, boolean isMoving) {
        super.method_9612(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.method_8608()) {
            return;
        }
        boolean isPowered = level.method_49803(selfPos);
        if (isPowered != (Boolean)selfState.method_11654((class_2769)POWERED)) {
            level.method_8652(selfPos, (class_2680)selfState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(context.method_8045().method_49803(context.method_8037())))).method_11657(UP, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(DOWN, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(NORTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(SOUTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(EAST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).method_11657(WEST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(WEST)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(EAST)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(NORTH)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(SOUTH)))));
            }
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(SOUTH)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(NORTH)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(WEST)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(EAST)))));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(EAST)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(WEST)))))).method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(SOUTH)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(NORTH)))));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(SOUTH)))))).method_11657(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(NORTH)))));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(WEST)))))).method_11657(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(EAST)))));
            }
        }
        return state;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{POWERED}).method_11667(new class_2769[]{UP}).method_11667(new class_2769[]{DOWN}).method_11667(new class_2769[]{NORTH}).method_11667(new class_2769[]{SOUTH}).method_11667(new class_2769[]{EAST}).method_11667(new class_2769[]{WEST});
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return ConfigurableTransformerBlock.method_31618(type, this.tier.getEntityTypeFromTierAndType(TransformerType.CONFIGURABLE), TransformerBlockEntity::tick);
    }

    public static class Item
    extends class_1747 {
        private final TransformerTier tier;

        public Item(class_2248 block, class_1792.class_1793 props, TransformerTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public TransformerTier getTier() {
            return this.tier;
        }

        public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.wrench_configurable").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxEnergyTransferFromTier())}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.transformer.txt.shift.1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.transformer.txt.shift.2").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.transformer.txt.shift.3").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
            }
        }
    }
}

