/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.ChargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.screen.ChargerMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class ChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    public static final double CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    final InputOutputItemHandler itemHandlerSided;
    private long energyConsumptionLeft;

    public ChargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.CHARGER_ENTITY, blockPos, blockState, "charger", ModConfigs.COMMON_CHARGER_CAPACITY.getValue(), ModConfigs.COMMON_CHARGER_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 itemStack = this.itemHandler.method_5438(i.intValue());
            if (this.field_11863 != null && RecipeUtils.isResultOfAny(this.field_11863, ChargerRecipe.Type.INSTANCE, itemStack)) {
                return true;
            }
            if (this.field_11863 == null || RecipeUtils.isIngredientOfAny(this.field_11863, ChargerRecipe.Type.INSTANCE, itemStack)) {
                return false;
            }
            if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)) {
                return true;
            }
            EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get((int)i))));
            if (limitingEnergyStorage == null) {
                return true;
            }
            if (!limitingEnergyStorage.supportsInsertion()) {
                return true;
            }
            return limitingEnergyStorage.getAmount() == limitingEnergyStorage.getCapacity();
        });
        this.energyConsumptionLeft = -1L;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * ChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                ChargerBlockEntity.this.method_5431();
                ChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * ChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (ChargerBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(ChargerBlockEntity.this.field_11863, ChargerRecipe.Type.INSTANCE, stack)) {
                    return true;
                }
                if (slot == 0) {
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                        return false;
                    }
                    EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                    if (limitingEnergyStorage == null) {
                        return false;
                    }
                    return limitingEnergyStorage.supportsInsertion();
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || EnergyStorageUtil.isEnergyStorage((class_1799)stack) && EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)))) {
                        ChargerBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                ChargerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(() -> this.hasRecipe() ? this.getEnergyConsumptionPerTick() : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new ChargerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ChargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)ChargerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            class_1799 stack = blockEntity.itemHandler.method_5438(0);
            long energyConsumptionPerTick = 0L;
            Optional recipe = level.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_1263)blockEntity.itemHandler, level);
            if (recipe.isPresent()) {
                if (blockEntity.energyConsumptionLeft == -1L) {
                    blockEntity.energyConsumptionLeft = (long)((double)((ChargerRecipe)recipe.get()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                }
                if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() == 0L) {
                    ChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft, Math.min(blockEntity.limitingEnergyStorage.getMaxInsert(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()));
            } else {
                if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                    return;
                }
                EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.itemHandler, null).getSlots().get(0))));
                if (limitingEnergyStorage == null) {
                    return;
                }
                if (!limitingEnergyStorage.supportsInsertion()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = Math.max(0L, limitingEnergyStorage.getCapacity() - limitingEnergyStorage.getAmount());
                if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() == 0L) {
                    ChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    energyConsumptionPerTick = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxInsert(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                    transaction.commit();
                }
            }
            if (blockEntity.energyConsumptionLeft < 0L || energyConsumptionPerTick < 0L) {
                blockEntity.resetProgress();
                ChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                return;
            }
            try (Transaction transaction = Transaction.openOuter();){
                energyConsumptionPerTick = ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                transaction.commit();
            }
            blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
            if (blockEntity.energyConsumptionLeft <= 0L) {
                recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.method_5447(0, chargerRecipe.method_8110(level.method_30349()).method_46651(1)));
                blockEntity.resetProgress();
            }
            ChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress();
            ChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    protected final long getEnergyConsumptionPerTick() {
        if (this.field_11863 == null) {
            return -1L;
        }
        class_1799 stack = this.itemHandler.method_5438(0);
        Optional recipe = this.field_11863.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_1263)this.itemHandler, this.field_11863);
        if (recipe.isPresent()) {
            return Math.min(this.energyConsumptionLeft, Math.min(this.limitingEnergyStorage.getMaxInsert(), ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount()));
        }
        if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
            return -1L;
        }
        EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get(0))));
        if (limitingEnergyStorage == null) {
            return -1L;
        }
        if (!limitingEnergyStorage.supportsInsertion()) {
            return -1L;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long l = limitingEnergyStorage.insert(Math.min(this.limitingEnergyStorage.getMaxInsert(), ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount()), (TransactionContext)transaction);
            return l;
        }
    }

    private void resetProgress() {
        this.energyConsumptionLeft = -1L;
    }

    private boolean hasRecipe() {
        Optional recipe;
        class_1799 stack = this.itemHandler.method_5438(0);
        Optional optional = recipe = this.field_11863 == null ? Optional.empty() : this.field_11863.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_1263)this.itemHandler, this.field_11863);
        if (recipe.isPresent()) {
            return true;
        }
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

